-- Script para verificar y actualizar el procedimiento almacenado SP_REGISTRAR_TRAMITE_DERIVAR
-- Ejecuta este script en phpMyAdmin o MySQL Workbench

-- Paso 1: Ver el procedimiento actual
SHOW CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR;

-- Paso 2: Eliminar el procedimiento existente
DROP PROCEDURE IF EXISTS SP_REGISTRAR_TRAMITE_DERIVAR;

-- Paso 3: Crear el procedimiento actualizado con manejo correcto de NULL y documento_id como VARCHAR
DELIMITER $$

CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR(
    IN IDDO VARCHAR(50),
    IN ORIG INT,
    IN DEST INT,
    IN DESCRIP VARCHAR(255),
    IN IDUSU INT,
    IN RUTA VARCHAR(255),
    IN ACCION VARCHAR(20),
    IN VISIBLE_PUBLICO TINYINT
)
BEGIN
    DECLARE ESTATUS VARCHAR(20);

    -- Determinar el estatus según la acción
    IF ACCION = 'DERIVAR' THEN
        SET ESTATUS = 'PENDIENTE';
    ELSE
        SET ESTATUS = 'FINALIZADO';
    END IF;

    -- Insertar el movimiento con manejo correcto de NULL para area_destino_id
    INSERT INTO movimiento(
        documento_id,
        area_origen_id,
        area_destino_id,
        mov_descripcion,
        mov_estatus,
        mov_fecharegistro,
        usuario_id,
        mov_archivo,
        mov_visible_publico
    ) VALUES (
        IDDO,
        ORIG,
        -- Si DEST es 0 o NULL, insertar NULL; de lo contrario, insertar el valor
        IF(DEST = 0 OR DEST IS NULL, NULL, DEST),
        DESCRIP,
        ESTATUS,
        NOW(),
        IDUSU,
        RUTA,
        VISIBLE_PUBLICO
    );

    -- Actualizar el estado del documento (la columna se llama doc_estatus, no documento_estatus)
    UPDATE documento SET
        doc_estatus = ESTATUS
    WHERE documento_id = IDDO;
END$$

DELIMITER ;

-- Paso 4: Verificar que se creó correctamente
SELECT 'Procedimiento actualizado correctamente' AS Resultado;
SHOW CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR;
