<?php
// Script para verificar la estructura de la tabla usuario
require_once "model/model_conexion.php";

echo "<h2>Verificación de tabla USUARIO</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Ver estructura de la tabla usuario
    echo "<h3>1. Estructura de la tabla 'usuario':</h3>";
    $query = $pdo->prepare("DESCRIBE usuario");
    $query->execute();
    $columns = $query->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>Columna</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td><strong>" . $col['Field'] . "</strong></td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table><br>";

    echo "<hr>";

    // Ver algunos usuarios de ejemplo
    echo "<h3>2. Usuarios de ejemplo (primeros 5):</h3>";
    $query2 = $pdo->prepare("SELECT * FROM usuario LIMIT 5");
    $query2->execute();
    $users = $query2->fetchAll(PDO::FETCH_ASSOC);

    if (count($users) > 0) {
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";

        // Encabezados
        echo "<tr>";
        foreach (array_keys($users[0]) as $header) {
            echo "<th>$header</th>";
        }
        echo "</tr>";

        // Datos
        foreach ($users as $user) {
            echo "<tr>";
            foreach ($user as $value) {
                echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
            }
            echo "</tr>";
        }
        echo "</table>";
    }

    echo "<hr>";

    // Buscar el usuario ID 62 (el que creó el movimiento)
    echo "<h3>3. Usuario ID 62 (quien creó el movimiento):</h3>";
    $query3 = $pdo->prepare("SELECT * FROM usuario WHERE usuario_id = 62");
    $query3->execute();
    $user62 = $query3->fetch(PDO::FETCH_ASSOC);

    if ($user62) {
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>Campo</th><th>Valor</th></tr>";
        foreach ($user62 as $key => $value) {
            echo "<tr>";
            echo "<td><strong>$key</strong></td>";
            echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<br><p style='color: blue;'><strong>Área del usuario 62:</strong> ";
        if (isset($user62['area_id'])) {
            echo $user62['area_id'];
        } elseif (isset($user62['area_cod'])) {
            echo $user62['area_cod'];
        } else {
            echo "NO ENCONTRADO - necesitamos identificar el campo correcto";
        }
        echo "</p>";
    } else {
        echo "<p style='color: red;'>Usuario ID 62 no encontrado</p>";
    }

    echo "<hr>";

    // Buscar usuarios del área 19 (destino del trámite)
    echo "<h3>4. Usuarios del área 19 (destino del trámite):</h3>";

    // Intentar con diferentes nombres de columna
    $areaFields = ['area_id', 'area_cod', 'usu_area'];
    $foundUsers = false;

    foreach ($areaFields as $field) {
        try {
            $query4 = $pdo->prepare("SELECT * FROM usuario WHERE $field = 19 LIMIT 5");
            $query4->execute();
            $areaUsers = $query4->fetchAll(PDO::FETCH_ASSOC);

            if (count($areaUsers) > 0) {
                echo "<p style='color: green;'>✓ Encontrados usando el campo: <strong>$field</strong></p>";

                echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
                echo "<tr>";
                foreach (array_keys($areaUsers[0]) as $header) {
                    echo "<th>$header</th>";
                }
                echo "</tr>";

                foreach ($areaUsers as $user) {
                    echo "<tr>";
                    foreach ($user as $value) {
                        echo "<td>" . htmlspecialchars($value ?? 'NULL') . "</td>";
                    }
                    echo "</tr>";
                }
                echo "</table>";

                $foundUsers = true;
                break;
            }
        } catch (Exception $e) {
            // Campo no existe, intentar siguiente
        }
    }

    if (!$foundUsers) {
        echo "<p style='color: orange;'>⚠️ No se encontraron usuarios en el área 19</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    table { margin-bottom: 15px; }
</style>
