<?php
require_once "model/model_conexion.php";

$conexion = new ConexionDB();
$pdo = $conexion->conexionPDO();

echo "<h2>Verificación de Tablas</h2>";

// Ver todas las tablas
$query = $pdo->query("SHOW TABLES");
$tablas = $query->fetchAll(PDO::FETCH_COLUMN);

echo "<h3>Tablas en la base de datos:</h3>";
echo "<ul>";
foreach ($tablas as $tabla) {
    echo "<li>" . $tabla . "</li>";
}
echo "</ul>";

// Verificar si existe expediente
if (in_array('expediente', $tablas)) {
    echo "<p style='color: green;'>✓ La tabla 'expediente' existe</p>";
} else {
    echo "<p style='color: red;'>✗ La tabla 'expediente' NO existe</p>";
    echo "<p>Necesitamos modificar el SP para no usar esta tabla.</p>";
}

// Ver qué columnas tiene la tabla documento
echo "<hr>";
echo "<h3>Columnas de la tabla 'documento':</h3>";
$query2 = $pdo->query("SHOW COLUMNS FROM documento");
$columnas = $query2->fetchAll(PDO::FETCH_ASSOC);

echo "<table border='1' cellpadding='5'>";
echo "<tr><th>Campo</th><th>Tipo</th><th>Nulo</th><th>Key</th><th>Default</th></tr>";
foreach ($columnas as $col) {
    echo "<tr>";
    echo "<td>" . $col['Field'] . "</td>";
    echo "<td>" . $col['Type'] . "</td>";
    echo "<td>" . $col['Null'] . "</td>";
    echo "<td>" . $col['Key'] . "</td>";
    echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
    echo "</tr>";
}
echo "</table>";
?>
