<?php
// Script para verificar la estructura de la tabla documento
// Ejecutar desde: http://localhost/mesapartes.moralesmuni.gob.pe/verificar_estructura_documento.php

require_once "model/model_conexion.php";

echo "<h2>Estructura de la tabla 'documento'</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Obtener todas las columnas de la tabla documento
    $query = $pdo->prepare("DESCRIBE documento");
    $query->execute();
    $columns = $query->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Columna</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";

    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td><strong>" . $col['Field'] . "</strong></td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table><br>";

    // Buscar columnas que contengan "esta" o "status"
    echo "<h3>Columnas relacionadas con 'estado' o 'status':</h3>";
    $found = false;
    foreach ($columns as $col) {
        if (stripos($col['Field'], 'esta') !== false || stripos($col['Field'], 'status') !== false) {
            echo "- <strong>" . $col['Field'] . "</strong> (" . $col['Type'] . ")<br>";
            $found = true;
        }
    }

    if (!$found) {
        echo "<span style='color: red;'>⚠️ No se encontró ninguna columna relacionada con estado</span>";
    }

} catch (Exception $e) {
    echo "<span style='color: red;'>Error: " . $e->getMessage() . "</span>";
}
?>
