<?php
require_once "model/model_conexion.php";

echo "<h2>Verificación: Estados de movimientos del documento 001-2025</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Ver todos los movimientos del documento 001-2025
    $query = $pdo->prepare("
        SELECT
            movimiento_id,
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_estatus,
            mov_descripcion,
            mov_fecharegistro,
            origen.area_nombre AS area_origen_nombre,
            destino.area_nombre AS area_destino_nombre
        FROM movimiento
        LEFT JOIN area AS origen ON movimiento.area_origen_id = origen.area_cod
        LEFT JOIN area AS destino ON movimiento.area_destino_id = destino.area_cod
        WHERE documento_id = '001-2025'
        ORDER BY movimiento_id ASC
    ");
    $query->execute();
    $movimientos = $query->fetchAll(PDO::FETCH_ASSOC);

    if (count($movimientos) > 0) {
        echo "<p><strong>Total de movimientos:</strong> " . count($movimientos) . "</p>";

        echo "<table border='1' cellpadding='8' style='border-collapse: collapse; width: 100%; font-size: 13px;'>";
        echo "<tr style='background: #333; color: white;'>";
        echo "<th>ID</th>";
        echo "<th>Origen</th>";
        echo "<th>Destino</th>";
        echo "<th>mov_estatus</th>";
        echo "<th>Descripción</th>";
        echo "<th>Fecha</th>";
        echo "<th>¿Debería aparecer en lista?</th>";
        echo "</tr>";

        foreach ($movimientos as $mov) {
            $bgcolor = '';
            $debe_aparecer = '';

            if ($mov['mov_estatus'] == 'PENDIENTE') {
                $bgcolor = 'background: #ffffcc;';
                $debe_aparecer = "✅ SÍ - Está PENDIENTE en " . $mov['area_destino_nombre'];
            } elseif ($mov['mov_estatus'] == 'DERIVADO') {
                $bgcolor = 'background: #ccffcc;';
                $debe_aparecer = "❌ NO - Ya fue DERIVADO";
            } elseif ($mov['mov_estatus'] == 'FINALIZADO') {
                $bgcolor = 'background: #ccccff;';
                $debe_aparecer = "❌ NO - Ya fue FINALIZADO";
            }

            echo "<tr style='$bgcolor'>";
            echo "<td>" . $mov['movimiento_id'] . "</td>";
            echo "<td>" . $mov['area_origen_nombre'] . "</td>";
            echo "<td>" . ($mov['area_destino_nombre'] ?: '<em>NULL (finalizado)</em>') . "</td>";
            echo "<td style='font-weight: bold;'>" . $mov['mov_estatus'] . "</td>";
            echo "<td>" . $mov['mov_descripcion'] . "</td>";
            echo "<td>" . $mov['mov_fecharegistro'] . "</td>";
            echo "<td>$debe_aparecer</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<hr>";
        echo "<h3>Análisis del problema:</h3>";

        $pendientes = array_filter($movimientos, function($m) { return $m['mov_estatus'] == 'PENDIENTE'; });
        $derivados = array_filter($movimientos, function($m) { return $m['mov_estatus'] == 'DERIVADO'; });

        if (count($pendientes) > 1) {
            echo "<p style='color: red; font-weight: bold;'>❌ PROBLEMA: Hay " . count($pendientes) . " movimientos PENDIENTES</p>";
            echo "<p>Cuando derivas un trámite, el movimiento ANTERIOR debe cambiar a 'DERIVADO'</p>";
            echo "<p><strong>Movimientos que deberían estar DERIVADO:</strong></p>";
            echo "<ul>";
            foreach ($pendientes as $mov) {
                if ($mov['movimiento_id'] != max(array_column($movimientos, 'movimiento_id'))) {
                    echo "<li>Movimiento ID " . $mov['movimiento_id'] . " (de " . $mov['area_origen_nombre'] . " a " . $mov['area_destino_nombre'] . ")</li>";
                }
            }
            echo "</ul>";
        } else {
            echo "<p style='color: green; font-weight: bold;'>✓ Correcto: Solo hay 1 movimiento PENDIENTE (el último)</p>";
        }

        if (count($derivados) == 0 && count($movimientos) > 1) {
            echo "<p style='color: red; background: #fff0f0; padding: 10px;'>";
            echo "<strong>⚠️ PROBLEMA DETECTADO:</strong><br>";
            echo "El SP_REGISTRAR_TRAMITE_DERIVAR NO está actualizando el estatus del movimiento anterior.<br>";
            echo "Cuando derivas un trámite, debe ejecutar:<br>";
            echo "<code>UPDATE movimiento SET mov_estatus = 'DERIVADO' WHERE ...</code>";
            echo "</p>";
        }

    } else {
        echo "<p style='color: red;'>No hay movimientos para el documento 001-2025</p>";
    }

    echo "<hr>";

    // Ver qué está devolviendo el SP para el usuario de Mesa de Partes (ID 22, área 19)
    echo "<h3>Prueba del SP_LISTAR_TRAMITE_AREA para usuario 22 (Mesa de Partes):</h3>";

    $query2 = $pdo->prepare("CALL SP_LISTAR_TRAMITE_AREA(?, ?)");
    $query2->execute([22, '']);
    $resultadoSP = $query2->fetchAll(PDO::FETCH_ASSOC);

    echo "<p><strong>El SP devuelve:</strong> " . count($resultadoSP) . " trámite(s)</p>";

    if (count($resultadoSP) > 0) {
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>documento_id</th><th>origen</th><th>destino</th><th>mov_estatus</th></tr>";
        foreach ($resultadoSP as $fila) {
            echo "<tr>";
            echo "<td>" . $fila['documento_id'] . "</td>";
            echo "<td>" . $fila['origen'] . "</td>";
            echo "<td>" . $fila['destino'] . "</td>";
            echo "<td>" . $fila['mov_estatus'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";

        if (count($resultadoSP) > 1) {
            echo "<p style='color: red;'>⚠️ El documento 001-2025 aparece en la lista aunque ya fue derivado</p>";
        }
    } else {
        echo "<p style='color: green;'>✓ Correcto: No devuelve ningún trámite (porque todos fueron derivados)</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    code { background: #f0f0f0; padding: 2px 5px; border-radius: 3px; }
</style>
