<?php
require_once "model/model_conexion.php";

echo "<h2>Diagnóstico: Últimos movimientos registrados</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Ver los últimos 5 movimientos
    echo "<h3>Últimos movimientos (ordenados por ID descendente):</h3>";
    $query = $pdo->prepare("
        SELECT
            movimiento.*,
            documento.doc_dniremitente,
            CONCAT_WS(' ', documento.doc_nombreremitente, documento.doc_apepatremitente, documento.doc_apematremitente) AS remitente,
            area_origen.area_nombre AS area_origen_nombre,
            area_destino.area_nombre AS area_destino_nombre
        FROM movimiento
        LEFT JOIN documento ON movimiento.documento_id = documento.documento_id
        LEFT JOIN area AS area_origen ON movimiento.area_origen_id = area_origen.area_cod
        LEFT JOIN area AS area_destino ON movimiento.area_destino_id = area_destino.area_cod
        ORDER BY movimiento.movimiento_id DESC
        LIMIT 5
    ");
    $query->execute();
    $movimientos = $query->fetchAll(PDO::FETCH_ASSOC);

    if (count($movimientos) > 0) {
        foreach ($movimientos as $mov) {
            echo "<div style='border: 1px solid #ccc; padding: 15px; margin-bottom: 15px; background: #f9f9f9;'>";
            echo "<h4>Movimiento ID: " . $mov['movimiento_id'] . " - Documento: " . $mov['documento_id'] . "</h4>";

            echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
            echo "<tr><th style='width: 200px;'>Campo</th><th>Valor</th></tr>";

            echo "<tr><td><strong>documento_id</strong></td><td>" . $mov['documento_id'] . "</td></tr>";
            echo "<tr><td><strong>mov_estatus</strong></td><td style='background: " . ($mov['mov_estatus'] == 'PENDIENTE' ? '#ffffcc' : '#ccffcc') . "; font-weight: bold;'>" . $mov['mov_estatus'] . "</td></tr>";
            echo "<tr><td><strong>mov_descripcion</strong></td><td>" . ($mov['mov_descripcion'] ?? '<span style="color: red;">VACÍO</span>') . "</td></tr>";
            echo "<tr><td><strong>mov_archivo</strong></td><td>" . ($mov['mov_archivo'] ?? '<span style="color: red;">VACÍO</span>') . "</td></tr>";
            echo "<tr><td><strong>mov_visible_publico</strong></td><td style='background: " . ($mov['mov_visible_publico'] == 1 ? '#ccffcc' : '#ffcccc') . "; font-weight: bold;'>" . $mov['mov_visible_publico'] . "</td></tr>";
            echo "<tr><td><strong>area_origen_id</strong></td><td>" . $mov['area_origen_id'] . " (" . $mov['area_origen_nombre'] . ")</td></tr>";
            echo "<tr><td><strong>area_destino_id</strong></td><td>" . ($mov['area_destino_id'] ?? 'NULL') . " (" . ($mov['area_destino_nombre'] ?? 'SIN DESTINO') . ")</td></tr>";
            echo "<tr><td><strong>usuario_id</strong></td><td>" . $mov['usuario_id'] . "</td></tr>";
            echo "<tr><td><strong>mov_fecharegistro</strong></td><td>" . $mov['mov_fecharegistro'] . "</td></tr>";

            echo "</table>";
            echo "</div>";
        }
    }

    echo "<hr>";

    // Verificar el documento 001-2025 específicamente
    echo "<h3>Todos los movimientos del documento 001-2025:</h3>";
    $query2 = $pdo->prepare("
        SELECT
            movimiento.*,
            area_origen.area_nombre AS area_origen_nombre,
            area_destino.area_nombre AS area_destino_nombre
        FROM movimiento
        LEFT JOIN area AS area_origen ON movimiento.area_origen_id = area_origen.area_cod
        LEFT JOIN area AS area_destino ON movimiento.area_destino_id = area_destino.area_cod
        WHERE movimiento.documento_id = '001-2025'
        ORDER BY movimiento.movimiento_id ASC
    ");
    $query2->execute();
    $movimientos_doc = $query2->fetchAll(PDO::FETCH_ASSOC);

    if (count($movimientos_doc) > 0) {
        echo "<p><strong>Total de movimientos:</strong> " . count($movimientos_doc) . "</p>";

        echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%; font-size: 12px;'>";
        echo "<tr>";
        echo "<th>ID</th>";
        echo "<th>Estatus</th>";
        echo "<th>Descripción</th>";
        echo "<th>Archivo</th>";
        echo "<th>Visible Público</th>";
        echo "<th>Origen</th>";
        echo "<th>Destino</th>";
        echo "<th>Fecha</th>";
        echo "</tr>";

        foreach ($movimientos_doc as $mov) {
            echo "<tr>";
            echo "<td>" . $mov['movimiento_id'] . "</td>";
            echo "<td style='background: " . ($mov['mov_estatus'] == 'PENDIENTE' ? '#ffffcc' : ($mov['mov_estatus'] == 'FINALIZADO' ? '#ccffcc' : '#ccccff')) . "'><strong>" . $mov['mov_estatus'] . "</strong></td>";
            echo "<td>" . ($mov['mov_descripcion'] ?: '<span style="color: #999;">vacío</span>') . "</td>";
            echo "<td>" . ($mov['mov_archivo'] ?: '<span style="color: #999;">vacío</span>') . "</td>";
            echo "<td style='background: " . ($mov['mov_visible_publico'] == 1 ? '#ccffcc' : '#ffcccc') . "; text-align: center;'><strong>" . $mov['mov_visible_publico'] . "</strong></td>";
            echo "<td>" . $mov['area_origen_nombre'] . "</td>";
            echo "<td>" . ($mov['area_destino_nombre'] ?: '<span style="color: orange;">NULL (FINALIZADO)</span>') . "</td>";
            echo "<td>" . $mov['mov_fecharegistro'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<hr>";
        echo "<h4>Análisis:</h4>";
        $ultimo = end($movimientos_doc);

        if ($ultimo['mov_estatus'] == 'PENDIENTE') {
            echo "<p style='color: red;'>❌ El último movimiento está PENDIENTE - Por eso sigue apareciendo en la lista</p>";
            echo "<p><strong>Problema:</strong> El SP_REGISTRAR_TRAMITE_DERIVAR NO está actualizando el estatus correctamente</p>";
        } else {
            echo "<p style='color: green;'>✓ El último movimiento está " . $ultimo['mov_estatus'] . "</p>";
        }

        if (empty($ultimo['mov_descripcion'])) {
            echo "<p style='color: red;'>❌ La descripción está VACÍA - No se guardó</p>";
        } else {
            echo "<p style='color: green;'>✓ La descripción se guardó: " . $ultimo['mov_descripcion'] . "</p>";
        }

        if (empty($ultimo['mov_archivo'])) {
            echo "<p style='color: red;'>❌ El archivo está VACÍO - No se guardó la ruta</p>";
        } else {
            echo "<p style='color: green;'>✓ El archivo se guardó: " . $ultimo['mov_archivo'] . "</p>";
        }

        if ($ultimo['mov_visible_publico'] == 0) {
            echo "<p style='color: red;'>❌ mov_visible_publico = 0 - El checkbox NO se marcó o NO se guardó</p>";
        } else {
            echo "<p style='color: green;'>✓ mov_visible_publico = 1 - Marcado como visible</p>";
        }
    } else {
        echo "<p style='color: red;'>No hay movimientos para el documento 001-2025</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
</style>
