<?php
// Script para ver las tablas de la base de datos
require_once "model/model_conexion.php";

echo "<h2>Tablas en la base de datos</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Ver todas las tablas
    $query = $pdo->prepare("SHOW TABLES");
    $query->execute();
    $tables = $query->fetchAll(PDO::FETCH_COLUMN);

    echo "<h3>Tablas encontradas:</h3>";
    echo "<ul>";
    foreach ($tables as $table) {
        echo "<li><strong>$table</strong></li>";
    }
    echo "</ul>";

    echo "<hr>";

    // Buscar tablas relacionadas con tipo o tramite
    echo "<h3>Tablas relacionadas con 'tipo' o 'tramite':</h3>";
    $related = array_filter($tables, function($t) {
        return stripos($t, 'tipo') !== false || stripos($t, 'tramite') !== false;
    });

    if (count($related) > 0) {
        foreach ($related as $table) {
            echo "<h4>Estructura de: $table</h4>";
            $query2 = $pdo->prepare("DESCRIBE $table");
            $query2->execute();
            $columns = $query2->fetchAll(PDO::FETCH_ASSOC);

            echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
            echo "<tr><th>Columna</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
            foreach ($columns as $col) {
                echo "<tr>";
                echo "<td><strong>" . $col['Field'] . "</strong></td>";
                echo "<td>" . $col['Type'] . "</td>";
                echo "<td>" . $col['Null'] . "</td>";
                echo "<td>" . $col['Key'] . "</td>";
                echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
                echo "</tr>";
            }
            echo "</table><br>";
        }
    } else {
        echo "<p>No se encontraron tablas relacionadas.</p>";
    }

    echo "<hr>";

    // Ver estructura de la tabla documento
    echo "<h3>Estructura de la tabla 'documento':</h3>";
    $query3 = $pdo->prepare("DESCRIBE documento");
    $query3->execute();
    $docColumns = $query3->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>Columna</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach ($docColumns as $col) {
        echo "<tr>";
        echo "<td><strong>" . $col['Field'] . "</strong></td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";

    // Ver el procedimiento almacenado ORIGINAL (antes de mi cambio)
    echo "<hr>";
    echo "<h3>Buscar procedimiento original SP_LISTAR_TRAMITE_AREA en backups:</h3>";

    // Ver todos los procedimientos
    $query4 = $pdo->prepare("SHOW PROCEDURE STATUS WHERE Db = DATABASE()");
    $query4->execute();
    $procedures = $query4->fetchAll(PDO::FETCH_ASSOC);

    echo "<p>Procedimientos encontrados:</p><ul>";
    foreach ($procedures as $proc) {
        echo "<li>" . $proc['Name'] . "</li>";
    }
    echo "</ul>";

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    table { margin-bottom: 15px; }
</style>
