<?php
header('Content-Type: text/html; charset=utf-8');

try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=munimor9_bdmoralestramite;charset=utf8mb4',
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "<style>
        body { font-family: monospace; background: #f5f5f5; padding: 20px; }
        pre { background: white; padding: 15px; border-left: 4px solid #4CAF50; overflow-x: auto; }
        h2 { color: #2196F3; }
    </style>";

    echo "<h2>🔍 STORED PROCEDURES DE REGISTRO</h2>";

    $procedures = [
        'SP_REGISTRAR_DOCUMENTO',
        'SP_REGISTRAR_TRAMITE',
        'SP_INSERTAR_TRAMITE',
        'SP_CREAR_DOCUMENTO'
    ];

    foreach ($procedures as $sp) {
        echo "<hr><h3>📋 $sp</h3>";
        try {
            $stmt = $pdo->prepare("SHOW CREATE PROCEDURE $sp");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($result) {
                echo "<pre>" . htmlspecialchars($result['Create Procedure']) . "</pre>";
            }
        } catch (PDOException $e) {
            echo "<pre style='background:#ffebee;'>❌ No existe: " . $e->getMessage() . "</pre>";
        }
    }

} catch (PDOException $e) {
    echo "<pre style='background:#ffebee;'>❌ ERROR: " . $e->getMessage() . "</pre>";
}
?>
