<?php
require_once "model/model_conexion.php";

echo "<h2>Procedimiento almacenado actual: SP_REGISTRAR_TRAMITE_DERIVAR</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    $query = $pdo->prepare("SHOW CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        $sp_code = $result['Create Procedure'];

        echo "<pre style='background: #f4f4f4; padding: 15px; overflow: auto; border-left: 3px solid #007bff;'>";
        echo htmlspecialchars($sp_code);
        echo "</pre>";

        echo "<hr>";
        echo "<h3>Verificación:</h3>";

        // Verificar si tiene el UPDATE para cambiar estado anterior
        if (strpos($sp_code, 'UPDATE movimiento') !== false) {
            echo "<p style='color: green;'>✓ El SP incluye un UPDATE movimiento</p>";

            if (strpos($sp_code, "mov_estatus = ACCION") !== false || strpos($sp_code, "mov_estatus = 'DERIVADO'") !== false) {
                echo "<p style='color: green;'>✓ El UPDATE cambia el mov_estatus</p>";
            } else {
                echo "<p style='color: red;'>❌ El UPDATE NO cambia el mov_estatus correctamente</p>";
            }
        } else {
            echo "<p style='color: red; background: #fff0f0; padding: 10px;'>";
            echo "<strong>❌ PROBLEMA ENCONTRADO:</strong><br>";
            echo "El SP NO tiene un UPDATE para cambiar el estado del movimiento anterior.<br>";
            echo "Necesitas ejecutar el archivo: <strong>correccion_sp_derivar.sql</strong>";
            echo "</p>";
        }

        // Verificar si maneja el campo VISIBLE_PUBLICO
        if (strpos($sp_code, 'VISIBLE_PUBLICO') !== false) {
            echo "<p style='color: green;'>✓ El SP incluye el parámetro VISIBLE_PUBLICO</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ El SP NO incluye el parámetro VISIBLE_PUBLICO</p>";
        }

    } else {
        echo "<p style='color: red;'>⚠️ El procedimiento SP_REGISTRAR_TRAMITE_DERIVAR NO existe</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
</style>
