<?php
require_once "model/model_conexion.php";

echo "<h2>Valores de doc_representacion en la base de datos</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Ver valores distintos de doc_representacion
    $query = $pdo->prepare("SELECT DISTINCT doc_representacion, COUNT(*) as cantidad FROM documento GROUP BY doc_representacion");
    $query->execute();
    $representaciones = $query->fetchAll(PDO::FETCH_ASSOC);

    echo "<h3>Valores únicos de doc_representacion:</h3>";
    echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
    echo "<tr><th>doc_representacion</th><th>Cantidad de documentos</th></tr>";

    foreach ($representaciones as $rep) {
        echo "<tr>";
        echo "<td><strong>" . htmlspecialchars($rep['doc_representacion']) . "</strong></td>";
        echo "<td>" . $rep['cantidad'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";

    echo "<hr>";

    // Ver el documento 001-2025 específicamente
    echo "<h3>Documento 001-2025:</h3>";
    $query2 = $pdo->prepare("SELECT documento_id, doc_representacion FROM documento WHERE documento_id = '001-2025'");
    $query2->execute();
    $doc = $query2->fetch(PDO::FETCH_ASSOC);

    if ($doc) {
        echo "<p><strong>documento_id:</strong> " . $doc['documento_id'] . "</p>";
        echo "<p><strong>doc_representacion:</strong> " . htmlspecialchars($doc['doc_representacion']) . "</p>";

        if ($doc['doc_representacion'] == '1') {
            echo "<p style='color: green;'>✓ Es un trámite INTERNO (valor = '1')</p>";
        } elseif ($doc['doc_representacion'] == '0') {
            echo "<p style='color: blue;'>✓ Es un trámite EXTERNO (valor = '0')</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ Tiene un valor diferente: '" . htmlspecialchars($doc['doc_representacion']) . "'</p>";
            echo "<p>Este podría ser el problema. El filtro busca '1' o '0' pero el documento tiene otro valor.</p>";
        }
    }

    echo "<hr>";

    echo "<h3>Solución sugerida:</h3>";
    echo "<p>El campo doc_representacion parece almacenar texto descriptivo ('A NOMBRE PROPIO', 'EN REPRESENTACION', etc.) ";
    echo "en lugar de valores numéricos ('0' o '1').</p>";
    echo "<p>Hay dos opciones:</p>";
    echo "<ol>";
    echo "<li><strong>Opción 1:</strong> Modificar el SP para mapear los valores de texto a numéricos</li>";
    echo "<li><strong>Opción 2:</strong> Modificar la página para no filtrar por defecto (mostrar todos)</li>";
    echo "</ol>";

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
</style>
