<?php
// Script para capturar exactamente qué devuelve el controlador AJAX
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Simular la llamada POST
$_POST['idusuario'] = 1; // Cambiar por tu ID de usuario
$_POST['tipoRecibido'] = '';

echo "=== CAPTURA DE RESPUESTA DEL CONTROLADOR ===<br><br>";
echo "Llamando a: controller/tramite_area/controller_listar_tramite.php<br><br>";

ob_start();
include 'controller/tramite_area/controller_listar_tramite.php';
$output = ob_get_clean();

echo "<h3>Respuesta capturada:</h3>";
echo "<pre style='background: #f0f0f0; padding: 10px; border: 1px solid #ccc;'>";
echo htmlspecialchars($output);
echo "</pre>";

echo "<h3>Longitud:</h3>";
echo strlen($output) . " caracteres<br><br>";

echo "<h3>¿Es JSON válido?</h3>";
$decoded = json_decode($output, true);
if (json_last_error() === JSON_ERROR_NONE) {
    echo "<span style='color: green; font-weight: bold;'>✓ SÍ - JSON válido</span><br><br>";
    echo "<h3>Datos decodificados:</h3>";
    echo "<pre>";
    print_r($decoded);
    echo "</pre>";
} else {
    echo "<span style='color: red; font-weight: bold;'>✗ NO - Error: " . json_last_error_msg() . "</span><br><br>";

    echo "<h3>Primeros 500 caracteres:</h3>";
    echo "<pre style='background: #fff0f0; padding: 10px; border: 1px solid #f00;'>";
    echo htmlspecialchars(substr($output, 0, 500));
    echo "</pre>";

    echo "<h3>Últimos 200 caracteres:</h3>";
    echo "<pre style='background: #fff0f0; padding: 10px; border: 1px solid #f00;'>";
    echo htmlspecialchars(substr($output, -200));
    echo "</pre>";
}
?>
