<?php
// Script de diagnóstico para verificar qué está devolviendo el controlador
session_start();

// Simular datos de sesión si no existen
if (!isset($_SESSION['S_ID'])) {
    $_SESSION['S_ID'] = 62; // Usar el ID del usuario actual
}

echo "<h2>Test: Listar Tramites Derivados</h2>";
echo "<p><strong>Usuario ID:</strong> " . $_SESSION['S_ID'] . "</p>";

echo "<hr>";
echo "<h3>1. Verificando que el SP existe...</h3>";

require_once "model/model_conexion.php";
$conexion = new ConexionDB();
$pdo = $conexion->conexionPDO();

$query = $pdo->prepare("SHOW PROCEDURE STATUS WHERE Db = DATABASE() AND Name = 'SP_LISTAR_TRAMITE_AREA_DERIVADO'");
$query->execute();
$sp_exists = $query->fetch(PDO::FETCH_ASSOC);

if ($sp_exists) {
    echo "<p style='color: green;'>✓ El SP existe en la base de datos</p>";
} else {
    echo "<p style='color: red; font-weight: bold;'>✗ EL SP NO EXISTE. Debes ejecutar el script crear_sp_listar_tramite_derivado.sql en phpMyAdmin</p>";
    echo "<p>El script está en: crear_sp_listar_tramite_derivado.sql</p>";
    exit;
}

echo "<hr>";
echo "<h3>2. Probando directamente el modelo...</h3>";

require_once "model/model_tramite_area.php";
$modelo = new Modelo_TramiteArea();

try {
    $resultado = $modelo->Listar_Tramite_Derivado($_SESSION['S_ID']);
    echo "<p style='color: green;'>✓ Modelo ejecutado sin errores</p>";

    if (isset($resultado['data']) && count($resultado['data']) > 0) {
        echo "<p><strong>Se encontraron " . count($resultado['data']) . " trámites derivados</strong></p>";
        echo "<pre>";
        print_r($resultado);
        echo "</pre>";
    } else {
        echo "<p style='color: orange;'>⚠ No hay trámites derivados para este usuario</p>";
        echo "<p>Esto es normal si no has derivado ningún trámite todavía.</p>";
        echo "<pre>";
        print_r($resultado);
        echo "</pre>";
    }

    // Probar JSON encoding
    $json_output = json_encode($resultado);
    echo "<h4>JSON generado:</h4>";
    echo "<pre>" . htmlspecialchars($json_output) . "</pre>";

} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error en modelo: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<hr>";
echo "<h3>3. Probando el SP directamente...</h3>";

try {
    $query2 = $pdo->prepare("CALL SP_LISTAR_TRAMITE_AREA_DERIVADO(?)");
    $query2->execute([$_SESSION['S_ID']]);
    $resultado_sp = $query2->fetchAll(PDO::FETCH_ASSOC);

    echo "<p style='color: green;'>✓ SP ejecutado correctamente</p>";
    echo "<p><strong>Registros devueltos:</strong> " . count($resultado_sp) . "</p>";

    if (count($resultado_sp) > 0) {
        echo "<pre>";
        print_r($resultado_sp);
        echo "</pre>";
    } else {
        echo "<p style='color: orange;'>⚠ El SP no devolvió registros. Verifica que hayas derivado algún trámite.</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error al ejecutar SP: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>4. Verificando trámites en la base de datos...</h3>";

try {
    // Ver el área del usuario
    $query3 = $pdo->prepare("SELECT area_id FROM usuario WHERE usu_id = ?");
    $query3->execute([$_SESSION['S_ID']]);
    $area_usuario = $query3->fetch(PDO::FETCH_ASSOC);

    echo "<p><strong>Área del usuario:</strong> " . ($area_usuario['area_id'] ?? 'No encontrada') . "</p>";

    if ($area_usuario) {
        // Ver movimientos DERIVADOS desde ese área
        $query4 = $pdo->prepare("
            SELECT COUNT(*) as total
            FROM movimiento
            WHERE area_origen_id = ?
            AND mov_estatus = 'DERIVADO'
        ");
        $query4->execute([$area_usuario['area_id']]);
        $count = $query4->fetch(PDO::FETCH_ASSOC);

        echo "<p><strong>Trámites derivados desde tu área:</strong> " . $count['total'] . "</p>";

        if ($count['total'] == 0) {
            echo "<p style='color: orange;'>⚠ No hay trámites derivados. Para probar:</p>";
            echo "<ol>";
            echo "<li>Ve a 'Tramites Recibidos'</li>";
            echo "<li>Deriva un trámite a otra área</li>";
            echo "<li>Luego debería aparecer en 'Tramites Derivados'</li>";
            echo "</ol>";
        }
    }

} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h3>Conclusión:</h3>";
echo "<p>Si todo está en verde arriba, el problema está resuelto y la página debería funcionar.</p>";
echo "<p>Si ves que no hay trámites derivados, es normal - necesitas derivar algún trámite primero.</p>";
?>
