<?php
require_once "model/model_conexion.php";

echo "<h2>Test: SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    $documento_id = '001-2025';

    echo "<h3>1. Ejecutando SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE('$documento_id'):</h3>";

    $query = $pdo->prepare("CALL SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE(?)");
    $query->execute([$documento_id]);
    $resultados = $query->fetchAll(PDO::FETCH_ASSOC);

    if (count($resultados) > 0) {
        echo "<p style='color: green;'><strong>✓ El SP devuelve " . count($resultados) . " movimiento(s)</strong></p>";

        echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%; font-size: 12px;'>";
        echo "<tr>";
        echo "<th>Índice (i)</th>";
        echo "<th>[0] movimiento_id</th>";
        echo "<th>[1] documento_id</th>";
        echo "<th>[2] area_nombre (destino)</th>";
        echo "<th>[3] mov_fecharegistro</th>";
        echo "<th>[4] mov_descripcion</th>";
        echo "<th>[5] mov_estatus</th>";
        echo "<th>[6] area_nombre (origen)</th>";
        echo "<th>[7] mov_descripcion_original</th>";
        echo "<th>[8] mov_archivo (filtrado)</th>";
        echo "</tr>";

        foreach ($resultados as $index => $row) {
            echo "<tr>";
            echo "<td style='background: #ffffcc; font-weight: bold;'>$index</td>";
            echo "<td>" . $row['movimiento_id'] . "</td>";
            echo "<td>" . $row['documento_id'] . "</td>";
            echo "<td>" . ($row['area_nombre'] ?? 'NULL') . "</td>";
            echo "<td>" . $row['mov_fecharegistro'] . "</td>";
            echo "<td>" . ($row['mov_descripcion'] ?? '<span style="color: #999;">vacío</span>') . "</td>";
            echo "<td style='background: " . ($row['mov_estatus'] == 'PENDIENTE' ? '#ffffcc' : '#ccffcc') . "'><strong>" . $row['mov_estatus'] . "</strong></td>";

            // El índice 6 debería ser el segundo area_nombre (origen)
            // Pero el SP actual devuelve solo un area_nombre, necesitamos verificar
            $keys = array_keys($row);
            echo "<td>";
            if (count($keys) > 6) {
                echo $row[$keys[6]] ?? 'NULL';
            } else {
                echo "ÍNDICE NO EXISTE";
            }
            echo "</td>";

            echo "<td>";
            if (count($keys) > 7) {
                echo $row[$keys[7]] ?? 'NULL';
            } else {
                echo "ÍNDICE NO EXISTE";
            }
            echo "</td>";

            echo "<td style='background: " . (empty($row['mov_archivo']) ? '#ffcccc' : '#ccffcc') . "'>";
            if (count($keys) > 8) {
                echo $row[$keys[8]] ?? '<span style="color: red; font-weight: bold;">NULL - NO SE MOSTRARÁ</span>';
            } else {
                echo "ÍNDICE NO EXISTE";
            }
            echo "</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<hr>";

        echo "<h3>2. Estructura completa de cada fila:</h3>";
        foreach ($resultados as $index => $row) {
            echo "<h4>Fila $index (Movimiento ID: " . $row['movimiento_id'] . "):</h4>";
            echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
            echo "<tr><th>Clave</th><th>Valor</th></tr>";

            $arrayIndex = 0;
            foreach ($row as $key => $value) {
                echo "<tr>";
                echo "<td><strong>[$arrayIndex] $key</strong></td>";
                echo "<td>" . ($value ?? '<span style="color: #999;">NULL</span>') . "</td>";
                echo "</tr>";
                $arrayIndex++;
            }
            echo "</table><br>";
        }

        echo "<hr>";

        echo "<h3>3. Verificación para JavaScript:</h3>";
        echo "<p>El JavaScript en menu.js usa <code>dataDetalle[i][8]</code> para obtener el archivo.</p>";

        foreach ($resultados as $index => $row) {
            $arrayValues = array_values($row);
            echo "<p><strong>Fila $index:</strong></p>";
            echo "<ul>";
            echo "<li><code>dataDetalle[$index][0]</code> = " . ($arrayValues[0] ?? 'undefined') . " (movimiento_id)</li>";
            echo "<li><code>dataDetalle[$index][5]</code> = " . ($arrayValues[5] ?? 'undefined') . " (mov_estatus)</li>";
            echo "<li><code>dataDetalle[$index][8]</code> = " . ($arrayValues[8] ?? '<span style="color: red; font-weight: bold;">undefined - PROBLEMA!</span>') . " (mov_archivo)</li>";
            echo "</ul>";

            if (!isset($arrayValues[8]) || empty($arrayValues[8])) {
                echo "<p style='color: red; background: #fff0f0; padding: 10px;'>";
                echo "❌ <strong>PROBLEMA ENCONTRADO:</strong> El índice [8] está vacío o no existe.<br>";
                echo "El JavaScript NO mostrará el botón de descarga para este movimiento.";
                echo "</p>";
            } else {
                echo "<p style='color: green; background: #f0fff0; padding: 10px;'>";
                echo "✓ El índice [8] tiene valor. El botón de descarga DEBERÍA aparecer.";
                echo "</p>";
            }
        }

    } else {
        echo "<p style='color: red;'><strong>❌ El SP NO devuelve ningún resultado</strong></p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    table { margin-bottom: 15px; }
</style>
