<?php
// Script de diagnóstico para ver qué devuelve el controlador de listado de trámites
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Diagnóstico: Controller Listar Tramite</h2>";

require "model/model_tramite_area.php";

try {
    // Simular una llamada con datos de ejemplo
    $idusuario = 1; // Cambiar por un ID de usuario real
    $tipo_re = ""; // Dejar vacío para ver todos

    echo "<h3>Parámetros de prueba:</h3>";
    echo "Usuario ID: $idusuario<br>";
    echo "Tipo recibido: " . ($tipo_re ? $tipo_re : "(vacío)") . "<br><br>";

    $MU = new Modelo_TramiteArea();

    echo "<h3>Intentando ejecutar SP_LISTAR_TRAMITE_AREA...</h3>";

    $consulta = $MU->Listar_Tramite($idusuario, $tipo_re);

    echo "<h3>Resultado:</h3>";
    echo "<pre>";
    print_r($consulta);
    echo "</pre>";

    echo "<h3>JSON generado:</h3>";
    echo "<pre>";
    echo json_encode($consulta);
    echo "</pre>";

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo "<p style='color: red;'><strong>Error JSON:</strong> " . json_last_error_msg() . "</p>";
    } else {
        echo "<p style='color: green;'><strong>✓ JSON válido</strong></p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<hr>";
echo "<h3>Verificar si el procedimiento almacenado existe:</h3>";

try {
    require_once "model/model_conexion.php";
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    $query = $pdo->prepare("SHOW PROCEDURE STATUS WHERE Db = DATABASE() AND Name = 'SP_LISTAR_TRAMITE_AREA'");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo "<p style='color: green;'>✓ El procedimiento SP_LISTAR_TRAMITE_AREA existe</p>";

        // Ver definición
        $query2 = $pdo->prepare("SHOW CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA");
        $query2->execute();
        $def = $query2->fetch(PDO::FETCH_ASSOC);

        echo "<h4>Definición actual:</h4>";
        echo "<pre style='background: #f4f4f4; padding: 10px; overflow: auto;'>";
        echo htmlspecialchars($def['Create Procedure']);
        echo "</pre>";
    } else {
        echo "<p style='color: red;'>⚠️ El procedimiento SP_LISTAR_TRAMITE_AREA NO existe</p>";
        echo "<p>Necesitas ejecutar el script SQL: soluciones_finales.sql</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error al verificar:</strong> " . $e->getMessage() . "</p>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    pre { background: #f9f9f9; padding: 10px; border-left: 3px solid #007bff; }
</style>
