<?php
session_start();
require_once "model/model_tramite_area.php";

echo "<h2>Test del controlador AJAX de listado de trámites</h2>";

// Verificar sesión
if (!isset($_SESSION['S_ID'])) {
    echo "<p style='color: red;'>⚠️ No hay sesión activa. Inicia sesión primero.</p>";
    exit;
}

$usuario_id = $_SESSION['S_ID'];

echo "<h3>1. Parámetros:</h3>";
echo "<p><strong>Usuario ID:</strong> $usuario_id</p>";
echo "<p><strong>Tipo recibido:</strong> '' (vacío - todos)</p>";

echo "<hr>";

echo "<h3>2. Llamando al modelo:</h3>";

try {
    $MU = new Modelo_TramiteArea();
    $idusuario = $usuario_id;
    $tipo_re = '';

    echo "<p>Ejecutando: \$MU->Listar_Tramite($idusuario, '$tipo_re')</p>";

    $consulta = $MU->Listar_Tramite($idusuario, $tipo_re);

    echo "<h3>3. Resultado del modelo:</h3>";
    echo "<pre style='background: #f0f0f0; padding: 10px; border: 1px solid #ccc;'>";
    print_r($consulta);
    echo "</pre>";

    echo "<hr>";

    echo "<h3>4. JSON que se enviaría al frontend:</h3>";
    $json = json_encode($consulta);
    echo "<pre style='background: #f0fff0; padding: 10px; border: 1px solid #0a0;'>";
    echo htmlspecialchars($json);
    echo "</pre>";

    echo "<hr>";

    echo "<h3>5. Validación:</h3>";
    if ($consulta && isset($consulta['data']) && count($consulta['data']) > 0) {
        echo "<p style='color: green; font-weight: bold;'>✓ El controlador devuelve " . count($consulta['data']) . " registro(s)</p>";
        echo "<p style='color: green;'>✓ El JSON es válido</p>";

        echo "<h4>Datos del primer registro:</h4>";
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>Campo</th><th>Valor</th></tr>";
        foreach ($consulta['data'][0] as $key => $value) {
            echo "<tr><td><strong>$key</strong></td><td>" . htmlspecialchars($value ?? 'NULL') . "</td></tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red; font-weight: bold;'>⚠️ El controlador NO devuelve datos</p>";

        if (empty($consulta)) {
            echo "<p>La consulta está vacía (empty)</p>";
        } elseif (!isset($consulta['data'])) {
            echo "<p>El array no tiene la clave 'data'</p>";
        } elseif (count($consulta['data']) == 0) {
            echo "<p>El array 'data' está vacío</p>";
        }
    }

    echo "<hr>";

    echo "<h3>6. Simulación de lo que recibiría DataTables:</h3>";
    echo "<p>DataTables espera recibir un objeto JSON con la estructura:</p>";
    echo "<pre>{ \"data\": [ {...}, {...} ] }</pre>";

    if (isset($consulta['data'])) {
        echo "<p style='color: green;'>✓ La estructura es correcta</p>";
    } else {
        echo "<p style='color: red;'>✗ La estructura es incorrecta</p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    table { margin-bottom: 15px; font-size: 12px; }
</style>
