-- Script de soluciones para los 2 problemas pendientes
-- Ejecutar este script en phpMyAdmin o MySQL Workbench

-- ========================================
-- PROBLEMA 1: Trámites derivados/finalizados siguen apareciendo en "Trámites Recibidos"
-- ========================================

-- Primero, ver el procedimiento actual
SHOW CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA;

-- Ahora vamos a actualizar el procedimiento para que filtre correctamente
-- El problema es que muestra TODOS los trámites donde el área destino es la del usuario
-- Pero NO debe mostrar los que ya fueron derivados o finalizados POR ESA ÁREA

DROP PROCEDURE IF EXISTS SP_LISTAR_TRAMITE_AREA;

DELIMITER $$

CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA(
    IN IDUSUARIO INT,
    IN TIPO_RE VARCHAR(20)
)
BEGIN
    -- Este SP lista los trámites que están PENDIENTES en el área del usuario
    -- NO debe mostrar los que ya fueron derivados o finalizados desde esa área

    SELECT
        m.movimiento_id,
        m.documento_id,
        d.doc_dni,
        d.doc_nom,
        d.doc_ape,
        tipo.tipo_tramite AS asunto,
        d.doc_representacion,
        m.mov_archivo,
        m.mov_descripcion,
        m.mov_fecharegistro,
        m.mov_estatus,
        area_origen.area_nombre AS area_origen,
        area_destino.area_nombre AS area_destino,
        m.area_origen_id,
        m.area_destino_id,
        d.doc_folio
    FROM movimiento m
    INNER JOIN documento d ON m.documento_id = d.documento_id
    INNER JOIN tipo_tramite tipo ON d.tipo_tramite_id = tipo.tipo_tramite_id
    LEFT JOIN area AS area_origen ON m.area_origen_id = area_origen.area_cod
    LEFT JOIN area AS area_destino ON m.area_destino_id = area_destino.area_cod
    INNER JOIN usuario u ON u.usuario_id = IDUSUARIO
    WHERE
        -- El área destino del movimiento es el área del usuario
        m.area_destino_id = u.area_cod
        -- Y el estado del movimiento es PENDIENTE (no ha sido procesado aún)
        AND m.mov_estatus = 'PENDIENTE'
        -- Asegurar que el documento no está finalizado globalmente
        AND d.doc_estatus != 'FINALIZADO'
        -- Solo mostrar documentos del año actual o filtro específico
        AND (TIPO_RE = '' OR d.doc_representacion = TIPO_RE)
    ORDER BY m.mov_fecharegistro DESC;
END$$

DELIMITER ;

-- Verificar que se creó correctamente
SELECT 'SP_LISTAR_TRAMITE_AREA actualizado correctamente' AS Resultado;

-- ========================================
-- PROBLEMA 2: Archivos con visible_publico=1 no se muestran en seguimiento.php
-- ========================================

-- Ver el procedimiento actual
SHOW CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE;

-- Actualizar para que filtre correctamente por visibilidad
DROP PROCEDURE IF EXISTS SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE;

DELIMITER $$

CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE(
    IN NUMERO VARCHAR(50)
)
BEGIN
    -- Este SP devuelve el detalle de seguimiento para el público
    -- Solo debe mostrar archivos si mov_visible_publico = 1

    SELECT
        movimiento.movimiento_id,
        movimiento.documento_id,
        areadestino.area_nombre,
        movimiento.mov_fecharegistro,
        movimiento.mov_descripcion,
        movimiento.mov_estatus,
        areaorigen.area_nombre,
        movimiento.mov_descripcion AS mov_descripcion_original,
        -- Solo mostrar archivo si está marcado como visible públicamente
        CASE
            WHEN movimiento.mov_visible_publico = 1 THEN movimiento.mov_archivo
            ELSE NULL
        END AS mov_archivo
    FROM movimiento
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    WHERE movimiento.documento_id = NUMERO
    ORDER BY movimiento.movimiento_id ASC;
END$$

DELIMITER ;

-- Verificar que se creó correctamente
SELECT 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE actualizado correctamente' AS Resultado;

-- ========================================
-- VERIFICACIONES FINALES
-- ========================================

-- Verificar que ambos procedimientos existen
SHOW PROCEDURE STATUS WHERE Db = DATABASE() AND Name IN ('SP_LISTAR_TRAMITE_AREA', 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE');

-- Ver datos recientes para pruebas
SELECT
    movimiento_id,
    documento_id,
    area_destino_id,
    mov_estatus,
    mov_archivo,
    mov_visible_publico,
    mov_fecharegistro
FROM movimiento
ORDER BY movimiento_id DESC
LIMIT 10;
