-- ========================================
-- SOLUCIÓN FINAL CORRECTA
-- ========================================

-- LÓGICA CORRECTA:
-- Cuando se DERIVA, se crean DOS movimientos:
-- 1. Movimiento DERIVADO (área_origen = quien deriva, área_destino = a quien deriva)
-- 2. Movimiento PENDIENTE (área_origen = quien deriva, área_destino = a quien deriva)
--
-- Esto permite que:
-- - Quien deriva lo vea en "Trámites Derivados" (mov_estatus=DERIVADO)
-- - Quien recibe lo vea en "Trámites Recibidos" (mov_estatus=PENDIENTE)

DROP PROCEDURE IF EXISTS SP_REGISTRAR_TRAMITE_DERIVAR;

DELIMITER $$

CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR(
    IN IDDO VARCHAR(50),
    IN ORIG INT,           -- Área del usuario que está derivando
    IN DEST INT,           -- Área de destino
    IN DESCRIP VARCHAR(255),
    IN IDUSU INT,
    IN RUTA VARCHAR(255),
    IN ACCION VARCHAR(20), -- 'DERIVAR' o 'FINALIZAR'
    IN VISIBLE_PUBLICO TINYINT
)
BEGIN
    -- PASO 1: Insertar movimiento DERIVADO (para quien deriva)
    IF ACCION = 'DERIVAR' THEN
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico
        ) VALUES (
            IDDO,
            ORIG,           -- Quien deriva
            DEST,           -- A quién deriva
            DESCRIP,
            'DERIVADO',     -- Estado DERIVADO
            NOW(),
            IDUSU,
            RUTA,
            VISIBLE_PUBLICO
        );

        -- PASO 2: Insertar movimiento PENDIENTE (para quien recibe)
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico
        ) VALUES (
            IDDO,
            ORIG,           -- De quién viene
            DEST,           -- Quien recibe
            DESCRIP,
            'PENDIENTE',    -- Estado PENDIENTE
            NOW(),
            IDUSU,
            '',             -- Sin archivo en el PENDIENTE
            VISIBLE_PUBLICO
        );
    ELSE
        -- FINALIZAR
        INSERT INTO movimiento(
            documento_id,
            area_origen_id,
            area_destino_id,
            mov_descripcion,
            mov_estatus,
            mov_fecharegistro,
            usuario_id,
            mov_archivo,
            mov_visible_publico
        ) VALUES (
            IDDO,
            ORIG,
            NULL,           -- Sin destino al finalizar
            DESCRIP,
            'FINALIZADO',
            NOW(),
            IDUSU,
            RUTA,
            VISIBLE_PUBLICO
        );

        -- Actualizar documento
        UPDATE documento SET doc_estatus = 'FINALIZADO' WHERE documento_id = IDDO;
    END IF;
END$$

DELIMITER ;

SELECT '✅ SP_REGISTRAR_TRAMITE_DERIVAR corregido' AS Resultado;

-- ========================================
-- SP_LISTAR_TRAMITE_AREA (Trámites Recibidos)
-- ========================================

DROP PROCEDURE IF EXISTS SP_LISTAR_TRAMITE_AREA;

DELIMITER $$

CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA(
    IN IDUSUARIO INT,
    IN TIPO_RE VARCHAR(20)
)
BEGIN
    DECLARE IDAREA INT;
    SET @IDAREA := (SELECT area_id FROM usuario WHERE usu_id = IDUSUARIO);

    SELECT
        SUBSTRING_INDEX(documento.documento_id, '-', 1) AS expe_num,
        documento.documento_id,
        documento.doc_nrodocumento,
        documento.doc_dniremitente,
        documento.doc_nombreremitente,
        documento.doc_apepatremitente,
        documento.doc_apematremitente,
        documento.doc_emailremitente,
        documento.doc_celularremitente,
        documento.doc_direccionremitente,
        documento.doc_representacion,
        documento.doc_ruc,
        documento.doc_empresa,
        documento.doc_folio,
        documento.doc_archivo,
        documento.doc_asunto,
        documento.doc_fecharegistro,
        documento.tipodocumento_id,
        documento.area_origen,
        documento.area_destino,
        documento.doc_estatus,
        tipo_documento.tipodocumento_id AS tipodoc_id,
        tipo_documento.tipodoc_descripcion,
        tupa.tupa_id,
        tupa.tupa_descripcion,
        tupa.tupa_requisitos,
        movimiento.movimiento_id,
        movimiento.area_origen_id,
        movimiento.area_destino_id,
        movimiento.mov_estatus,
        movimiento.mov_descripcion,
        movimiento.mov_archivo,
        movimiento.mov_fecharegistro,
        areaorigen.area_nombre AS origen,
        areadestino.area_nombre AS destino,
        documento.grupo_area_destino_id,
        grupo.area_nombre AS grupo,
        CONCAT_WS(' ',
            documento.doc_nombreremitente,
            documento.doc_apepatremitente,
            documento.doc_apematremitente
        ) AS REMITENTE
    FROM movimiento
    INNER JOIN documento ON movimiento.documento_id = documento.documento_id
    LEFT JOIN tipo_documento ON documento.tipodocumento_id = tipo_documento.tipodocumento_id
    LEFT JOIN tupa ON documento.tupa_id = tupa.tupa_id
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS grupo ON documento.grupo_area_destino_id = grupo.area_cod
    WHERE
        movimiento.area_destino_id = @IDAREA
        AND movimiento.mov_estatus = 'PENDIENTE'
        AND movimiento.movimiento_id = (
            SELECT MAX(m2.movimiento_id)
            FROM movimiento m2
            WHERE m2.documento_id = movimiento.documento_id
            AND m2.mov_estatus = 'PENDIENTE'
            AND m2.area_destino_id = @IDAREA
        )
        AND (TIPO_RE = '' OR documento.doc_representacion = TIPO_RE)
    ORDER BY movimiento.mov_fecharegistro DESC;
END$$

DELIMITER ;

SELECT '✅ SP_LISTAR_TRAMITE_AREA corregido' AS Resultado;

-- ========================================
-- SP_LISTAR_TRAMITE_AREA_DERIVADO (Trámites Derivados)
-- ========================================

DROP PROCEDURE IF EXISTS SP_LISTAR_TRAMITE_AREA_DERIVADO;

DELIMITER $$

CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA_DERIVADO(
    IN IDUSUARIO INT
)
BEGIN
    DECLARE IDAREA INT;
    SET @IDAREA := (SELECT area_id FROM usuario WHERE usu_id = IDUSUARIO);

    SELECT
        SUBSTRING_INDEX(documento.documento_id, '-', 1) AS expe_num,
        documento.documento_id,
        documento.doc_nrodocumento,
        documento.doc_dniremitente,
        documento.doc_nombreremitente,
        documento.doc_apepatremitente,
        documento.doc_apematremitente,
        documento.doc_emailremitente,
        documento.doc_celularremitente,
        documento.doc_direccionremitente,
        documento.doc_representacion,
        documento.doc_ruc,
        documento.doc_empresa,
        documento.doc_folio,
        documento.doc_archivo,
        documento.doc_asunto,
        documento.doc_fecharegistro,
        documento.tipodocumento_id,
        documento.area_origen,
        documento.area_destino,
        documento.doc_estatus,
        tipo_documento.tipodocumento_id AS tipodoc_id,
        tipo_documento.tipodoc_descripcion,
        tupa.tupa_id,
        tupa.tupa_descripcion,
        tupa.tupa_requisitos,
        movimiento.movimiento_id,
        movimiento.area_origen_id,
        movimiento.area_destino_id,
        movimiento.mov_estatus,
        movimiento.mov_descripcion,
        movimiento.mov_archivo,
        movimiento.mov_fecharegistro,
        areaorigen.area_nombre AS origen,
        areadestino.area_nombre AS destino,
        documento.grupo_area_destino_id,
        grupo.area_nombre AS grupo,
        CONCAT_WS(' ',
            documento.doc_nombreremitente,
            documento.doc_apepatremitente,
            documento.doc_apematremitente
        ) AS REMITENTE
    FROM movimiento
    INNER JOIN documento ON movimiento.documento_id = documento.documento_id
    LEFT JOIN tipo_documento ON documento.tipodocumento_id = tipo_documento.tipodocumento_id
    LEFT JOIN tupa ON documento.tupa_id = tupa.tupa_id
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS grupo ON documento.grupo_area_destino_id = grupo.area_cod
    WHERE
        movimiento.area_origen_id = @IDAREA
        AND movimiento.mov_estatus = 'DERIVADO'
    ORDER BY movimiento.mov_fecharegistro DESC;
END$$

DELIMITER ;

SELECT '✅ SP_LISTAR_TRAMITE_AREA_DERIVADO corregido' AS Resultado;
SELECT '✅ ¡SOLUCIÓN APLICADA!' AS Resultado;
SELECT 'Limpia las tablas y crea un nuevo trámite para probar' AS Instruccion;
