-- ========================================
-- SOLUCIÓN COMPLETA Y CORREGIDA
-- Script de corrección para los 2 problemas pendientes
-- ========================================
-- Ejecutar este script completo en phpMyAdmin

-- ========================================
-- PROBLEMA 1: Trámites derivados/finalizados siguen apareciendo en "Trámites Recibidos"
-- SOLUCIÓN: Filtrar solo mov_estatus = 'PENDIENTE'
-- ========================================

DROP PROCEDURE IF EXISTS SP_LISTAR_TRAMITE_AREA;

DELIMITER $$

CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA(
    IN IDUSUARIO INT,
    IN TIPO_RE VARCHAR(20)
)
BEGIN
    -- Obtener el área del usuario
    DECLARE IDAREA INT;
    SET @IDAREA := (SELECT area_id FROM usuario WHERE usu_id = IDUSUARIO);

    -- Listar trámites PENDIENTES en el área del usuario
    -- IMPORTANTE: Solo muestra movimientos con mov_estatus = 'PENDIENTE'
    -- Esto excluye automáticamente los que ya fueron derivados o finalizados
    SELECT
        documento.documento_id,
        SUBSTRING_INDEX(documento.documento_id, '-', 1) AS expe_num,
        documento.doc_dniremitente,
        CONCAT_WS(' ', documento.doc_nombreremitente, documento.doc_apepatremitente, documento.doc_apematremitente) AS REMITENTE,
        documento.tipodocumento_id,
        tipo_documento.tipodoc_descripcion,
        documento.doc_estatus,
        origen.area_nombre AS origen,
        destino.area_nombre AS destino,
        documento.doc_nrodocumento,
        documento.doc_nombreremitente,
        documento.doc_apepatremitente,
        documento.doc_apematremitente,
        documento.doc_celularremitente,
        documento.doc_emailremitente,
        documento.doc_direccionremitente,
        documento.doc_representacion,
        documento.doc_ruc,
        documento.doc_empresa,
        documento.doc_folio,
        documento.doc_asunto,
        documento.doc_fecharegistro,
        documento.area_origen,
        documento.area_destino,
        documento.doc_archivo,
        tupa.tupa_descripcion,
        tupa.tupa_requisitos,
        documento.tupa_id,
        documento.grupo_area_destino_id,
        grupo.area_nombre AS grupo,
        movimiento.movimiento_id,
        movimiento.mov_estatus,
        movimiento.mov_fecharegistro,
        movimiento.area_destino_id AS mov_area_destino
    FROM
        movimiento
        INNER JOIN documento ON movimiento.documento_id = documento.documento_id
        INNER JOIN tipo_documento ON documento.tipodocumento_id = tipo_documento.tipodocumento_id
        LEFT JOIN area AS origen ON movimiento.area_origen_id = origen.area_cod
        LEFT JOIN area AS destino ON movimiento.area_destino_id = destino.area_cod
        INNER JOIN tupa ON documento.tupa_id = tupa.tupa_id
        LEFT JOIN area AS grupo ON documento.grupo_area_destino_id = grupo.area_cod
    WHERE
        -- El movimiento está dirigido al área del usuario
        movimiento.area_destino_id = @IDAREA
        -- Y el estado del movimiento es PENDIENTE (no ha sido procesado/derivado/finalizado)
        AND movimiento.mov_estatus = 'PENDIENTE'
        -- Filtro opcional por tipo de representación
        AND (TIPO_RE = '' OR documento.doc_representacion = TIPO_RE)
    ORDER BY movimiento.mov_fecharegistro DESC;
END$$

DELIMITER ;

-- Verificar creación
SELECT 'SP_LISTAR_TRAMITE_AREA corregido exitosamente' AS Resultado;

-- ========================================
-- PROBLEMA 2: Archivos con visible_publico=1 no se muestran en seguimiento.php
-- SOLUCIÓN: Filtrar archivos por mov_visible_publico = 1
-- ========================================

DROP PROCEDURE IF EXISTS SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE;

DELIMITER $$

CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE(
    IN NUMERO VARCHAR(50)
)
BEGIN
    -- Este SP devuelve el detalle de seguimiento para el público
    -- Solo debe mostrar archivos si mov_visible_publico = 1

    SELECT
        movimiento.movimiento_id,
        movimiento.documento_id,
        areadestino.area_nombre,
        movimiento.mov_fecharegistro,
        movimiento.mov_descripcion,
        movimiento.mov_estatus,
        areaorigen.area_nombre,
        movimiento.mov_descripcion AS mov_descripcion_original,
        -- Solo mostrar archivo si está marcado como visible públicamente
        CASE
            WHEN movimiento.mov_visible_publico = 1 THEN movimiento.mov_archivo
            ELSE NULL
        END AS mov_archivo
    FROM movimiento
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    WHERE movimiento.documento_id = NUMERO
    ORDER BY movimiento.movimiento_id ASC;
END$$

DELIMITER ;

-- Verificar creación
SELECT 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE corregido exitosamente' AS Resultado;

-- ========================================
-- VERIFICACIONES FINALES
-- ========================================

-- Verificar que ambos procedimientos existen
SHOW PROCEDURE STATUS WHERE Db = DATABASE() AND Name IN ('SP_LISTAR_TRAMITE_AREA', 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE');

-- Ver datos recientes para pruebas
SELECT
    movimiento_id,
    documento_id,
    area_destino_id,
    mov_estatus,
    mov_archivo,
    mov_visible_publico,
    mov_fecharegistro
FROM movimiento
ORDER BY movimiento_id DESC
LIMIT 10;

-- Mensaje final
SELECT '¡Corrección completada! Ahora recarga tramites_recibidos.php con Ctrl+F5' AS Instruccion;
