<!DOCTYPE html>
<html lang="es">

<head>
    <meta name="generator" content="Hugo 0.87.0" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, height=device-height, initial-scale=1">
    <meta name="description" content="Nifty is a responsive admin dashboard template based on Bootstrap 5 framework. There are a lot of useful components.">
    <title>Seguimiento Tramite | MDM</title>
    <link rel="shortcut icon" href="view/assets/img/default.png" id="icon_pestaña" />
    <!-- STYLESHEETS -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--- -->

    <!-- Fonts [ OPTIONAL ] -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;700&family=Ubuntu:wght@400;500;700&display=swap" rel="stylesheet">
    

    
    <!-- Bootstrap CSS [ REQUIRED ] -->
    <link rel="stylesheet" href="./view/assets/css/bootstrap.min.css">

    <!-- Nifty CSS [ REQUIRED ] -->
    <link rel="stylesheet" href="./view/assets/css/nifty.min.css">

    <!-- Nifty Demo Icons [ OPTIONAL ] -->
    <link rel="stylesheet" href="./view/assets/css/demo-purpose/demo-icons.min.css">

    <!-- Demo purpose CSS [ DEMO ] -->
    <link rel="stylesheet" href="./view/assets/css/demo-purpose/demo-settings.min.css">

    <link rel="stylesheet" href="./public/css/estilos.css">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">

    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.4/css/dataTables.bootstrap5.min.css">

</head>

<body class="jumping">
    <header class="w-100 px-2">
        <nav class="main-header navbar navbar-expand-md navbar-light navbar-white">
            <div class="container">
                <a href="nuevo_tramite.php" class="navbar-brand px-3">
                    <img src="view/assets/img/default.png" style="width: 30px" id="logo_header" alt="Logo" class="brand-image img-circle elevation-3">
                    <span class="brand-text font-weight-light" style="font-weight: bold !important;">Seguimiento | Mesa
                        de Partes
                        Virtual</span>
                </a>
                <div class="w-100 d-flex justify-content-lg-end justify-content-center">
                    <a href="nuevo_tramite.php" class="btn-link link-danger text-decoration-none me-3"><i class="fa-solid fa-file-invoice fs-5 me-1"></i><span class="nav-label mininav-content ms-1">Nuevo Tramite</span>
                    </a>
                    <a href="index.php" class="btn-link link-info text-decoration-none "><i class="fa-solid fa-user fs-5 me-1"></i><span class="nav-label mininav-content ms-1">Ingresar
                            al Sistema</span>
                    </a>
                </div>


                <!-- Right navbar links -->

            </div>
        </nav>

    </header>
    <section id="content" class="content">
        <div class="container">
            <div class="content__boxed">
                <div class="content__wrap">
                    <div class="row justify-content-center">
                        <div class="col-lg-10">

                            <!-- Normal Card -->
                            <div class="card h-100">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <label for="">Nro Expediente (*)</label>
                                            <input type="text" class="form-control " id="txt_numero">
                                        </div>

                                        <div class="col-lg-3">
                                            <label for="">Nro DNI (*)</label>
                                            <input type="text" class="form-control " id="txt_dni">
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="">Año (*)</label>
                                            <select class="form-select" id="txt_año">
                                                <?php
                                                echo '<option value=""></option>';

                                                for ($i = 2020; $i <= date("Y"); $i++) {
                                                    echo "<option value='" . $i . "'>" . $i . "</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-3">
                                            <label for="">&nbsp;</label><br>
                                            <button class="btn btn-danger w-100" onclick="Traer_Datos_Seguimiento()">Buscar</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- END : Normal card -->

                        </div>
                        <div class="col-lg-10 mt-3" id="buscador" style="display:none;">

                            <!-- Normal Card -->
                            <div class="">
                                <div class="">
                                    <h4 class=" p-3" id="lbl_titulo"></h4>
                                </div>
                                <div class="card-body" style="overflow:auto;">
                                    <div class="row" id="item_interno">
                                        <div class="col-lg-12 pb-2">
                                            <label for="" id="lbl_interno"></label><br>
                                            <label for="" id="lbl_interno_f"></label>

                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12 mb-3" id="div_seguimiento">
                                            <!-- Timeline with icons -->







                                            <!-- END : Timeline with icons -->

                                        </div>

                                    </div>
                                </div>
                            </div>
                            <!-- END : Normal card -->

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <footer class="mt-auto">
        <div class="content__boxed">
            <div class="content__wrap py-3 py-md-1 d-flex flex-column justify-content-center flex-md-row align-items-md-center">
                <div class="text-nowrap mb-4 mb-md-0 opacity-0"><span id="lbl_year">Copyright © 2023</span> <a href="#" class="ms-1 btn-link fw-bold"><span id="lbl_footer"></span></a </div>

                </div>
            </div>
    </footer>




    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!-- JAVASCRIPTS -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <script src="https://kit.fontawesome.com/bd7b24f1e0.js" crossorigin="anonymous"></script>
    <!-- Popper JS [ OPTIONAL ] -->
    <script src="./view/assets/vendors/popperjs/popper.min.js" defer></script>

    <!-- Bootstrap JS [ OPTIONAL ] -->
    <script src="./view/assets/vendors/bootstrap/bootstrap.min.js" defer></script>
    <!-- Nifty JS [ OPTIONAL ] -->
    <script src="./view/assets/js/nifty.js" defer></script>

    <!-- Nifty Settings [ DEMO ] -->
    <script src="./view/assets/js/demo-purpose-only.js" defer></script>

    <script src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/1.11.4/js/dataTables.bootstrap5.min.js"></script>

    <script src="./public/js/menu.js?rev=<?php echo time(); ?>"></script>
    <script src="./public/js/entidad.js?rev=<?php echo time(); ?>"></script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        $(document).ready(function() {



            mostrar_datos_emmpresa_exterior();

        });
        var iconos = document.getElementsByClassName("icono_flecha");

        var mostrar = true;

        setInterval(function() {
            for (var i = 0; i < iconos.length; i++) {
                // Alterna la visibilidad del icono
                if (mostrar) {
                    iconos[i].style.visibility = 'hidden';
                } else {
                    iconos[i].style.visibility = 'visible';
                }
            }
            mostrar = !mostrar;
        }, 500);
    </script>

</body>

</html>