<?php
header('Content-Type: text/html; charset=utf-8');

try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=munimor9_bdmoralestramite;charset=utf8mb4',
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "<style>
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        table { background: white; border-collapse: collapse; width: 100%; margin: 20px 0; font-size: 12px; }
        th { background: #1976D2; color: white; padding: 8px; text-align: left; position: sticky; top: 0; }
        td { padding: 6px; border-bottom: 1px solid #ddd; }
        .pendiente { background: #fff9c4; }
        .derivado { background: #e1bee7; }
        .finalizado { background: #c8e6c9; }
        .vacio { background: #ffcdd2; }
        h2 { color: #1976D2; margin-top: 30px; }
        .info { background: #e3f2fd; padding: 10px; margin: 10px 0; border-left: 4px solid #2196F3; }
    </style>";

    echo "<h1>🔍 REVISIÓN COMPLETA DE BASE DE DATOS</h1>";

    // 1. TABLA DOCUMENTO
    echo "<h2>📄 1. TABLA DOCUMENTO</h2>";
    $stmt = $pdo->query("
        SELECT
            documento.documento_id,
            documento.doc_nrodocumento,
            CONCAT_WS(' ', documento.doc_nombreremitente, documento.doc_apepatremitente, documento.doc_apematremitente) AS remitente,
            documento.area_origen,
            ao.area_nombre AS area_origen_nombre,
            documento.area_destino,
            ad.area_nombre AS area_destino_nombre,
            documento.doc_estatus,
            documento.doc_fecharegistro,
            documento.area_id,
            u.usu_usuario AS usuario_registro
        FROM documento
        LEFT JOIN area ao ON documento.area_origen = ao.area_cod
        LEFT JOIN area ad ON documento.area_destino = ad.area_cod
        LEFT JOIN usuario u ON documento.area_id = u.area_id
        ORDER BY documento.doc_fecharegistro DESC
        LIMIT 10
    ");

    echo "<table border='1'>";
    echo "<tr>
            <th>Doc ID</th>
            <th>Nro Doc</th>
            <th>Remitente</th>
            <th>Área Origen (quien registró)</th>
            <th>Área Destino</th>
            <th>Estado Doc</th>
            <th>Usuario Registro</th>
            <th>Fecha</th>
          </tr>";

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr>";
        echo "<td><strong>{$row['documento_id']}</strong></td>";
        echo "<td>{$row['doc_nrodocumento']}</td>";
        echo "<td>{$row['remitente']}</td>";
        echo "<td>{$row['area_origen']} - {$row['area_origen_nombre']}</td>";
        echo "<td>{$row['area_destino']} - {$row['area_destino_nombre']}</td>";
        echo "<td><strong>{$row['doc_estatus']}</strong></td>";
        echo "<td>{$row['usuario_registro']}</td>";
        echo "<td>{$row['doc_fecharegistro']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    // 2. TABLA MOVIMIENTO
    echo "<h2>🔄 2. TABLA MOVIMIENTO (últimos 20)</h2>";
    $stmt = $pdo->query("
        SELECT
            m.movimiento_id,
            m.documento_id,
            m.area_origen_id,
            ao.area_nombre AS area_origen_nombre,
            m.area_destino_id,
            ad.area_nombre AS area_destino_nombre,
            m.mov_estatus,
            m.mov_descripcion,
            m.mov_archivo,
            m.mov_visible_publico,
            m.mov_fecharegistro,
            u.usu_usuario,
            u.area_id AS usuario_area_id,
            -- ¿Es el último movimiento?
            CASE
                WHEN m.movimiento_id = (
                    SELECT MAX(m2.movimiento_id)
                    FROM movimiento m2
                    WHERE m2.documento_id = m.documento_id
                ) THEN 'SÍ'
                ELSE 'NO'
            END AS es_ultimo
        FROM movimiento m
        LEFT JOIN area ao ON m.area_origen_id = ao.area_cod
        LEFT JOIN area ad ON m.area_destino_id = ad.area_cod
        LEFT JOIN usuario u ON m.usuario_id = u.usu_id
        ORDER BY m.movimiento_id DESC
        LIMIT 20
    ");

    echo "<table border='1'>";
    echo "<tr>
            <th>ID Mov</th>
            <th>Doc ID</th>
            <th>Área Origen</th>
            <th>Área Destino</th>
            <th>Estado</th>
            <th>Descripción</th>
            <th>Usuario</th>
            <th>Fecha</th>
            <th>Es Último?</th>
          </tr>";

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $clase = '';
        switch ($row['mov_estatus']) {
            case 'PENDIENTE': $clase = 'pendiente'; break;
            case 'DERIVADO': $clase = 'derivado'; break;
            case 'FINALIZADO': $clase = 'finalizado'; break;
            default: $clase = 'vacio';
        }

        echo "<tr class='$clase'>";
        echo "<td><strong>{$row['movimiento_id']}</strong></td>";
        echo "<td>{$row['documento_id']}</td>";
        echo "<td>{$row['area_origen_id']} - {$row['area_origen_nombre']}</td>";
        echo "<td>{$row['area_destino_id']} - {$row['area_destino_nombre']}</td>";
        echo "<td><strong>" . ($row['mov_estatus'] ?: '⚠️ VACÍO') . "</strong></td>";
        echo "<td>" . substr($row['mov_descripcion'], 0, 40) . "...</td>";
        echo "<td>{$row['usu_usuario']} (área {$row['usuario_area_id']})</td>";
        echo "<td>" . date('Y-m-d H:i', strtotime($row['mov_fecharegistro'])) . "</td>";
        echo "<td><strong>{$row['es_ultimo']}</strong></td>";
        echo "</tr>";
    }
    echo "</table>";

    // 3. USUARIOS Y SUS ÁREAS
    echo "<h2>👥 3. USUARIOS Y SUS ÁREAS</h2>";
    $stmt = $pdo->query("
        SELECT
            u.usu_id,
            u.usu_usuario,
            u.area_id,
            a.area_nombre,
            u.usu_rol
        FROM usuario u
        LEFT JOIN area a ON u.area_id = a.area_cod
        WHERE u.usu_estatus = 'ACTIVO'
        ORDER BY u.usu_usuario
        LIMIT 20
    ");

    echo "<table border='1'>";
    echo "<tr><th>ID Usuario</th><th>Usuario</th><th>Área ID</th><th>Área Nombre</th><th>Rol</th></tr>";

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr>";
        echo "<td>{$row['usu_id']}</td>";
        echo "<td><strong>{$row['usu_usuario']}</strong></td>";
        echo "<td>{$row['area_id']}</td>";
        echo "<td>{$row['area_nombre']}</td>";
        echo "<td>{$row['usu_rol']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    // 4. ANÁLISIS DEL PROBLEMA
    echo "<h2>🔬 4. ANÁLISIS DEL FLUJO</h2>";

    // Encontrar el documento más reciente
    $stmt = $pdo->query("
        SELECT documento_id
        FROM documento
        ORDER BY doc_fecharegistro DESC
        LIMIT 1
    ");
    $ultimo_doc = $stmt->fetchColumn();

    if ($ultimo_doc) {
        echo "<div class='info'><strong>📌 Analizando documento más reciente: $ultimo_doc</strong></div>";

        $stmt = $pdo->prepare("
            SELECT
                m.movimiento_id,
                m.area_origen_id,
                ao.area_nombre AS origen,
                m.area_destino_id,
                ad.area_nombre AS destino,
                m.mov_estatus,
                m.mov_fecharegistro
            FROM movimiento m
            LEFT JOIN area ao ON m.area_origen_id = ao.area_cod
            LEFT JOIN area ad ON m.area_destino_id = ad.area_cod
            WHERE m.documento_id = ?
            ORDER BY m.movimiento_id
        ");
        $stmt->execute([$ultimo_doc]);

        echo "<table border='1'>";
        echo "<tr><th>Mov ID</th><th>De (Origen)</th><th>A (Destino)</th><th>Estado</th><th>Fecha</th></tr>";

        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $clase = '';
            switch ($row['mov_estatus']) {
                case 'PENDIENTE': $clase = 'pendiente'; break;
                case 'DERIVADO': $clase = 'derivado'; break;
                case 'FINALIZADO': $clase = 'finalizado'; break;
                default: $clase = 'vacio';
            }

            echo "<tr class='$clase'>";
            echo "<td>{$row['movimiento_id']}</td>";
            echo "<td>{$row['area_origen_id']} - {$row['origen']}</td>";
            echo "<td>{$row['area_destino_id']} - {$row['destino']}</td>";
            echo "<td><strong>" . ($row['mov_estatus'] ?: '⚠️ VACÍO') . "</strong></td>";
            echo "<td>{$row['mov_fecharegistro']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }

    echo "<h2>✅ Revisión completada</h2>";
    echo "<div class='info'>
        <strong>Leyenda de colores:</strong><br>
        🟡 Amarillo = PENDIENTE (debe aparecer en Trámites Recibidos)<br>
        🟣 Morado = DERIVADO (debe aparecer en Trámites Derivados)<br>
        🟢 Verde = FINALIZADO<br>
        🔴 Rojo = VACÍO (ERROR - no tiene estado)
    </div>";

} catch (PDOException $e) {
    echo "<div style='background:#ffcdd2; padding:20px; color:#c62828;'>";
    echo "<h2>❌ ERROR DE CONEXIÓN</h2>";
    echo "<p>" . $e->getMessage() . "</p>";
    echo "</div>";
}
?>
