var tbl_tupa;
function listar_tupa() {
    tbl_tupa = $("#tabla_tupa").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tupa/controller_listar_tupa.php",
            type: 'POST'
        },
        "columns": [
            { "defaultContent": "" },
            { "data": "tupa_descripcion" },
            { "defaultContent": "<button class='mas btn btn-primary btn-sm'><i class='bi bi-eye'></i></button>" },
            {
                "data": "tupa_estado", render: function (data, type, row) {
                    if (data == 'ACTIVO') {
                        return '<span class="badge bg-success">ACTIVO</span>';
                    } else {
                        return '<span class="badge bg-danger">INACTIVO</span>';
                    }
                }
            },
            { "defaultContent": "<button class=' editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button>&nbsp<button class=' eliminar btn btn-danger btn-sm'><i class='fa-solid fa-trash'></i></button>" },
        ],

        "language": idioma_espanol,
        select: true
    });
    tbl_tupa.on('draw.td', function () {
        var PageInfo = $("#tabla_tupa").DataTable().page.info();
        tbl_tupa.column(0, { page: 'current' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

}

$('#tabla_tupa').on('click', '.editar', function () {
    let data = tbl_tupa.row($(this).parents('tr')).data();
    if (tbl_tupa.row(this).child.isShown()) {
        data = tbl_tupa.row(this).data();
    }
    $("#modal_editar").modal('show');
    document.getElementById('txt_idtupa').value = data.tupa_id;
    document.getElementById('txt_nombre_editar').value = data.tupa_descripcion;
    document.getElementById('select_estatus_tupa').value = data.tupa_estado;
    let requisitos = JSON.parse(data.tupa_requisitos);
    let requisitosList = $("#div_requisito_editar");
    requisitosList.empty(); // Vaciar la lista de requisitos previos
    requisitosList.append("<label>Requisitos</label>");

    if (requisitos.length > 0) {
        for (let i = 0; i < requisitos.length; i++) {
            requisitosList.append("<li><div class='col-12 mb-2 input-group'><input class='form-control' value='" + requisitos[i] + "'/>" + "<button class='btn btn-danger mr-2' onclick='Eliminar_Requisto(this);'><i class='fa-solid fa-trash'></i></button>" + "</div></li>");
        }
    } else {
        requisitosList.append("<p>No se registro requistos</p>");
    }


});

$('#tabla_tupa').on('click', '.eliminar', function () {
    let data = tbl_tupa.row($(this).parents('tr')).data();
    if (tbl_tupa.row(this).child.isShown()) {
        data = tbl_tupa.row(this).data();
    }
    Swal.fire({
        title: '¿Desea Eliminar el Procedimiento Administrativo?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            eliminar_tupa(data.tupa_id);      
        }
      })
});
function eliminar_tupa(id) {
    $.ajax({
        "url": "../controller/tupa/controller_eliminar_tupa.php",
        type: 'POST',
        data: {
            id: id,
  
        }
    }).done(function (resp) {
        if (resp == 1) {
            Swal.fire("Mensaje de Confirmacion", "Procedimiento Administrativo Eliminado con Exito", "success").then((value) => {
                tbl_tupa.ajax.reload();
            });
  
  
        } else if (resp == 2) {
            Swal.fire("Mensaje de Advertencia", "No se puede Eliminar, el Procedimiento Administrativo se Encuentra Activo", "warning");
        } else {
            Swal.fire("Mensaje de Error", "No se completo la operacion, El registro esta siendo utilizado por otra instancia, comuniquese con Soporte", "error");
        }
  
    });
  
  }

$('#tabla_tupa').on('click', '.mas', function () {
    let data = tbl_tupa.row($(this).parents('tr')).data();
    if (tbl_tupa.row(this).child.isShown()) {
        data = tbl_tupa.row(this).data();
    }
    $("#modal_mas").modal('show');
    let requisitos = JSON.parse(data.tupa_requisitos);
    let requisitosList = $("#lista_requisitos");
    requisitosList.empty(); // Vaciar la lista de requisitos previos


    if (requisitos.length > 0) {
        for (let i = 0; i < requisitos.length; i++) {
            requisitosList.append("<li class='mb-3' style='text-align:justify;'>" + requisitos[i] + "</li>");
        }
    } else {
        requisitosList.append("<p>No se registro requistos</p>")
    }

})


function Agregar_Requisito(div) {
    let div_requi = "<li><div class='col-12 mb-2 input-group' id='requisito_'>" +
        "<input class=' form-control' placeholder='Nombre requisito'/>" +
        "<button class='btn btn-danger mr-2' onclick='Eliminar_Requisto(this);'><i class='fa-solid fa-trash'></i></button>" +
        "</div></li>";
    $("#" + div).append(div_requi);
}
function Eliminar_Requisto(Input) {
    Input.parentNode.parentNode.remove();
}
function Guardar_Requisitos(accion) {
    let requisitos = [];
    if (accion =="REGISTRAR") {
        $("#div_requisito input").each(function () {
            requisitos.push($(this).val());
        });
    } else if (accion == "EDITAR") {
        $("#div_requisito_editar input").each(function () {
            requisitos.push($(this).val());
        });
    } else {
        alert("error");
    }

    let requisitosJSON = JSON.stringify(requisitos);
    return requisitosJSON;

}

function AbrirRegistro() {
    $("#modal_registro").modal({ backdrop: 'static', keyborad: false })
    $("#modal_registro").modal('show');
}
/*INICIO REGISTRAR AREA*/
function Registrar_Tupa() {
    let nombre = document.getElementById('txt_nombre').value;
    let requisitos = Guardar_Requisitos('REGISTRAR');
    if (nombre.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
    }
    $.ajax({
        "url": "../controller/tupa/controller_registro_tupa.php",
        type: 'POST',
        data: {
            nombre: nombre,
            requisitos: requisitos
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Nuevo TUPA Registrado", "success").then((value) => {
                    document.getElementById('txt_nombre').value = "";
                    document.getElementById('div_requisito').innerHTML = "";
                    tbl_tupa.ajax.reload();
                    $("#modal_registro").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El TUPA ingresado ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo la operación, comuniquese con Soporte", "error");
        }
    })
}
/*FIN REGISTRAR AREA*/

function Modificar_Tupa() {
    let id_tupa = document.getElementById('txt_idtupa').value;
    let nombre = document.getElementById('txt_nombre_editar').value;
    let estatus = document.getElementById('select_estatus_tupa').value;
    let requisitos = Guardar_Requisitos('EDITAR');
    if (nombre.length == 0 || id_tupa.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
    }
    $.ajax({
        "url": "../controller/tupa/controller_modificar_tupa.php",
        type: 'POST',
        data: {
            id_tupa:id_tupa,
            nombre:nombre,
            estatus:estatus,
            requisitos:requisitos
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Datos Actualizados", "success").then((value) => {
                    tbl_tupa.ajax.reload();
                    $("#modal_editar").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El Procedimiento Administrativo ingresado ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo la operación, comuniquese con Soporte", "error");
        }
    })
}

function ValidacionInput(txt_nombre) {
    Boolean($("#" + txt_nombre).val().length > 0) ? $("#" + txt_nombre).removeClass('is-invalid').addClass("is-valid") : $("#" + txt_nombre).removeClass('is-valid').addClass("is-invalid");
}

function Cargar_Select_Area() {
    $.ajax({
      "url": "../controller/usuario/controller_cargar_select_area.php",
      type: 'POST',
    }).done(function (resp) {
      let data = JSON.parse(resp);
      if (data.length > 0) {
        let cadena = "";
        for (let i = 0; i < data.length; i++) {
          cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
        }
        document.getElementById('select_area_re').innerHTML = cadena;
      } else {
        cadena += " <option value=''>No hay areas disponibles</option>";
      }
    })
  }
  function Cargar_Select_Area() {
    $.ajax({
      "url": "../controller/usuario/controller_cargar_select_area.php",
      type: 'POST',
    }).done(function (resp) {
      let data = JSON.parse(resp);
      if (data.length > 0) {
        let cadena = "";
        for (let i = 0; i < data.length; i++) {
          cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
        }
        document.getElementById('select_area_re').innerHTML = cadena;
      } else {
        cadena += " <option value=''>No hay areas disponibles</option>";
      }
    })
  }