function Cargar_Select_Area_Destino(id) {
    $.ajax({
        "url": "../controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Area</option>";
            for (let i = 0; i < data.length; i++) {
                if (data[i][0] != id) {
                    cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
                }
            }
            //document.getElementById('select_destino_d').innerHTML = cadena;
            document.getElementById('select_area_grupo').innerHTML = cadena;

        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            //document.getElementById('select_destino_d').innerHTML = cadena;
            document.getElementById('select_area_grupo').innerHTML = cadena;

        }
    });
}

var tbl_tramite;
function listar_tramite_finalizado() {
    let idusuario = document.getElementById('txtprincipalid').value;

    tbl_tramite = $("#tabla_tramite_finalizado").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "responsive": true,
        "ajax": {
            "url": "../controller/tramite_area/controller_listar_tramite_finalizado.php",
            type: 'POST',
            data: {
                idusuario: idusuario,
            }
        },
        "columns": [
            { "data": "expe_num" },
            { "data": "doc_nrodocumento" },
            { "data": "tipodoc_descripcion" },
            { "data": "doc_dniremitente" },
            { "data": "REMITENTE" },
            { "defaultContent": "<button class='mas btn btn-primary btn-sm'><i class='fas fa-search'></i></button>" },
            { "defaultContent": "<button class='seguimiento btn btn-secondary btn-sm'><i class='fas fa-search'></i></button>" },
            {
                "data": "origen", render: function (data, type, row) {
                    if (data === '' || data === null) {
                        return 'EXTERIOR';

                    } else {
                        return data;
                    }
                }

            },
            { "data": "destino" },
            {
                "data": "doc_estatus", render: function (data, type, row) {
                    if (data == 'PENDIENTE') {
                        return '<span class="badge bg-warning">PENDIENTE</span>';
                    } else if (data == 'RECHAZADO') {
                        return '<span class="badge bg-danger">RECHAZADO</span>';
                    } else {
                        return '<span class="badge bg-success">FINALIZADO</span>';
                    }
                }
            },
            
        ],

        "language": idioma_espanol,
        select: true
    });

}

function Cargar_Select_Area() {
    $.ajax({
        "url": "../controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
            
        }
    })
}
function Cargar_Select_Tipo() {
    $.ajax({
        "url": "../controller/tramite/controller_cargar_select_tipo.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Tipo Documento</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tipo').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_tipo').innerHTML = cadena;
        }
    })
}


$('#tabla_tramite_finalizado').on('click', '.mas', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_mas").modal('show');
    document.getElementById('lbl_titulo_datos').innerHTML = "Datos del Expediente Nro: " + data.documento_id;
    document.getElementById('txt_ndocumento').value = data.doc_nrodocumento;
    document.getElementById('txt_folio').value = data.doc_folio;
    document.getElementById('txt_asunto').value = data.doc_asunto;
    document.getElementById('txt_proc').value = data.tupa_descripcion;
    document.getElementById('txt_idtupaver').value = data.tupa_id;
    document.getElementById('txt_fechareg').value = data.doc_fecharegistro;
    $('#select_area_p').select2().val(data.area_origen).trigger('change.select2');
    $('#select_area_d').select2().val(data.area_destino).trigger('change.select2');
    $('#select_tipo').select2().val(data.tipodocumento_id).trigger('change.select2');

    document.getElementById('txt_dni').value = data.doc_dniremitente;
    document.getElementById('txt_nom').value = data.doc_nombreremitente;
    document.getElementById('txt_apepat').value = data.doc_apepatremitente;
    document.getElementById('txt_apemat').value = data.doc_apematremitente;
    document.getElementById('txt_celular').value = data.doc_celularremitente;
    document.getElementById('txt_email').value = data.doc_emailremitente;
    document.getElementById('txt_dire').value = data.doc_direccionremitente;
    document.getElementById('txt_ruc').value = data.doc_ruc;
    document.getElementById('txt_razon').value = data.doc_empresa;

    document.getElementById('pdf-frame').src = '../' + data.doc_archivo;
    if (data.doc_representacion == "A NOMBRE PROPIO") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion1').prop('checked', true);
    }
    if (data.doc_representacion == "A OTRA PERSONA NATURAL") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion2').prop('checked', true);
    }
    if (data.doc_representacion == "PERSONA JURIDICA") {
        document.getElementById('div_juridico').style.display = 'block';
        $('#rad_presentacion3').prop('checked', true);
    }

});

$('#tabla_tramite_finalizado').on('click', '.seguimiento', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_seguimiento").modal('show');
    document.getElementById('lbl_titulo').innerHTML = "Seguimiento del Expediente Nro: " + data.documento_id;
    listar_seguimiento_tramite(data.documento_id);

});
//seguimiento tramite
var tbl_seguimiento;
function listar_seguimiento_tramite(id) {
    tbl_seguimiento = $("#tabla_seguimiento").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tramite/controller_listar_tabla_seguimiento_tramite.php",
            type: 'POST',
            data: {
                id: id
            }
        },
        "columns": [
            { "data": "area_nombre" },
            { "data": "mov_fecharegistro" },
            { "data": "mov_descripcion" },
            {
                "data": "mov_archivo", render: function (data, type, row) {
                    if (data == '') {
                        return "";
                    } else {
                        return "<button class='ver_ btn btn-warning btn-sm'><i class='fa-solid fa-file-pdf'></i></button>";
                    }


                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}
$('#tabla_seguimiento').on('click', '.ver_', function () {
    let data = tbl_seguimiento.row($(this).parents('tr')).data();
    if (tbl_seguimiento.row(this).child.isShown()) {
        data = tbl_seguimiento.row(this).data();
    }
    $("#modal_mostrar_anexo").modal('show');
    document.getElementById('pdf-frame_a').src = '../' + data.mov_archivo;

})
function mostar_requisitos() {
    let idtupaver = document.getElementById('txt_idtupaver').value;
    let nomtu = document.getElementById('txt_proc').value;

    $.ajax({
        "url": "../controller/tramite_area/controller_cargar_tupa_area.php",
        type: 'POST',
        data: {
            idtupaver: idtupaver
        }
    }).done(function (resp) {
        let data = JSON.parse(resp);
        let tupa_requisitos = JSON.parse(data.data[0]["tupa_requisitos"]);
        let requisitosList = $("#lista_requisitos");
        requisitosList.empty();
        if (tupa_requisitos.length > 0) {
            document.getElementById('lbl_re').innerHTML = "REQUISTOS DEL PROCEDIMIENTO ADMINISTRATIVO: " + "<br><span clas='fw-normal'>" + nomtu + "</span>";
            $("#modal_mas_requisitos").modal({ keyborad: false })
            $("#modal_mas_requisitos").modal('show');


            for (let i = 0; i < tupa_requisitos.length; i++) {
                requisitosList.append("<li class='mb-3' style='text-align:justify;'>" + tupa_requisitos[i] + "</li>");
            }
        } else {
            return Swal.fire("Mensaje de Advertencia", "No se encontro requisitos", "warning");
        }


    })

}