var tbl_tramite;
function listar_tramite() {
    tbl_tramite = $("#tabla_tramite").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tramite/controller_listar_tramite.php",
            type: 'POST'
        },
        "columns": [
            { "data": "documento_id" },
            { "data": "doc_nrodocumento" },
            { "data": "tipodoc_descripcion" },
            { "data": "doc_dniremitente" },
            { "data": "REMITENTE" },
            { "defaultContent": "<button class='mas btn btn-danger btn-sm'><i class='fas fa-search'></i></button>" },
            { "defaultContent": "<button class='seguimiento btn btn-secondary btn-sm'><i class='fas fa-search'></i></button>" },
            { "data": "origen" },
            { "data": "destino" },
            {
                "data": "doc_estatus", render: function (data, type, row) {
                    if (data == 'PENDIENTE') {
                        return '<span class="badge bg-warning">PENDIENTE</span>';
                    } else if (data == 'RECHAZADO') {
                        return '<span class="badge bg-danger">RECHAZADO</span>';
                    } else {
                        return '<span class="badge bg-success">FINALIZADO</span>';
                    }
                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}

$('#tabla_tramite').on('click', '.editar', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_editar").modal('show');
    document.getElementById('txt_area_editar').value = data.area_nombre;
    document.getElementById('txt_idarea').value = data.area_cod;
    document.getElementById('select_estatus').value = data.area_estado;
})

$('#tabla_tramite').on('click', '.seguimiento', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_seguimiento").modal('show');
    document.getElementById('lbl_titulo').innerHTML = "Seguimiento del Tramite: " + data.documento_id;
    listar_seguimiento_tramite(data.documento_id);

});

$('#tabla_tramite').on('click', '.mas', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_mas").modal('show');
    document.getElementById('lbl_titulo_datos').innerHTML = "Datos del Tramite: " + data.documento_id;
    document.getElementById('txt_ndocumento').value = data.doc_nrodocumento;
    document.getElementById('txt_folio').value = data.doc_folio;
    document.getElementById('txt_asunto').value = data.doc_asunto;
    $('#select_area_p').select2().val(data.area_origen).trigger('change.select2');
    $('#select_area_d').select2().val(data.area_destino).trigger('change.select2');
    $('#select_tipo').select2().val(data.tipodocumento_id).trigger('change.select2');

    document.getElementById('txt_dni').value = data.doc_dniremitente;
    document.getElementById('txt_nom').value = data.doc_nombreremitente;
    document.getElementById('txt_apepat').value = data.doc_apepatremitente;
    document.getElementById('txt_apemat').value = data.doc_apematremitente;
    document.getElementById('txt_celular').value = data.doc_celularremitente;
    document.getElementById('txt_email').value = data.doc_emailremitente;
    document.getElementById('txt_dire').value = data.doc_direccionremitente;
    document.getElementById('txt_ruc').value = data.doc_ruc;
    document.getElementById('txt_razon').value = data.doc_empresa;
    if (data.doc_representacion == "A NOMBRE PROPIO") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion1').prop('checked', true);
    }
    if (data.doc_representacion == "A OTRA PERSONA NATURAL") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion2').prop('checked', true);
    }
    if (data.doc_representacion == "PERSONA JURIDICA") {
        document.getElementById('div_juridico').style.display = 'block';
        $('#rad_presentacion3').prop('checked', true);
    }

});


function AbrirRegistro() {
    $("#modal_registro").modal({ backdrop: 'static', keyborad: false })
    $("#modal_registro").modal('show');
}
/*INICIO REGISTRAR AREA*/

function Cargar_Select_Tupa() {
    $.ajax({
        "url": "controller/tramite/controller_cargar_select_tupa.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''></option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tupa_d').innerHTML = cadena;

        } else {
            cadena += " <option value=''>No hay Procedimientos disponibles</option>";
            document.getElementById('select_tupa_d').innerHTML = cadena;

        }
    })
}


function Cargar_Select_Area() {
    $.ajax({
        "url": "controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Area</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
        }
    })
}
function Cargar_Select_Tipo() {
    $.ajax({
        "url": "controller/tramite/controller_cargar_select_tipo.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Tipo Documento</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tipo').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_tipo').innerHTML = cadena;
        }
    })
}

function Registrar_Tramite() {
    //DATOS DEL REMITENTE
    let dni = document.getElementById('txt_dni').value;
    let nom = document.getElementById('txt_nom').value;
    let apt = document.getElementById('txt_apepat').value;
    let apm = document.getElementById('txt_apemat').value;
    let cel = document.getElementById('txt_celular').value;
    let ema = document.getElementById('txt_email').value;
    let dir = document.getElementById('txt_dire').value;
    let presentacion = document.getElementsByName('r1');
    let vpresentacion = "";
    for (let i = 0; i < presentacion.length; i++) {
        if (presentacion[i].checked) {
            vpresentacion = presentacion[i].value;
        }
    }

    let ruc = document.getElementById('txt_ruc').value;
    let raz = document.getElementById('txt_razon').value;

    //DATOS DEL DOCUMENTO
    //let arp = document.getElementById('select_area_p').value;
    //let ard = document.getElementById('select_area_d').value;
    let proc = document.getElementById('select_tupa_d').value;
    let tip = document.getElementById('select_tipo').value;
    let ndo = document.getElementById('txt_ndocumento').value;
    let asu = document.getElementById('txt_asunto').value;
    let arc = document.getElementById('txt_archivo').value;
    let fol = document.getElementById('txt_folio').value;

    if (arc.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Seleccione un documento", "warning");
    }
    let extension = arc.split('.').pop();
    let nombrearchivo = "";
    let f = new Date();
    if (arc.length > 0) {
        nombrearchivo = "ARCH" + f.getDate() + "" + (f.getMonth() + 1) + "" + f.getFullYear() + "" + f.getHours() + "" + f.getMilliseconds() + "." + extension;
    }
    if (dni.length == 0 || nom.length == 0 || apt.length == 0 || apm.length == 0 || cel.length == 0 || ema.length == 0 || dir.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Llene todos lo datos del remitente", "warning");
    }
    if (proc.length == 0 || tip.length == 0 || ndo.length == 0 || asu.length == 0 || fol.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Llene todos lo datos del Documento", "warning");
    }
    if (validar_email(ema)) {

    } else {
        return Swal.fire("Mensaje de Advetencia", "Formato de Email Incorrecto", "warning");
    }

    let formData = new FormData();
    let archivoobj = $("#txt_archivo")[0].files[0];

    //DATOS REMITENTE
    formData.append("dni", dni);
    formData.append("nom", nom);
    formData.append("apt", apt);
    formData.append("apm", apm);
    formData.append("cel", cel);
    formData.append("ema", ema);
    formData.append("dir", dir);
    formData.append("vpresentacion", vpresentacion);
    formData.append("ruc", ruc);
    formData.append("raz", raz);

    //DATOS DOCUMENTO
    //formData.append("arp", arp);
    //formData.append("ard", ard);
    formData.append("proc", proc);
    formData.append("tip", tip);
    formData.append("ndo", ndo);
    formData.append("asu", asu);
    formData.append("nombrearchivo", nombrearchivo);
    formData.append("fol", fol);
    formData.append("archivoobj", archivoobj);

    $.ajax({
        "url": "controller/tramite/controller_regitro_tramite_externo.php",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
            if (resp.length > 0) {
                Swal.fire({
                    title: 'Enviando...',
                    text: 'Espere un momento por favor, estamos registrando su expediente',
                    timerProgressBar: true,
                    didOpen: () => {
                      Swal.showLoading();
                    }
                  });
                  
                  $.ajax({
                    
                    
                  }).done(function () {
                    $.ajax({
                      "url": "view/MAILER/index.php",
                      type: 'POST',
                      data: {
                        resp: resp,
                      }
                    }).done(function() {
                      // La segunda petición AJAX se ha completado
                      setTimeout(function() {
                        Swal.fire({
                            icon: 'success',
                            title: 'Mensaje de Confirmacion',
                            html: 'Nuevo Tramite Registrado con Nro <b> '+resp.split("-")[0]+ '</b><br><br> El cargo fue enviado a su correo: <b class="text-danger"> '+ema+'</b>',
                        }).then((value) => {
                            window.open("view/dompdf/cargo_tramite.php?codigo="+resp+"#zoom=100");
                        });
                      }); // Retrasar la ejecución del código dentro de setTimeout() durante 3 segundos (3000 milisegundos)
                      $("#content_nuevo_tramite").load("tramite_externo.php");
                    });
                  });

            } else {
                Swal.fire("Mensaje de Advertencia", "El Usuario ingresado ya se encuentra en la base de datos", "warning");
            }
        }
    });
    return false;

}

//seguimiento tramite
var tbl_seguimiento;
function listar_seguimiento_tramite(id) {
    tbl_seguimiento = $("#tabla_seguimiento").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tramite/controller_listar_tabla_seguimiento_tramite.php",
            type: 'POST',
            data: {
                id: id
            }
        },
        "columns": [
            { "data": "area_nombre" },
            { "data": "mov_fecharegistro" },
            { "data": "mov_descripcion" },
            {
                "data": "mov_archivo", render: function (data, type, row) {
                    if (data == '') {
                        return "<button class='btn btn-danger btn-sm'><i class='fa-solid fa-file-pdf disabled'></i></button>";
                    } else {
                        return "<button class='ver btn btn-info btn-sm'><i class='fa-solid fa-file-pdf'></i></button>";
                    }


                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}

///////VALIDAR EMAIL
function validar_email(email) {
    var regex = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    return regex.test(email) ? true : false;
}


function sololetras(e) {
    key = e.keyCode || e.which;

    teclado = String.fromCharCode(key).toLowerCase();

    letras = "qwertyuiopasdfghjklñzxcvbnm ";

    especiales = "8-37-38-46-164";

    teclado_especial = false;

    for (var i in especiales) {
        if (key == especiales[i]) {
            teclado_especial = true;
            break;
        }
    }

    if (letras.indexOf(teclado) == -1 && !teclado_especial) {
        return false;
    }
}

function soloNumeros(e) {
    tecla = (document.all) ? e.keyCode : e.which;
    if (tecla == 8) {
        return true;
    }
    // Patron de entrada, en este caso solo acepta numeros
    patron = /[0-9]/;
    tecla_final = String.fromCharCode(tecla);
    return patron.test(tecla_final);
}

function traer_horario_activo() {

    $.ajax({
        url: 'controller/horario/controller_listar_horario.php',
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        let horario_activo_ini = "";
        let horario_activo_fin = "";
        let dias = [];
        for (let i = 0; i < data.data.length; i++) {
            let horario = data.data[i];
            if (horario.hor_estado == 'ACTIVO') {
                horario_activo_ini = horario.hor_ini;
                horario_activo_fin = horario.hor_fin;
                dias.push(horario.hor_do);
                dias.push(horario.hor_lu);
                dias.push(horario.hor_ma);
                dias.push(horario.hor_mi);
                dias.push(horario.hor_ju);
                dias.push(horario.hor_vi);
                dias.push(horario.hor_sa);

            }
        }
        showContent(horario_activo_ini, horario_activo_fin, dias);
    });

}


function showContent(startTime, endTime, dias) {

    let fechaActual = new Date();
    let diaSemana = fechaActual.getDay();
    let hora_inicio = startTime.split(':')[0];
    let min_inicio = startTime.split(':')[1];
    let hora_fin = endTime.split(':')[0];
    let min_fin = endTime.split(':')[1];

    let fecha_actual = new Date();
    let hora_actual = fecha_actual.getHours();
    let min_actual = fecha_actual.getMinutes();

    let tiempo_inicio = new Date();
    tiempo_inicio.setHours(hora_inicio);
    tiempo_inicio.setMinutes(min_inicio);

    let tiempo_fin = new Date();
    tiempo_fin.setHours(hora_fin);
    tiempo_fin.setMinutes(min_fin);

    let tiempo_actual = new Date();
    tiempo_actual.setHours(hora_actual);
    tiempo_actual.setMinutes(min_actual);

    if (dias[diaSemana] == 1) {
        // horario actual está dentro de los días configurados

        if (tiempo_actual >= tiempo_inicio && tiempo_actual <= tiempo_fin) {
            cargar_contenido('content_nuevo_tramite', 'tramite_externo.php')
        } else {
            cargar_contenido('content_nuevo_tramite', 'message.php');
        }
    } else {
        // horario actual no está dentro de los días configurados

        cargar_contenido('content_nuevo_tramite', 'message.php');
    }





}
function cargar_contenido(id, vista) {
    $('#' + id).load(vista);
}

function cargar_hora() {
    $.ajax({
        url: 'controller/horario/controller_listar_horario.php',
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        let horario_activo_ini = "";
        let horario_activo_fin = "";
        let dias = [];
        for (let i = 0; i < data.data.length; i++) {
            let horario = data.data[i];
            if (horario.hor_estado == 'ACTIVO') {
                horario_activo_ini = horario.hor_ini;
                horario_activo_fin = horario.hor_fin;
                dias.push(horario.hor_do);
                dias.push(horario.hor_lu);
                dias.push(horario.hor_ma);
                dias.push(horario.hor_mi);
                dias.push(horario.hor_ju);
                dias.push(horario.hor_vi);
                dias.push(horario.hor_sa);
            }
        }
        let hora_inicio = horario_activo_ini.split(':')[0];
        let min_inicio = horario_activo_ini.split(':')[1];
        let hora_fin = horario_activo_fin.split(':')[0];
        let min_fin = horario_activo_fin.split(':')[1];

        let tiempo_inicio = new Date();
        tiempo_inicio.setHours(hora_inicio);
        tiempo_inicio.setMinutes(min_inicio);

        let tiempo_fin = new Date();
        tiempo_fin.setHours(hora_fin);
        tiempo_fin.setMinutes(min_fin);

        let lista_dias = findFirstAndLastDay(dias);


        document.getElementById('lbl_mantenimiento').innerHTML = "Nuestro Horario de atencion es de " + lista_dias[0] + ' a ' + lista_dias[1] + ' de ' + Calcular_Hora(tiempo_inicio) + ' a ' + Calcular_Hora(tiempo_fin);
    });


}
function Calcular_Hora(fechahora) {
    let fecha = new Date(fechahora);
    let hora = fecha.getHours();

    let periodo = 'AM';
    if (hora >= 12) {
        periodo = 'PM';
    }
    if (hora > 12) {
        hora = hora - 12;
        if (hora.toString().length > 1) {

        } else {
            hora = '0' + hora;
        }

    }
    let minutos = fecha.getMinutes();
    if (minutos < 10) {
        minutos = '0' + minutos;
    }
    return hora + ':' + minutos + '' + periodo;
}
verificar_dia();
function verificar_dia() {
    let today = new Date().getDay();

}
function findFirstAndLastDay(days) {
    let firstDay = -1, lastDay = -1;
    for (let i = 0; i < days.length; i++) {
        if (days[i] == 1) {
            if (firstDay == -1) {
                firstDay = i;
            }
            lastDay = i;
        }
    }
    let first_day = retonar_dia(firstDay);
    let last_day = retonar_dia(lastDay);

    return [first_day, last_day];
}

function retonar_dia(dia) {
    switch (dia) {
        case 0:
            return 'Domingo';
        case 1:
            return 'Lunes';
        case 2:
            return 'Martes';
        case 3:
            return 'Miercoles';
        case 4:
            return 'Jueves';
        case 5:
            return 'Viernes';
        case 6:
            return 'Sabado';


    }
}
