var tbl_tramite;
$("#select_tip_rec").change(function () {
    var tipoRecibido = $(this).val();
    parseInt(tipoRecibido);
    tbl_tramite.clear().draw();

    listar_tramite(tipoRecibido);
});
function listar_tramite(tipoRecibido) {
    let idusuario = document.getElementById('txtprincipalid').value;

    tbl_tramite = $("#tabla_tramite").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "responsive": true,
        "ajax": {
            "url": "../controller/tramite_area/controller_listar_tramite.php",
            type: 'POST',
            data: {
                idusuario: idusuario,
                tipoRecibido: tipoRecibido
            }
        },
        "columns": [
            { "data": "expe_num" },
            { "data": "doc_nrodocumento" },
            { "data": "tipodoc_descripcion" },
            { "data": "doc_dniremitente" },
            { "data": "REMITENTE" },
            { "defaultContent": "<button class='mas btn btn-primary btn-sm'><i class='fas fa-search'></i></button>" },
            { "defaultContent": "<button class='seguimiento btn btn-secondary btn-sm'><i class='fas fa-search'></i></button>" },
            {
                "data": "origen", render: function (data, type, row) {
                    if (data === '' || data === null) {
                        return 'EXTERIOR';

                    } else {
                        return data;
                    }
                }

            },
            { "data": "destino" },
            {
                "data": "doc_estatus", render: function (data, type, row) {
                    if (data == 'PENDIENTE') {
                        return '<span class="badge bg-warning">PENDIENTE</span>';
                    } else if (data == 'RECHAZADO') {
                        return '<span class="badge bg-danger">RECHAZADO</span>';
                    } else {
                        return '<span class="badge bg-success">FINALIZADO</span>';
                    }
                }
            },
            {
                "data": "doc_estatus", render: function (data, type, row) {
                    if (data == 'PENDIENTE') {
                        if (row.grupo_area_destino_id == null) {
                            return "<button class=' derivar btn btn-info btn-sm'><i class='fa-solid fa-share-from-square'></i></button>&nbsp<button class='agregar btn btn-danger btn-sm'><i class='fa-solid fa-cart-shopping'></i></button>";
                        } else {
                            return "<button class='disabled btn btn-info btn-sm'><i class='fa-solid fa-share-from-square'></i></button>&nbsp<button class='agregar btn btn-success btn-sm'><i class='fa-solid fa-cart-shopping'></i></button>";
                        }

                    } else {
                        return "";
                    }
                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}

function listar_tramite_enviado() {

    let idusuario = document.getElementById('txtprincipalid').value;
    tbl_tramite = $("#tabla_tramite").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "responsive": true,
        "ajax": {
            "url": "../controller/tramite_area/controller_listar_tramite_enviado.php",
            type: 'POST',
            data: {
                idusuario: idusuario
            }
        },
        "columns": [
            { "data": "expe_num" },
            { "data": "doc_nrodocumento" },
            { "data": "tipodoc_descripcion" },
            { "data": "doc_dniremitente" },
            { "data": "REMITENTE" },
            { "defaultContent": "<button class='mas_tra btn btn-primary btn-sm'><i class='fas fa-search'></i></button>" },
            { "data": "destino" },
            {
                "data": "doc_estatus", render: function (data, type, row) {
                    if (data == 'PENDIENTE') {
                        return '<span class="badge bg-warning">PENDIENTE</span>';
                    } else if (data == 'RECHAZADO') {
                        return '<span class="badge bg-danger">RECHAZADO</span>';
                    } else {
                        return '<span class="badge bg-success">FINALIZADO</span>';
                    }
                }
            },

        ],

        "language": idioma_espanol,
        select: true
    });

}
$('#tabla_tramite').on('click', '.derivar', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_derivar").modal('show');
    document.getElementById('lbl_titulo_derivar').innerHTML = "<b>Derivar o Finalizar Expediente Nro: </b>" + data.documento_id;
    document.getElementById('txt_fecha_de').value = data.doc_fecharegistro;
    document.getElementById('txt_origen_de').value = data.destino;
    Cargar_Select_Area_Destino(data.area_destino_id);
    document.getElementById('txt_iddocumento_de').value = data.documento_id;
    document.getElementById('txt_idareorigen').value = data.area_destino_id;
});

$('#tabla_tramite').on('click', '.agregar', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_agregar").modal('show');
    document.getElementById('lbl_titulo_agregar').innerHTML = "<b>Agregar al Carrito el Expediente Nro: </b>" + data.documento_id;
    document.getElementById('txt_origen_de_agregar').value = data.destino;
    //Cargar_Select_Area_Destino(data.area_destino);
    document.getElementById('txt_iddocumento_de_agregar').value = data.documento_id;

    //document.getElementById('area_grupo').value = data.grupo;
    //document.getElementById('txt_idareorigen').value = data.area_destino;
    $('#select_destino_d_agregar').select2().val(data.grupo_area_destino_id).trigger('change.select2');

    if (data.grupo_area_destino_id != null) {
        document.getElementById("div_btn-quitar-area-destino").style.display = "block";

    } else {
        document.getElementById("div_btn-quitar-area-destino").style.display = "none";
    }
});

$('#tabla_tramite').on('click', '.seguimiento', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_seguimiento").modal('show');
    document.getElementById('lbl_titulo').innerHTML = "Seguimiento del Expediente Nro: " + data.documento_id;
    listar_seguimiento_tramite(data.documento_id);

});

$('#tabla_tramite').on('click', '.mas', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_mas").modal('show');
    document.getElementById('lbl_titulo_datos').innerHTML = "Datos del Expediente Nro: " + data.documento_id;
    document.getElementById('txt_ndocumento').value = data.doc_nrodocumento;
    document.getElementById('txt_folio').value = data.doc_folio;
    document.getElementById('txt_asunto').value = data.doc_asunto;
    document.getElementById('txt_proc').value = data.tupa_descripcion;
    document.getElementById('txt_idtupaver').value = data.tupa_id;
    document.getElementById('txt_fechareg').value = data.doc_fecharegistro;
    $('#select_area_p').select2().val(data.area_origen).trigger('change.select2');
    $('#select_area_d').select2().val(data.area_destino).trigger('change.select2');
    $('#select_tipo').select2().val(data.tipodocumento_id).trigger('change.select2');

    document.getElementById('txt_dni').value = data.doc_dniremitente;
    document.getElementById('txt_nom').value = data.doc_nombreremitente;
    document.getElementById('txt_apepat').value = data.doc_apepatremitente;
    document.getElementById('txt_apemat').value = data.doc_apematremitente;
    document.getElementById('txt_celular').value = data.doc_celularremitente;
    document.getElementById('txt_email').value = data.doc_emailremitente;
    document.getElementById('txt_dire').value = data.doc_direccionremitente;
    document.getElementById('txt_ruc').value = data.doc_ruc;
    document.getElementById('txt_razon').value = data.doc_empresa;

    document.getElementById('pdf-frame').src = '../' + data.doc_archivo;
    if (data.doc_representacion == "A NOMBRE PROPIO") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion1').prop('checked', true);
    }
    if (data.doc_representacion == "A OTRA PERSONA NATURAL") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion2').prop('checked', true);
    }
    if (data.doc_representacion == "PERSONA JURIDICA") {
        document.getElementById('div_juridico').style.display = 'block';
        $('#rad_presentacion3').prop('checked', true);
    }

});

$('#tabla_tramite').on('click', '.mas_tra', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_mas").modal('show');
    document.getElementById('lbl_titulo_datos').innerHTML = "Datos del Tramite: " + data.documento_id;
    document.getElementById('txt_ndocumento').value = data.doc_nrodocumento;
    document.getElementById('txt_folio').value = data.doc_folio;
    document.getElementById('txt_asunto').value = data.doc_asunto;
    document.getElementById('txt_proc').value = data.tupa_descripcion;
    document.getElementById('txt_idtupaver').value = data.tupa_id;
    document.getElementById('txt_fechareg').value = data.doc_fecharegistro;
    $('#select_area_p').select2().val(data.area_id).trigger('change.select2');
    $('#select_area_d').select2().val(data.area_destino).trigger('change.select2');
    $('#select_tipo').select2().val(data.tipodocumento_id).trigger('change.select2');

    document.getElementById('txt_dni').value = data.doc_dniremitente;
    document.getElementById('txt_nom').value = data.doc_nombreremitente;
    document.getElementById('txt_apepat').value = data.doc_apepatremitente;
    document.getElementById('txt_apemat').value = data.doc_apematremitente;
    document.getElementById('txt_celular').value = data.doc_celularremitente;
    document.getElementById('txt_email').value = data.doc_emailremitente;
    document.getElementById('txt_dire').value = data.doc_direccionremitente;
    document.getElementById('txt_ruc').value = data.doc_ruc;
    document.getElementById('txt_razon').value = data.doc_empresa;
    document.getElementById('pdf-frame').src = '../' + data.doc_archivo;
    if (data.doc_representacion == "A NOMBRE PROPIO") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion1').prop('checked', true);
    }
    if (data.doc_representacion == "A OTRA PERSONA NATURAL") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion2').prop('checked', true);
    }
    if (data.doc_representacion == "PERSONA JURIDICA") {
        document.getElementById('div_juridico').style.display = 'block';
        $('#rad_presentacion3').prop('checked', true);
    }

});

function AbrirRegistro() {
    $("#modal_registro").modal({ backdrop: 'static', keyborad: false })
    $("#modal_registro").modal('show');
}
/*INICIO REGISTRAR AREA*/
function Registrar_Area() {
    let area = document.getElementById('txt_area').value;
    if (area.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
    }
    $.ajax({
        "url": "../controller/area/controller_registro_area.php",
        type: 'POST',
        data: {
            a: area
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Nuevo Area Registrado", "success").then((value) => {
                    document.getElementById('txt_area').value = "";
                    tbl_tramite.ajax.reload();
                    $("#modal_registro").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El area ingresada ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo el registro", "error");
        }
    })
}



function Registrar_Derivacion() {
    //DATOS DEL REMITENTE
    let iddo = document.getElementById('txt_iddocumento_de').value; // Usar el ID completo (ej: "491-2025")

    let orig = document.getElementById('txt_idareorigen').value;
    let dest = document.getElementById('select_destino_d').value;
    let desc = document.getElementById('txt_descripcion_de').value;
    let arch = document.getElementById('txt_documento_de').value;
    let idusu = document.getElementById('txtprincipalid').value;
    let selecttip = document.getElementById('select_derivar_de').value;
    let nombrearchivo = "";

    // Obtener el valor del checkbox de visibilidad pública
    let visible_publico = 0;
    if (arch.length > 0 && document.getElementById('chk_visible_publico').checked) {
        visible_publico = 1;
    }

    if (dest.length == 0 && selecttip == 'DERIVAR') {
        return Swal.fire("Mensaje de Advertencia", "Seleccionar Area Destino", "warning")
    }

    // Si es FINALIZAR y no hay área destino, usar NULL
    if (selecttip == 'FINALIZAR' && dest.length == 0) {
        dest = null;
    }
    let f = new Date();
    let extension = arch.split('.').pop();
    if (arch.length > 0) {

        nombrearchivo = "ARCH" + f.getDate() + "" + (f.getMonth() + 1) + "" + f.getFullYear() + "" + f.getHours() + "" + f.getMilliseconds() + "." + extension;
    }
    let accion = "";
    if (selecttip == 'DERIVAR') {
        accion = "DERIVADO";
    } else {
        accion = "FINALIZADO"
    }


    let formData = new FormData();
    let archivoobj = $("#txt_documento_de")[0].files[0];
    //DATOS REMITENTE
    formData.append("iddo", iddo);
    formData.append("orig", orig);
    formData.append("dest", dest);
    formData.append("desc", desc);
    formData.append("idusu", idusu);
    formData.append("selecttip", selecttip);
    formData.append("nombrearchivo", nombrearchivo);
    formData.append("archivoobj", archivoobj);
    formData.append("visible_publico", visible_publico);


    $.ajax({
        "url": "../controller/tramite_area/controller_regitro_tramite.php",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
            // Primero verificar si es "1" (éxito) ANTES de intentar parsear como JSON
            if (resp == "1" || resp.trim() == "1") {
                // Cerrar modal y recargar PRIMERO
                $("#modal_derivar").modal('hide');
                tbl_tramite.ajax.reload();

                // Luego mostrar mensaje de éxito y preguntar por el PDF
                Swal.fire("Mensaje de Confirmacion", "Tramite " + accion + " con Exito ", "success").then((value) => {
                    Swal.fire({
                        title: '¿Desea Generar Cargo (PDF)?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Si Generar',
                        cancelButtonText: 'No Generar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            generar_cargo_derivar(iddo, orig, dest, accion);
                        }
                    });
                });
            } else {
                // Si no es "1", intentar parsear como JSON (error)
                try {
                    var respObj = JSON.parse(resp);
                    Swal.fire("Error", respObj.message || "No se pudo completar el proceso", "error");
                    console.error("Error en derivación:", respObj);
                } catch (e) {
                    // No es ni "1" ni JSON válido
                    Swal.fire("Mensaje de Advertencia", "Respuesta inesperada del servidor", "warning");
                    console.error("Respuesta inesperada:", resp);
                }
            }
        },
        error: function(xhr, status, error) {
            Swal.fire("Error", "Error de conexión: " + error, "error");
            console.error("Error AJAX:", xhr.responseText);
        }

    });
    return false;

}
function generar_cargo_derivar(iddo, orig, dest, accion) {
    var usuario = document.getElementById('txtprincipalusu').value;

    /*Swal.fire({
        title: 'Procesando...',
        text: 'Generando Cargo',
        timerProgressBar: true,
        didOpen: () => {
            Swal.showLoading();
        }
    });*/
    $.ajax({
        "url": "MAILER/index_derivacion.php",
        type: 'POST',
        data: {
            iddo: iddo,
            usuario: usuario,
            orig: orig,
            dest: dest,
            accion: accion
        }
    });


    $.ajax({
        url: 'dompdf/cargo_tramite_derivar.php',
        type: 'POST',
        data: {
            iddo: iddo,
            usuario: usuario,
            orig: orig,
            dest: dest,
            accion: accion
        }
    }).done(function (pdfUrl) {
        var newWindow = window.open(pdfUrl, '_blank');

        // Esperar a que el PDF se haya cargado completamente
        newWindow.onload = function () {
            // Cerrar la alerta de "Procesando..." después de que el PDF se haya abierto
           // Swal.close();
        };

    });
}


/*FIN REGISTRAR AREA*/

function Modificar_Area() {
    let id = document.getElementById('txt_idarea').value;
    let area = document.getElementById('txt_area_editar').value;
    let esta = document.getElementById('select_estatus').value;
    if (area.length == 0 || id.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
    }
    $.ajax({
        "url": "../controller/area/controller_modificar_area.php",
        type: 'POST',
        data: {
            id: id,
            are: area,
            esta: esta
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Datos Actualizados", "success").then((value) => {
                    tbl_tramite.ajax.reload();
                    $("#modal_editar").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El area ingresada ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo la modificacion", "error");
        }
    })
}

function Cargar_Select_Area() {
    $.ajax({
        "url": "../controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;

        }
    })
}

function Cargar_Select_Area_Destino(id) {
    $.ajax({
        "url": "../controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        let cadena = "<option value=''></option>";

        if (data.length > 0) {
            for (let i = 0; i < data.length; i++) {
                if (data[i][0] != id) {
                    cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
                }
            }
        } else {
            cadena = "<option value=''>No hay Areas disponibles</option>";
        }

        // Verificar que los elementos existan antes de modificarlos
        if (document.getElementById('select_destino_d')) {
            document.getElementById('select_destino_d').innerHTML = cadena;
        }
        if (document.getElementById('select_destino_d_agregar')) {
            document.getElementById('select_destino_d_agregar').innerHTML = cadena;
        }
        if (document.getElementById('select_area_grupo')) {
            document.getElementById('select_area_grupo').innerHTML = cadena;
        }
    })
}
function Cargar_Select_Area_Actual() {
    let id_area_ac = document.getElementById('txtprincipalareaid').value;
    Cargar_Select_Area_Destino(id_area_ac);
}

function Cargar_Select_Tupa() {
    $.ajax({
        "url": "../controller/tramite/controller_cargar_select_tupa.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''></option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tupa_d').innerHTML = cadena;

        } else {
            cadena += " <option value=''>No hay Procedimientos disponibles</option>";
            document.getElementById('select_tupa_d').innerHTML = cadena;

        }
    })
}
function Cargar_Select_Tipo() {
    $.ajax({
        "url": "../controller/tramite/controller_cargar_select_tipo.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Tipo Documento</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tipo').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_tipo').innerHTML = cadena;
        }
    })
}
function traer_datosremitente() {
    var usuario = document.getElementById('txtprincipalusu').value;
    $.ajax({
        url: '../controller/usuario/controller_administrador_buscar.php',
        type: 'POST',
        data: {
            buscar: usuario
        }
    })
        .done(function (resp) {

            var data = JSON.parse(resp);

            if (data.length > 0) {
                console.log(data);
                $("#txt_dni").val(data[0][3]);
                $("#txt_nom").val(data[0][0]);
                $("#txt_apepat").val(data[0][1]);
                $("#txt_apemat").val(data[0][2]);
                $("#txt_celular").val(data[0][4]);
                $("#txt_email").val(data[0][5]);
                $("#txt_dire").val(data[0][6]);
            }
        });
}

function Registrar_Tramite() {
    //DATOS DEL REMITENTE
    let dni = document.getElementById('txt_dni').value;
    let nom = document.getElementById('txt_nom').value;
    let apt = document.getElementById('txt_apepat').value;
    let apm = document.getElementById('txt_apemat').value;
    let cel = document.getElementById('txt_celular').value;
    let ema = document.getElementById('txt_email').value;
    let dir = document.getElementById('txt_dire').value;
    let idusu = document.getElementById('txtprincipalid').value;

    let presentacion = document.getElementsByName('r1');
    let vpresentacion = "";
    for (let i = 0; i < presentacion.length; i++) {
        if (presentacion[i].checked) {
            vpresentacion = presentacion[i].value;
        }
    }

    let ruc = document.getElementById('txt_ruc').value;
    let raz = document.getElementById('txt_razon').value;

    //DATOS DEL DOCUMENTO
    let proc = document.getElementById('select_tupa_d').value;
    let arp = document.getElementById('txtprincipalareaid').value;
    let ard = document.getElementById('select_destino_d').value;
    let tip = document.getElementById('select_tipo').value;
    let ndo = document.getElementById('txt_ndocumento').value;
    let asu = document.getElementById('txt_asunto').value;
    let arc = document.getElementById('txt_archivo').value;
    let fol = document.getElementById('txt_folio').value;

    if (arc.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Seleccione un documento", "warning");
    }
    let extension = arc.split('.').pop();
    let nombrearchivo = "";
    let f = new Date();
    if (arc.length > 0) {
        nombrearchivo = "ARCH" + f.getDate() + "" + (f.getMonth() + 1) + "" + f.getFullYear() + "" + f.getHours() + "" + f.getMilliseconds() + "." + extension;
    }
    if (dni.length == 0 || nom.length == 0 || apt.length == 0 || apm.length == 0 || cel.length == 0 || ema.length == 0 || dir.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Llene todos lo datos del remitente", "warning");
    }
    if (proc.length == 0 || arp.length == 0 || ard.length == 0 || tip.length == 0 || ndo.length == 0 || asu.length == 0 || fol.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Llene todos lo datos del Documento", "warning");
    }

    let formData = new FormData();
    let archivoobj = $("#txt_archivo")[0].files[0];
    //DATOS REMITENTE
    formData.append("dni", dni);
    formData.append("nom", nom);
    formData.append("apt", apt);
    formData.append("apm", apm);
    formData.append("cel", cel);
    formData.append("ema", ema);
    formData.append("dir", dir);
    formData.append("vpresentacion", vpresentacion);
    formData.append("ruc", ruc);
    formData.append("raz", raz);

    //DATOS REMITENTE
    formData.append("proc", proc);
    formData.append("arp", arp);
    formData.append("ard", ard);
    formData.append("tip", tip);
    formData.append("ndo", ndo);
    formData.append("asu", asu);
    formData.append("nombrearchivo", nombrearchivo);
    formData.append("fol", fol);
    formData.append("archivoobj", archivoobj);
    formData.append("idusu", idusu);

    $.ajax({
        "url": "../controller/tramite/controller_regitro_tramite_interno.php",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
            if (resp.length > 0) {
                Swal.fire({
                    title: 'Enviando...',
                    text: 'Espere un momento por favor, estamos registrando su expediente',
                    timerProgressBar: true,
                    didOpen: () => {
                        Swal.showLoading();
                    }
                });

                $.ajax({

                }).done(function () {
                    $.ajax({
                        "url": "MAILER/index.php",
                        type: 'POST',
                        data: {
                            resp: resp,
                            ruta: data
                        }
                    }).done(function () {
                        // La segunda petición AJAX se ha completado
                        setTimeout(function () {
                            Swal.fire({
                                icon: 'success',
                                title: 'Mensaje de Confirmacion',
                                html: 'Nuevo Tramite Registrado con Nro <b> ' + resp.split("-")[0] + '</b><br><br> El cargo fue enviado a su correo: <b class="text-danger"> ' + ema + '</b>',
                            }).then((value) => {
                                // window.open("dompdf/cargo_tramite.php?codigo="+resp+"#zoom=100");
                            });
                        }); // Retrasar la ejecución del código dentro de setTimeout() durante 3 segundos (3000 milisegundos)
                        $("#content").load("modules/tramite_area/tramite_registro.php");
                    });
                });

            } else {
                Swal.fire("Mensaje de Advertencia", "El Usuario ingresado ya se encuentra en la base de datos", "warning");
            }
        }

    });
    return false;

}

//seguimiento tramite
var tbl_seguimiento;
function listar_seguimiento_tramite(id) {
    tbl_seguimiento = $("#tabla_seguimiento").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tramite/controller_listar_tabla_seguimiento_tramite.php",
            type: 'POST',
            data: {
                id: id
            }
        },
        "columns": [
            { "data": "area_nombre" },
            { "data": "mov_fecharegistro" },
            { "data": "mov_descripcion" },
            {
                "data": "mov_archivo", render: function (data, type, row) {
                    if (data == '') {
                        return "";
                    } else {
                        return "<button class='ver_ btn btn-warning btn-sm'><i class='fa-solid fa-file-pdf'></i></button>";
                    }


                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}
$('#tabla_seguimiento').on('click', '.ver_', function () {
    let data = tbl_seguimiento.row($(this).parents('tr')).data();
    if (tbl_seguimiento.row(this).child.isShown()) {
        data = tbl_seguimiento.row(this).data();
    }
    $("#modal_mostrar_anexo").modal('show');
    document.getElementById('pdf-frame_a').src = '../' + data.mov_archivo;

})

function mostar_requisitos() {
    let idtupaver = document.getElementById('txt_idtupaver').value;
    let nomtu = document.getElementById('txt_proc').value;

    $.ajax({
        "url": "../controller/tramite_area/controller_cargar_tupa_area.php",
        type: 'POST',
        data: {
            idtupaver: idtupaver
        }
    }).done(function (resp) {
        let data = JSON.parse(resp);
        let tupa_requisitos = JSON.parse(data.data[0]["tupa_requisitos"]);
        let requisitosList = $("#lista_requisitos");
        requisitosList.empty();
        if (tupa_requisitos.length > 0) {
            document.getElementById('lbl_re').innerHTML = "REQUISTOS DEL PROCEDIMIENTO ADMINISTRATIVO: " + "<br><span clas='fw-normal'>" + nomtu + "</span>";
            $("#modal_mas_requisitos").modal({ keyborad: false })
            $("#modal_mas_requisitos").modal('show');


            for (let i = 0; i < tupa_requisitos.length; i++) {
                requisitosList.append("<li class='mb-3' style='text-align:justify;'>" + tupa_requisitos[i] + "</li>");
            }
        } else {
            return Swal.fire("Mensaje de Advertencia", "No se encontro requisitos", "warning");
        }


    })

}




function Agregar_Carrito() {
    let area_grupo = document.getElementById("select_destino_d_agregar").value;
    let id_doc = document.getElementById("txt_iddocumento_de_agregar").value;
    $.ajax({
        "url": "../controller/documento/controller_agregar_grupo_area.php",
        type: 'POST',
        data: {
            area_grupo: area_grupo,
            id_doc: id_doc
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Se Añadio Correcyamente al Carrito", "success").then((value) => {
                    tbl_tramite.ajax.reload();
                    $("#modal_agregar").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "s", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "Erro Comuniquese con Soporte", "error");
        }
    });
}

function Quitar_Destino() {
    let id_doc = document.getElementById("txt_iddocumento_de_agregar").value;
    $.ajax({
        "url": "../controller/documento/controller_quitar_grupo_area.php",
        type: 'POST',
        data: {
            id_doc: id_doc
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Se Quito Correctamente del Carrito", "success").then((value) => {
                    tbl_tramite.ajax.reload();
                    $("#modal_agregar").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "s", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "Erro Comuniquese con Soporte", "error");
        }
    });
}


function Derivar_Carrito_Modal() {
    Cargar_Select_Area_Destino(document.getElementById("txtprincipalareaid").value);
    let areaorigen = document.getElementById("txtpinncipalarea").value;
    document.getElementById("txt_origen_de_carrito").value = areaorigen;
    $("#modal_derivar_carrito").modal('show');

    $("#select_area_grupo").change(function () {
        let idareades = $(this).val();
        parseInt(idareades);
        //tbl_tramite.clear().draw();

        Mostrar_Carrito_Area(idareades);
    });


}

var tbl_tramite_carrito_area;
function Mostrar_Carrito_Area(idareades) {
    let idusuario = document.getElementById('txtprincipalid').value;
    tbl_tramite_carrito_area = $("#tabla_carrito_area").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": false,
        "lengthMenu": [[100, -1], [100, "All"]],
        "bLengthChange": false,
        "pageLength": 100,
        "pageLength": 100,
        "destroy": true,
        "async": false,
        "processing": true,
        "responsive": true,
        "ajax": {
            "url": "../controller/tramite_area/controller_listar_tramite_carrito_area.php",
            type: 'POST',
            data: {
                idusuario: idusuario,
                idareades: idareades
            }
        },
        "columns": [
            { "data": "documento_id" },
            { "data": "doc_dniremitente" },
            { "data": "REMITENTE" },
            { "defaultContent": "<button class='ver_doc btn btn-primary btn-sm'><i class='fa-solid fa-file-pdf'></i></button>" },
        ],

        "language": idioma_espanol,
        select: true
    });

}

$('#tabla_carrito_area').on('click', '.ver_doc', function () {
    let data = tbl_tramite_carrito_area.row($(this).parents('tr')).data();
    if (tbl_tramite_carrito_area.row(this).child.isShown()) {
        data = tbl_tramite_carrito_area.row(this).data();
    }
    $("#modal_mostrar_documento_principal").modal('show');
    document.getElementById('pdf-frame_a_carrito').src = '../' + data.doc_archivo;

})

$("#modal_derivar_carrito").on("hidden.bs.modal", function () {
    $("#tabla_carrito_area").empty();
});

var documentoIdsCarrito = [];
var areaorigencarrito;
var areadestinocarrito;
var usuariocarrito;
function Registrar_Derivacion_Carrito() {
    let idareades = document.getElementById("select_area_grupo").value;
    let idusuario = document.getElementById('txtprincipalid').value;
    let idareaorigen = document.getElementById("txtprincipalareaid").value;
    if (idareades == "") {
        return Swal.fire("Advertencia", "Seleccione el Area Destino para el Carrito", "error");
    }

    $.ajax({
        url: "../controller/tramite_area/controller_listar_tramite_carrito_area.php",
        type: 'POST',
        data: {
            idusuario: idusuario,
            idareades: idareades
        }
    }).done(function (resp) {
        data = JSON.parse(resp);
        if (data.data.length > 0) {
            let documentoIds = [];
            for (let i = 0; i < data.data.length; i++) {
                let documentoId = data.data[i]["documento_id"];
                derivar_expediente_carrito_server(data.data[i]["documento_id"], idareaorigen, idareades, idusuario);
                documentoIds.push(documentoId);

            }
           
            //generar_cargo_derivar_carrito(documentoIds, idareaorigen, idareades, idusuario);


        };
    });
}

function derivar_expediente_carrito_server(iddoc, idareaorigen, idareades, idusuario) {
   
    //DATOS DEL REMITENTE
    let iddo = iddoc;
     documentoIdsCarrito.push(iddo);
    let orig = idareaorigen;
    areaorigencarrito = orig;
    let dest = idareades;
    areadestinocarrito = idareades;
    let desc = "";
    let arch = "";
    let idusu = idusuario;
    usuariocarrito = idusu;
    let selecttip = "DERIVAR";
    let nombrearchivo = "";
    if (dest.length == 0 && selecttip == 'DERIVAR') {
        return Swal.fire("Mensaje de Advertencia", "Seleccionar Area Destino", "warning")
    }
    let f = new Date();
    let extension = arch.split('.').pop();
    if (arch.length > 0) {

        nombrearchivo = "ARCH" + f.getDate() + "" + (f.getMonth() + 1) + "" + f.getFullYear() + "" + f.getHours() + "" + f.getMilliseconds() + "." + extension;
    }
    let accion = "";
    if (selecttip == 'DERIVAR') {
        accion = "DERIVADO";
    } else {
        accion = "FINALIZADO"
    }


    let formData = new FormData();
    let archivoobj = "";
    //DATOS REMITENTE
    formData.append("iddo", iddo);
    formData.append("orig", orig);
    formData.append("dest", dest);
    formData.append("desc", desc);
    formData.append("idusu", idusu);
    formData.append("selecttip", selecttip);
    formData.append("nombrearchivo", nombrearchivo);
    formData.append("archivoobj", archivoobj);


    $.ajax({
        "url": "../controller/tramite_area/controller_regitro_tramite.php",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
            if (resp.length > 0) {
                Swal.fire("Mensaje de Confirmacion", "Carrito " + accion + " con Exito ", "success").then((value) => {
                    $("#modal_derivar_carrito").modal('hide');
                    tbl_tramite.ajax.reload();
                    Swal.fire({
                        title: '¿Desea Generar Cargo (PDF)?',
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Si Generar',
                        cancelButtonText: 'No Generar'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            generar_cargo_derivar_carrito(documentoIdsCarrito, areaorigencarrito, areadestinocarrito, usuariocarrito);
                        }
                    });
                });


            } else {
                Swal.fire("Mensaje de Advertencia", "No se pudo completar el proceso", "warning");
            }
        }

    });
    return false;

}
function generar_cargo_derivar_carrito(documentoIds, idareaorigen, idareades, idusuario) {


    $.ajax({
        url: 'dompdf/cargo_tramite_derivar_carrito.php',
        type: 'POST',
        data: {
            iddo: documentoIds.join(','),
            usuario: idusuario,
            orig: idareaorigen,
            dest: idareades
        }
    }).done(function (pdfUrl) {
        var newWindow = window.open(pdfUrl, '_blank');

        // Esperar a que el PDF se haya cargado completamente
        newWindow.onload = function () {
            // Cerrar la alerta de "Procesando..." después de que el PDF se haya abierto
            //Swal.close();
        };

    });

}