var tbl_tramite;
function listar_tramite() {
    tbl_tramite = $("#tabla_tramite").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tramite/controller_listar_tramite.php",
            type: 'POST'
        },
        "columns": [
            { "data": "documento_id" },
            { "data": "doc_nrodocumento" },
            { "data": "tipodoc_descripcion" },
            { "data": "doc_dniremitente" },
            { "data": "REMITENTE" },
            { "defaultContent": "<button class='mas btn btn-primary btn-sm'><i class='fas fa-search'></i></button>" },
            { "defaultContent": "<button class='seguimiento btn btn-secondary btn-sm'><i class='fas fa-search'></i></button>" },
            { "data": "origen" },
            { "data": "destino" },
            {
                "data": "doc_estatus", render: function (data, type, row) {
                    if (data == 'PENDIENTE') {
                        return '<span class="badge bg-warning">PENDIENTE</span>';
                    } else if (data == 'RECHAZADO') {
                        return '<span class="badge bg-danger">RECHAZADO</span>';
                    } else {
                        return '<span class="badge bg-success">FINALIZADO</span>';
                    }
                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}

$('#tabla_tramite').on('click', '.editar', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_editar").modal('show');
    document.getElementById('txt_area_editar').value = data.area_nombre;
    document.getElementById('txt_idarea').value = data.area_cod;
    document.getElementById('select_estatus').value = data.area_estado;
})

$('#tabla_tramite').on('click', '.seguimiento', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_seguimiento").modal('show');
    document.getElementById('lbl_titulo').innerHTML="Seguimiento del Tramite: "+data.documento_id;
    listar_seguimiento_tramite(data.documento_id);

});

$('#tabla_tramite').on('click', '.mas', function () {
    let data = tbl_tramite.row($(this).parents('tr')).data();
    if (tbl_tramite.row(this).child.isShown()) {
        data = tbl_tramite.row(this).data();
    }
    $("#modal_mas").modal('show');
    document.getElementById('lbl_titulo_datos').innerHTML="Datos del Tramite: "+data.documento_id;
    document.getElementById('txt_ndocumento').value = data.doc_nrodocumento;
    document.getElementById('txt_folio').value = data.doc_folio;
    document.getElementById('txt_asunto').value = data.doc_asunto;
    document.getElementById('txt_proc').value = data.tupa_descripcion;
    document.getElementById('txt_idtupaver').value = data.tupa_id;
    document.getElementById('txt_fechareg').value = data.doc_fecharegistro;
    $('#select_area_p').select2().val(data.area_origen).trigger('change.select2');
    $('#select_area_d').select2().val(data.area_destino).trigger('change.select2');
    $('#select_tipo').select2().val(data.tipodocumento_id).trigger('change.select2');

    document.getElementById('txt_dni').value = data.doc_dniremitente;
    document.getElementById('txt_nom').value = data.doc_nombreremitente;
    document.getElementById('txt_apepat').value = data.doc_apepatremitente;
    document.getElementById('txt_apemat').value = data.doc_apematremitente;
    document.getElementById('txt_celular').value = data.doc_celularremitente;
    document.getElementById('txt_email').value = data.doc_emailremitente;
    document.getElementById('txt_dire').value = data.doc_direccionremitente;
    document.getElementById('txt_ruc').value = data.doc_ruc;
    document.getElementById('txt_razon').value = data.doc_empresa;
    document.getElementById('pdf-frame').src= '../'+data.doc_archivo;
    if (data.doc_representacion == "A NOMBRE PROPIO") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion1').prop('checked', true);
    }
    if (data.doc_representacion == "A OTRA PERSONA NATURAL") {
        document.getElementById('div_juridico').style.display = 'none';
        $('#rad_presentacion2').prop('checked', true);
    }
    if (data.doc_representacion == "PERSONA JURIDICA") {
        document.getElementById('div_juridico').style.display = 'block';
        $('#rad_presentacion3').prop('checked', true);
    }
 
});


function AbrirRegistro() {
    $("#modal_registro").modal({ backdrop: 'static', keyborad: false })
    $("#modal_registro").modal('show');
}
/*INICIO REGISTRAR AREA*/

function Cargar_Select_Tupa() {
    $.ajax({
        "url": "../controller/tramite/controller_cargar_select_tupa.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''></option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tupa_d').innerHTML = cadena;
            
        } else {
            cadena += " <option value=''>No hay Procedimientos disponibles</option>";
            document.getElementById('select_tupa_d').innerHTML = cadena;
            
        }
    })
}


function Cargar_Select_Area() {
    $.ajax({
        "url": "../controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Area</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_area_p').innerHTML = cadena;
            document.getElementById('select_area_d').innerHTML = cadena;
        }
    })
}
function Cargar_Select_Tipo() {
    $.ajax({
        "url": "../controller/tramite/controller_cargar_select_tipo.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>Seleccionar Tipo Documento</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_tipo').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay Areas disponibles</option>";
            document.getElementById('select_tipo').innerHTML = cadena;
        }
    })
}

function Registrar_Tramite() {
    //DATOS DEL REMITENTE
    let dni = document.getElementById('txt_dni').value;
    let nom = document.getElementById('txt_nom').value;
    let apt = document.getElementById('txt_apepat').value;
    let apm = document.getElementById('txt_apemat').value;
    let cel = document.getElementById('txt_celular').value;
    let ema = document.getElementById('txt_email').value;
    let dir = document.getElementById('txt_dire').value;
    let idusu = document.getElementById('txtprincipalid').value;
    let presentacion = document.getElementsByName('r1');
    let vpresentacion = "";
    for (let i = 0; i < presentacion.length; i++) {
        if (presentacion[i].checked) {
            vpresentacion = presentacion[i].value;
        }
    }

    let ruc = document.getElementById('txt_ruc').value;
    let raz = document.getElementById('txt_razon').value;

    //DATOS DEL DOCUMENTO
    let arp = document.getElementById('select_area_p').value;
    let ard = document.getElementById('select_area_d').value;
    let proc = document.getElementById('select_tupa_d').value;
    let tip = document.getElementById('select_tipo').value;
    let ndo = document.getElementById('txt_ndocumento').value;
    let asu = document.getElementById('txt_asunto').value;
    let arc = document.getElementById('txt_archivo').value;
    let fol = document.getElementById('txt_folio').value;

    if (arc.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Seleccione un documento", "warning");
    }
    let extension = arc.split('.').pop();
    let nombrearchivo = "";
    let f = new Date();
    if (arc.length > 0) {
        nombrearchivo = "ARCH" + f.getDate() + "" + (f.getMonth() + 1) + "" + f.getFullYear() + "" + f.getHours() + "" + f.getMilliseconds() + "." + extension;
    }
    if (dni.length == 0 || nom.length == 0 || apt.length == 0 || apm.length == 0 || cel.length == 0 || ema.length == 0 || dir.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Llene todos lo datos del remitente", "warning");
    }
    if (arp.length == 0 ||ard.length == 0 ||proc.length == 0 || tip.length == 0 || ndo.length == 0 || asu.length == 0 || fol.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Llene todos lo datos del Documento", "warning");
    }
    if(validar_email(ema)){

    }else{
        return Swal.fire("Mensaje de Advetencia", "Formato de Email Incorrecto", "warning");
    }

    let formData = new FormData();
    let archivoobj = $("#txt_archivo")[0].files[0];
    //DATOS REMITENTE
    formData.append("dni", dni);
    formData.append("nom", nom);
    formData.append("apt", apt);
    formData.append("apm", apm);
    formData.append("cel", cel);
    formData.append("ema", ema);
    formData.append("dir", dir);
    formData.append("vpresentacion", vpresentacion);
    formData.append("ruc", ruc);
    formData.append("raz", raz);

    //DATOS DOCUMENTO
    formData.append("arp", arp);
    formData.append("ard", ard);
    formData.append("proc", proc);
    formData.append("tip", tip);
    formData.append("ndo", ndo);
    formData.append("asu", asu);
    formData.append("nombrearchivo", nombrearchivo);
    formData.append("fol", fol);
    formData.append("archivoobj", archivoobj);
    formData.append("idusu", idusu);

    $.ajax({
        "url": "../controller/tramite/controller_regitro_tramite_interno.php",
        type: 'POST',
        data: formData,
        contentType: false,
        processData: false,
        success: function (resp) {
            if (resp.length > 0) {
                Swal.fire({
                    title: 'Enviando...',
                    text: 'Espere un momento por favor, estamos registrando su expediente',
                    timerProgressBar: true,
                    didOpen: () => {
                      Swal.showLoading();
                    }
                  });
                  
                  $.ajax({
                   
                  }).done(function () {
                    $.ajax({
                      "url": "MAILER/index.php",
                      type: 'POST',
                      data: {
                        resp: resp,
                        ruta: data
                      }
                    }).done(function() {
                      // La segunda petición AJAX se ha completado
                      setTimeout(function() {
                        Swal.fire({
                            icon: 'success',
                            title: 'Mensaje de Confirmacion',
                            html: 'Nuevo Tramite Registrado con Nro <b> '+resp.split("-")[0]+ '</b><br><br> El cargo fue enviado a su correo: <b class="text-danger"> '+ema+'</b>',
                        });
                      }); // Retrasar la ejecución del código dentro de setTimeout() durante 3 segundos (3000 milisegundos)
                      $("#content").load("modules/tramite/tramite_registro.php");
                    });
                  });
               


            } else {
                Swal.fire("Mensaje de Advertencia", "El Usuario ingresado ya se encuentra en la base de datos", "warning");
            }
        }

    });
    return false;

}

//seguimiento tramite
var tbl_seguimiento;
function listar_seguimiento_tramite(id) {
    tbl_seguimiento = $("#tabla_seguimiento").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/tramite/controller_listar_tabla_seguimiento_tramite.php",
            type: 'POST',
            data: {
                id:id
            }
        },
        "columns": [
            { "data": "area_nombre" },
            { "data": "mov_fecharegistro" },
            { "data": "mov_descripcion" },
            {
                "data": "mov_archivo", render: function (data, type, row) {
                    if (data == '') {
                        return "";
                    }else{
                        return "<button class='ver_a_adm btn btn-warning btn-sm'><i class='fa-solid fa-file-pdf'></i></button>";
                    }
                    
                    
                }
            }
        ],

        "language": idioma_espanol,
        select: true
    });

}

///////VALIDAR EMAIL
function validar_email(email) {
    var regex = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
    return regex.test(email) ? true : false;
}


$('#tabla_seguimiento').on('click', '.ver_a_adm', function () {
    let data = tbl_seguimiento.row($(this).parents('tr')).data();
    if (tbl_seguimiento.row(this).child.isShown()) {
        data = tbl_seguimiento.row(this).data();
    }
    $("#modal_mostrar_anexo").modal('show');
    document.getElementById('pdf-frame_a_adm').src= '../'+data.mov_archivo;
    
})
function mostar_requisitos() {
    let idtupaver = document.getElementById('txt_idtupaver').value;
    let nomtu = document.getElementById('txt_proc').value;
    
    $.ajax({
        "url": "../controller/tramite_area/controller_cargar_tupa_area.php",
        type: 'POST',
        data: {
            idtupaver: idtupaver
        }
    }).done(function (resp) {
        let data = JSON.parse(resp);
        let tupa_requisitos = JSON.parse(data.data[0]["tupa_requisitos"]);
        let requisitosList = $("#lista_requisitos");
        requisitosList.empty();
        if (tupa_requisitos.length > 0) {
            document.getElementById('lbl_re').innerHTML = "REQUISTOS DEL PROCEDIMIENTO ADMINISTRATIVO: " + "<br><span clas='fw-normal'>" + nomtu + "</span>";
            $("#modal_mas_requisitos").modal({ keyborad: false })
            $("#modal_mas_requisitos").modal('show');
            

            for (let i = 0; i < tupa_requisitos.length; i++) {
                requisitosList.append("<li class='mb-3' style='text-align:justify;'>" + tupa_requisitos[i] + "</li>");
            }
        } else {
            return Swal.fire("Mensaje de Advertencia", "No se encontro requisitos", "warning");
        }
        

    })

}