var tbl_tipodocumento;
function listar_tipodocumento() {
    tbl_tipodocumento = $("#tabla_tipo").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/documento/controller_listar_tipo.php",
            type: 'POST'
        },
        "columns": [
            { "defaultContent": "" },
            { "data": "tipodoc_descripcion" },
            { "data": "tipodoc_fregistro" },
            {
                "data": "tipodoc_estado", render: function (data, type, row) {
                    if (data == 'ACTIVO') {
                        return '<span class="badge bg-success">ACTIVO</span>';
                    } else {
                        return '<span class="badge bg-danger">INACTIVO</span>';
                    }
                }
            },
            { "defaultContent": "<button class=' editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button>&nbsp<button class=' eliminar btn btn-danger btn-sm'><i class='fa-solid fa-trash'></i></button>" },
        ],

        "language": idioma_espanol,
        select: true
    });
    tbl_tipodocumento.on('draw.td', function () {
        var PageInfo = $("#tabla_tipo").DataTable().page.info();
        tbl_tipodocumento.column(0, { page: 'current' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

}

$('#tabla_tipo').on('click','.editar',function(){
    let data = tbl_tipodocumento.row($(this).parents('tr')).data();
    if(tbl_tipodocumento.row(this).child.isShown()){
         data = tbl_tipodocumento.row(this).data();
    }
    $("#modal_editar").modal('show');
    document.getElementById('txt_tipo_editar').value=data.tipodoc_descripcion;
    document.getElementById('txt_idtipo').value=data.tipodocumento_id;
    document.getElementById('select_estatus').value=data.tipodoc_estado;
})
$('#tabla_tipo').on('click','.eliminar',function(){
    let data = tbl_tipodocumento.row($(this).parents('tr')).data();
    if(tbl_tipodocumento.row(this).child.isShown()){
         data = tbl_tipodocumento.row(this).data();
    }
    Swal.fire({
        title: '¿Desea Eliminar el Tipo Documento?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            eliminar_tipo_documento(data.tipodocumento_id);      
        }
      });
});
function eliminar_tipo_documento(id) {
    $.ajax({
        "url": "../controller/documento/controller_eliminar_tipo.php",
        type: 'POST',
        data: {
            id: id,
  
        }
    }).done(function (resp) {
        if (resp == 1) {
            Swal.fire("Mensaje de Confirmacion", "Tipo Documento Eliminado con Exito", "success").then((value) => {
                tbl_tipodocumento.ajax.reload();
            });
  
  
        } else if (resp == 2) {
            Swal.fire("Mensaje de Advertencia", "No se puede Eliminar, el Tipo Documento se Encuentra Activo", "warning");
        } else {
            Swal.fire("Mensaje de Error", "No se completo la operacion, El registro esta siendo utilizado por otra instancia, comuniquese con Soporte", "error");
        }
  
    });
  
  }
function AbrirRegistro() {
    $("#modal_registro").modal({ backdrop: 'static', keyborad: false })
    $("#modal_registro").modal('show');
}
/*INICIO REGISTRAR AREA*/ 
function Registrar_Tipo() {
    let tipo = document.getElementById('txt_tipo').value;
    if (tipo.length == 0) {
        return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
    }
    $.ajax({
        "url": "../controller/documento/controller_registro_tipo.php",
        type: 'POST',
        data:{
            tipo:tipo
        }
    }).done(function (resp) {
        if(resp>0){
            if(resp==1){
                Swal.fire("Mensaje de Confirmacion","Nuevo Tipo Documento Registrado","success").then((value)=>{
                    document.getElementById('txt_tipo').value="";
                    tbl_tipodocumento.ajax.reload();
                    $("#modal_registro").modal('hide');

                })

            }else{
                Swal.fire("Mensaje de Advertencia","El Tipo Documento ya se encuentra en la base de datos","warning");
            }

        }else{
            return Swal.fire("Mensaje de Error","No se completo el registro","error");
        }
    })
}
/*FIN REGISTRAR AREA*/ 

function Modificar_Tipo() {
    let id = document.getElementById('txt_idtipo').value;
    let tipo = document.getElementById('txt_tipo_editar').value;
    let esta = document.getElementById('select_estatus').value;
    if (tipo.length == 0 || id.length==0) {
        return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
    }
    $.ajax({
        "url": "../controller/documento/controller_modificar_tipo.php",
        type: 'POST',
        data:{
            id:id,
            tipo:tipo,
            esta:esta
        }
    }).done(function (resp) {
        if(resp>0){
            if(resp==1){
                Swal.fire("Mensaje de Confirmacion","Datos Actualizados","success").then((value)=>{
                    tbl_tipodocumento.ajax.reload();
                    $("#modal_editar").modal('hide');

                })

            }else{
                Swal.fire("Mensaje de Advertencia","El Tipo de Documento ingresado ya se encuentra en la base de datos","warning");
            }

        }else{
            return Swal.fire("Mensaje de Error","No se completo la modificacion","error");
        }
    })
}