

function iniciar_sesion() {
  recuerdame();
  let user = document.getElementById('txt-user').value;
  let pass = document.getElementById('txt-pass').value;
  if (user.length == 0 || pass.length == 0) {
    return Swal.fire('Mensaje de Advertencia', 'Los campos estan vacios', 'warning');
  }
  $.ajax({
    url: 'controller/usuario/controller_iniciar_sesion.php',
    type: 'POST',
    data: {
      u: user,
      c: pass
    }
  }).done(function (resp) {
    let data = JSON.parse(resp);
    if (data.length > 0) {
      if (data[0][6] == "INACTIVO") {
        return Swal.fire('Mensaje de Advertencia', 'El usuario ' + user + ' se encuentra incativo', 'warning');
      }
      $.ajax({
        url: 'controller/usuario/controller_crear_sesion.php',
        type: 'POST',
        data: {
          idusuario: data[0][0],
          usuario: data[0][1],
          rol: data[0][7],
          nombres: data[0][12],
          area: data[0][11],
          idpriarea: data[0][10],
          fotoempleado: data[0][13]
        }
      }).done(function (r) {
        let timerInterval
        Swal.fire({
          title: 'Bienvenido al sistema!',
          html: 'Seras redirecionado en <b></b> milliseconds.',
          timer: 2000,
          timerProgressBar: true,
          didOpen: () => {
            Swal.showLoading()
            const b = Swal.getHtmlContainer().querySelector('b')
            timerInterval = setInterval(() => {
              b.textContent = Swal.getTimerLeft()
            }, 15)
          },
          willClose: () => {
            clearInterval(timerInterval)
          }
        }).then((result) => {
          /* Read more about handling dismissals below */
          if (result.dismiss === Swal.DismissReason.timer) {
            location.reload();
          }
        })
      })
    } else {
      Swal.fire('Mensaje de Error', 'Contraseña o usuario incorrecto', 'error');
    }
  })
}
/* recuerdame*/

function recuerdame() {
  if (rmcheck.checked && usuarioInput.value != "" && passInput.value != "") {
    localStorage.usuario = usuarioInput.value;
    localStorage.pass = passInput.value;
    localStorage.checkbox = rmcheck.value;
  } else {
    localStorage.usuario = "";
    localStorage.pass = "";
    localStorage.checkbox = "";
  }
}

var tbl_usuario;
function listar_usuario() {
  tbl_usuario = $("#tabla_usuario").DataTable({
    "ordering": false,
    "bLengthChange": true,
    "searching": { "regex": false },
    "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
    "pageLength": 10,
    "destroy": true,
    "async": false,
    "processing": true,
    "responsive": true,
    "ajax": {
      "url": "../controller/usuario/controller_listar_usuario.php",
      type: 'POST'
    },
    "columns": [
      { "defaultContent": "" },
      { "data": "usu_usuario" },
      { "data": "area_nombre" },
      { "data": "usu_rol" },
      { "data": "nempleado" },
      {
        "data": "usu_estatus", render: function (data, type, row) {
          if (data == 'ACTIVO') {
            return '<span class="badge bg-success">ACTIVO</span>';
          } else {
            return '<span class="badge bg-danger">INACTIVO</span>';
          }
        }
      },
      {
        "data": "usu_estatus", render: function (data, type, row) {
          if (data == 'ACTIVO') {
            return "<button class='editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button>&nbsp<button class='contra btn btn-info btn-sm'><i class='fa-solid fa-key'></i></button>&nbsp<button class='desactivar btn btn-outline-danger btn-sm'><i class='fa-solid fa-lock-open'></i></button>&nbsp";
          } else {
            return "<button class=' btn btn-secondary btn-sm' disabled><i class='fas fa-pencil-alt'></i></button>&nbsp<button class='contra btn btn-info btn-sm' disabled><i class='fa-solid fa-key'></i></button>&nbsp<button class='activar btn btn-danger btn-sm'><i class='fa-solid fa-lock'></i></button>&nbsp";
          }
        }
      }
    ],
    "createdRow": function (row, data, dataIndex) {
      // Deshabilitar la primera fila
      if (dataIndex === 0) {
        $(row).find('button').prop('disabled', true);
      }
    },

    "language": idioma_espanol,
    select: true
  });
  tbl_usuario.on('draw.td', function () {
    var PageInfo = $("#tabla_usuario").DataTable().page.info();
    tbl_usuario.column(0, { page: 'current' }).nodes().each(function (cell, i) {
      cell.innerHTML = i + 1 + PageInfo.start;
    });
  });

}
$('#tabla_usuario').on('click', '.editar', function () {
  let data = tbl_usuario.row($(this).parents('tr')).data();
  if (tbl_usuario.row(this).child.isShown()) {
    data = tbl_usuario.row(this).data();
  }
  $("#modal_editar").modal('show');
  document.getElementById('txt_idusuario').value = data.usu_id;
  document.getElementById('txt_usu_editar').value = data.usu_usuario;
  $('#select_empleado_editar').select2().val(data.empleado_id).trigger('change.select2');
  $('#select_area_editar').select2().val(data.area_id).trigger('change.select2');
  $('#select_rol_editar').select2().val(data.usu_rol).trigger('change.select2');

})

$('#tabla_usuario').on('click', '.contra', function () {
  let data = tbl_usuario.row($(this).parents('tr')).data();
  if (tbl_usuario.row(this).child.isShown()) {
    data = tbl_usuario.row(this).data();
  }
  $("#modal_contra").modal('show');
  document.getElementById('txt_idusuario_contra').value = data.usu_id;

})

$('#tabla_usuario').on('click', '.desactivar', function () {
  let data = tbl_usuario.row($(this).parents('tr')).data();
  if (tbl_usuario.row(this).child.isShown()) {
    data = tbl_usuario.row(this).data();
  }
  Swal.fire({
    title: '¿Desea desactivar el usuario ' + data.usu_usuario + '?',
    text: "Una vez desactivado el usuario, No tendra acceso al sistema!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'SI'
  }).then((result) => {
    if (result.isConfirmed) {
      Modificar_Estatus_Usuario(parseInt(data.usu_id), 'INACTIVO')
    }
  })

})
$('#tabla_usuario').on('click', '.activar', function () {
  let data = tbl_usuario.row($(this).parents('tr')).data();
  if (tbl_usuario.row(this).child.isShown()) {
    data = tbl_usuario.row(this).data();
  }
  Swal.fire({
    title: '¿Desea activar el usuario ' + data.usu_usuario + '?',
    text: "Una vez activado el usuario, Podra tener acceso al sistema!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'SI'
  }).then((result) => {
    if (result.isConfirmed) {
      Modificar_Estatus_Usuario(parseInt(data.usu_id), 'ACTIVO')
    }
  })

})

function AbrirRegistro() {
  $("#modal_registro").modal({ backdrop: 'static', keyborad: false })
  $("#modal_registro").modal('show');
}


function Registrar_Usuario() {
  let usu = document.getElementById('txt_usu').value;
  let con = document.getElementById('txt_con').value;
  let ide = document.getElementById('select_empleado').value;
  let ida = document.getElementById('select_area').value;
  let rol = document.getElementById('select_rol').value;
  if (usu.length == 0 || con.length == 0 || ide.length == 0 || ida.length == 0 || rol.length == 0) {
    return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
  }
  $.ajax({
    "url": "../controller/usuario/controller_registro_usuario.php",
    type: 'POST',
    data: {
      usu: usu,
      con: con,
      ide: ide,
      ida: ida,
      rol: rol
    }
  }).done(function (resp) {

    if (resp > 0) {
      if (resp == 1) {
        Swal.fire("Mensaje de Confirmacion", "Nuevo Usuario Registrado", "success").then((value) => {
          document.getElementById('txt_usu').value = "";
          document.getElementById('txt_con').value = "";
          document.getElementById('select_empleado').value = "";
          document.getElementById('select_area').value = "";
          document.getElementById('select_rol').value = "";
          tbl_usuario.ajax.reload();
          $("#modal_registro").modal('hide');

        })

      } else {
        Swal.fire("Mensaje de Advertencia", "El Usuario ingresado ya se encuentra en la base de datos", "warning");
      }

    } else {
      return Swal.fire("Mensaje de Error", "No se completo el registro", "error");
    }
  })
}
function Modificar_Usuario() {

  let id = document.getElementById('txt_idusuario').value;
  let ide = document.getElementById('select_empleado_editar').value;
  let ida = document.getElementById('select_area_editar').value;
  let rol = document.getElementById('select_rol_editar').value;
  if (id.length == 0 || ide.length == 0 || ida.length == 0 || rol.length == 0) {
    return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
  }
  $.ajax({
    "url": "../controller/usuario/controller_modificar_usuario.php",
    type: 'POST',
    data: {
      id: id,
      ide: ide,
      ida: ida,
      rol: rol
    }
  }).done(function (resp) {
    if (resp > 0) {
      Swal.fire("Mensaje de Confirmacion", "Datos del Usuario Actualizado", "success").then((value) => {
        tbl_usuario.ajax.reload();
        $("#modal_editar").modal('hide');

      })

    } else {
      return Swal.fire("Mensaje de Error", "No se completo la actualizacion", "error");
    }
  })
}
function Modificar_Contraseña() {
  let id = document.getElementById('txt_idusuario_contra').value;
  let con = document.getElementById('txt_contra_nueva').value;
  if (id.length == 0 || con.length == 0) {
    return Swal.fire("Mensaje de Advetencia", "Tiene campos vacios", "warning");
  }
  $.ajax({
    "url": "../controller/usuario/controller_modificar_contra.php",
    type: 'POST',
    data: {
      id: id,
      con: con
    }
  }).done(function (resp) {
    if (resp > 0) {
      Swal.fire("Mensaje de Confirmacion", "Contraseña del Usuario Actualizado", "success").then((value) => {
        tbl_usuario.ajax.reload();
        document.getElementById('txt_contra_nueva').value = ""; //para que limpie el modal contra
        $("#modal_contra").modal('hide');

      })

    } else {
      return Swal.fire("Mensaje de Error", "No se completo la actualizacion", "error");
    }
  })
}
function Modificar_Estatus_Usuario(id, estatus) {
  let esta = estatus;
  if (esta == 'INACTIVO') {
    esta = 'DESACTIVADO'
  } else {
    esta = 'ACTIVADO';
  }
  $.ajax({
    "url": "../controller/usuario/controller_modificar_usuario_estatus.php",
    type: 'POST',
    data: {
      id: id,
      estatus: estatus
    }
  }).done(function (resp) {
    if (resp > 0) {
      Swal.fire("Mensaje de Confirmacion", "Usuario " + esta + " con exito", "success").then((value) => {
        tbl_usuario.ajax.reload();
      })

    } else {
      return Swal.fire("Mensaje de Error", "No se completo la actualizacion", "error");
    }
  })
}

function Cargar_Select_Empleado() {
  $.ajax({
    "url": "../controller/usuario/controller_cargar_select_empleado.php",
    type: 'POST',
  }).done(function (resp) {
    let data = JSON.parse(resp);
    if (data.length > 0) {
      let cadena = "<option value=''></option>";
      for (let i = 0; i < data.length; i++) {
        cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
      }
      document.getElementById('select_empleado').innerHTML = cadena;
      document.getElementById('select_empleado_editar').innerHTML = cadena;
    } else {
      cadena += " <option value=''>No hay empleados disponibles</option>";
      document.getElementById('select_empleado').innerHTML = cadena;
      document.getElementById('select_empleado_editar').innerHTML = cadena;
    }
  })
}

function Cargar_Select_Area() {
  $.ajax({
    "url": "../controller/usuario/controller_cargar_select_area.php",
    type: 'POST',
  }).done(function (resp) {
    let data = JSON.parse(resp);
    if (data.length > 0) {
      let cadena = "<option value=''></option>";
      for (let i = 0; i < data.length; i++) {
        cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
      }
      document.getElementById('select_area').innerHTML = cadena;
      document.getElementById('select_area_editar').innerHTML = cadena;
    } else {
      cadena += " <option value=''>No hay empleados disponibles</option>";
      document.getElementById('select_area').innerHTML = cadena;
      document.getElementById('select_area_editar').innerHTML = cadena;
    }
  })
}


//SEGUIMIENTO TRAMITE

function Traer_Datos_Seguimiento() {
  let numero = document.getElementById('txt_numero').value;
  let dni = document.getElementById('txt_dni').value;
  let anio = document.getElementById('txt_año').value;
  let num_anio = numero + "-" + anio;

  if (numero.length == 0 || dni.length == 0) {
    return Swal.fire("Mensaje de Advertencia", "Tiene Campos Vacios", "warning");
  }
  $.ajax({
    "url": "controller/usuario/controller_traer_seguimiento.php",
    type: 'POST',
    data: {
      numero: num_anio,
      dni: dni
    }
  }).done(function (resp) {
    let data = JSON.parse(resp);
    var cadena = "";
    if (data.length > 0) {
      document.getElementById("buscador").style.display = "block";
      document.getElementById('lbl_titulo').innerHTML = "Seguimiento del Expediente: " + data[0][0] + " - " + data[0][2];
      if (data[0][4] == null) {
        document.getElementById("item_interno").style.display = "none";
      } else {
        document.getElementById("item_interno").innerHTML = '<div class="timeline">  <div class="tl-entry active"><div class="tl-time w-auto"><div class="tl-date">' + Calcular_Fecha(data[0][3]) + '</div><div class="tl-time">' + Calcular_Hora(data[0][3]) + '</div></div><div class="tl-media"><div class="ratio ratio-1x1 bg-info text-white rounded-circle"><i class="fa-solid fa-envelope-open fs-5"></i></div></div><div class="tl-content card  " style="min-width:initial;"><div class="card-body w-450px"><h5 class="fs-5">En:' + data[0][5] + ' </h5><label for="" class="text-dark fw-bolder">Descripcion:</label><p style="text-align:justify;" class="mb-1"></p><label class="text-dark fw-bolder" for="">Estado: <span class="badge bg-info">DERIVADO</span> <i class="fa-sharp fa-solid fa-arrow-right icono_flecha d-none" id="icono_flecha"></i> <span class="fw-normal"></span></label></div></div> </div></div>';

      }
      document.getElementById('txt_numero').value = "";
      let dni_guardado = dni; // Guardar DNI para validación de descarga
      document.getElementById('txt_dni').value = "";
      document.getElementById('txt_año').value = "";
      cadena += '<div class="timeline">';
      //DETALLE
      $.ajax({
        "url": "controller/usuario/controller_traer_seguimiento_detalle.php",
        type: 'POST',
        data: {
          codigo: data[0][0]
        }
      }).done(function (resp) {
        let dataDetalle = JSON.parse(resp);
        if (dataDetalle.length > 0) {
          for (let i = 0; i < dataDetalle.length; i++) {
            let classe = "";
            let area_des = "";
            let area_dett = ""
            let none = "";
            let = icon_ = "";
            let boton_archivo = "";

            if (dataDetalle[i][5] == 'DERIVADO') {
              classe = 'bg-info';
              icon_ = "fa-solid fa-envelope-open";
            } else if (dataDetalle[i][5] == 'FINALIZADO') {
              classe = 'bg-success';
              icon_ = "fa-solid fa-thumbs-up";
              area_dett = dataDetalle[i][7];
            } else if (dataDetalle[i][5] == 'PENDIENTE') {
              classe = 'bg-warning';
              icon_ = "fa-solid fa-envelope"
            } else {
              classe = 'bg-danger';
            }

            // Mostrar botón de descarga si hay archivo visible públicamente
            // dataDetalle[i][8] contiene mov_archivo (filtrado por SP según mov_visible_publico)
            if (dataDetalle[i][8] && dataDetalle[i][8] != '' && dataDetalle[i][8] != null) {
              // Generar URL segura con movimiento_id y código de verificación (DNI)
              let url_segura = 'descargar_archivo.php?mov=' + dataDetalle[i][0] + '&cod=' + dni_guardado;
              boton_archivo = '<div class="mt-3"><a href="' + url_segura + '" target="_blank" class="btn btn-success btn-sm"><i class="fa-solid fa-file-pdf me-2"></i>Ver Documento Adjunto</a></div>';
            }

            if (i + 1 == dataDetalle.length) {
              area_des = "";
              none = "d-none"

            } else {
              area_des = dataDetalle[i + 1][2];
              area_dett = dataDetalle[i + 1][4];
            }

            cadena += '  <div class="tl-entry active">' +
              '<div class="tl-time w-auto">' +
              '<div class="tl-date">' + Calcular_Fecha(dataDetalle[i][3]) + '</div>' +
              '<div class="tl-time">' + Calcular_Hora(dataDetalle[i][3]) + '</div>' +
              '</div>' +
              '<div class="tl-media">' +
              '<div class="ratio ratio-1x1 ' + classe + ' text-white rounded-circle">' +
              '<i class="' + icon_ + ' fs-5"></i>' +
              '</div>' +
              '</div>' +
              '<div class="tl-content card  "style="min-width:initial;">' +
              '<div class="card-body w-450px">' +
              '<h5 class="fs-5">En: ' + dataDetalle[i][2] + '</h5>' +
              '<label for=""class="text-dark fw-bolder">Descripcion:</label>' +
              '<p style="text-align:justify;" class="mb-1">' + area_dett + '</p>' +
              '<label class="text-dark fw-bolder" for="">Estado: <span class="badge ' + classe + '">' + dataDetalle[i][5] + '</span> <i class="fa-sharp fa-solid fa-arrow-right icono_flecha ' + none + '" id="icono_flecha"></i> <span class="fw-normal">' + area_des + '</span></label>' +
              boton_archivo +
              '</div>' +
              '</div>' +
              ' </div>';


          }
          cadena += '</div>';

          document.getElementById("div_seguimiento").innerHTML = cadena;


        }
      });

    } else {
      document.getElementById("buscador").style.display = "none";
      Swal.fire("Mensaje de Error", "No existe el Expediente", "error");
      document.getElementById('txt_numero').value = "";
      document.getElementById('txt_dni').value = "";

    }
  });
}

function Calcular_Dia(fechahora) {

  let fecha = new Date(fechahora);
  let diasemana = fecha.getDay(fecha);
  var diaSemanaString = '';
  switch (diasemana) {
    case 0:
      diaSemanaString = 'Domingo';
      break;
    case 1:
      diaSemanaString = 'Lunes';
      break;
    case 2:
      diaSemanaString = 'Martes';
      break;
    case 3:
      diaSemanaString = 'Miércoles';
      break;
    case 4:
      diaSemanaString = 'Jueves';
      break;
    case 5:
      diaSemanaString = 'Viernes';
      break;
    case 6:
      diaSemanaString = 'Sábado';
      break;
  }
  return diaSemanaString;
}
function Calcular_Fecha(fechahora) {

  let fecha = new Date(fechahora);
  let fecha2 = fecha.toLocaleDateString();
  let fechaArray = fecha2.split('/');
  let dia = fechaArray[0];
  let mes = fechaArray[1];
  let anio = fechaArray[2];
  if (dia.length < 2) {
    dia = '0' + dia;
  }
  if (mes.length < 2) {
    mes = '0' + mes;
  }
  return dia + '/' + mes + '/' + anio;
}
function Calcular_Hora(fechahora) {
  let fecha = new Date(fechahora);
  let hora = fecha.getHours();
  let periodo = 'AM';
  if (hora >= 12) {
    periodo = 'PM';
  }
  if (hora > 12) {
    hora = hora - 12;
    hora = '0' + hora;
  }
  let minutos = fecha.getMinutes();
  if (minutos < 10) {
    minutos = '0' + minutos;
  }
  return hora + ':' + minutos + ' ' + periodo;
}