function AbrirRegistro() {
  $("#modal_registro").modal({ keyborad: false })
  $("#modal_registro").modal('show');
}

var idioma_espanol = {
  select: {
    rows: "%d fila seleccionada"
  },
  "sProcessing": "Procesando...",
  "sLengthMenu": "Mostrar _MENU_ registros",
  "sZeroRecords": "No se encontraron resultados",
  "sEmptyTable": "Ningún dato disponible en esta tabla",
  "sInfo": "Registros del (_START_ al _END_) total de _TOTAL_ registros",
  "sInfoEmpty": "Registros del (0 al 0) total de 0 registros",
  "sInfoFiltered": "(filtrado de un total de _MAX_ registros)",
  "sInfoPostFix": "",
  "sSearch": "Buscar:",
  "sUrl": "",
  "sInfoThousands": ",",
  "sLoadingRecords": "<b>No se encontraron datos</b>",
  "oPaginate": {
    "sFirst": "Primero",
    "sLast": "Último",
    "sNext": "Siguiente",
    "sPrevious": "Anterior"
  },
  "oAria": {
    "sSortAscending": ": Activar para ordenar la columna de manera ascendente",
    "sSortDescending": ": Activar para ordenar la columna de manera descendente"
  }
}
var tbl_horario;
function Listar_horarios() {
  tbl_horario = $("#tabla_horario").DataTable({
    "ordering": false,
    "bLengthChange": true,
    "searching": { "regex": false },
    "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
    "pageLength": 10,
    "destroy": true,
    "async": false,
    "processing": true,
    "ajax": {
      "method": "POST",
      "url": "../controller/horario/controller_listar_horario.php"
    },
    "columns": [
      { "defaultContent": "" },
      { "data": "hor_ini" },
      { "data": "hor_fin" },
      {
        "data": "hor_lu",
        "render": function (data, type, row) {
          return '<div class="d-flex flex-wrap justify-content-around">' +
            '<div class="my-1  badge bg-' + (row.hor_lu == 1 ? "secondary" : "warning") + '">LUNES</div>' +
            '<div class="my-1  badge bg-' + (row.hor_ma == 1 ? "secondary" : "warning") + '">MARTES</div>' +
            '<div class="my-1  badge bg-' + (row.hor_mi == 1 ? "secondary" : "warning") + '">MIERCOLES</div>' +
            '<div class="my-1  badge bg-' + (row.hor_ju == 1 ? "secondary" : "warning") + '">JUEVES</div>' +
            '<div class="my-1  badge bg-' + (row.hor_vi == 1 ? "secondary" : "warning") + '">VIERNES</div>' +
            '<div class="my-1  badge bg-' + (row.hor_sa == 1 ? "secondary" : "warning") + '">SABADO</div>' +
            '<div class="my-1  badge bg-' + (row.hor_do == 1 ? "secondary" : "warning") + '">DOMINGO</div>' +
            '</div>';
        }
      },
      {
        "data": "hor_estado", render: function (data, type, row) {
          if (data == 'ACTIVO') {
            return '<span class="badge bg-success">ACTIVO</span>';
          } else {
            return '<span class="badge bg-danger">INACTIVO</span>';
          }
        }
      },
      {
        "data": "hor_estado", render: function (data, type, row) {
          if (data == 'ACTIVO') {
            return "<button class='editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button>&nbsp<button class='desactivar btn btn-transparent text-dark btn-sm'><i class='fa-solid fa-circle-check fs-4'></i></button>&nbsp<button class='eliminar btn btn-danger btn-sm' disabled><i class='fa-solid fa-trash'></i></button>";
          } else {
            return "<button class='editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button>&nbsp<button class='activar btn btn-transparent text-dark btn-sm'><i class='fa-regular fa-circle fs-4'></i></button>&nbsp<button class='eliminar btn btn-danger btn-sm' ><i class='fa-solid fa-trash'></i></button>";
          }
        }
      },

    ],
    "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
      $($(nRow).find("td")[0]).css('text-align', 'center');
      $($(nRow).find("td")[1]).css('text-align', 'center');
      $($(nRow).find("td")[2]).css('text-align', 'center');
      $($(nRow).find("td")[3]).css('text-align', 'center');
    },
    "language": idioma_espanol,
    select: true
  });
  tbl_horario.on('draw.td', function () {
    var PageInfo = $("#tabla_horario").DataTable().page.info();
    tbl_horario.column(0, { page: 'current' }).nodes().each(function (cell, i) {
      cell.innerHTML = i + 1 + PageInfo.start;
    });
  });
}

$('#tabla_horario').on('click', '.desactivar', function () {
  let data = tbl_horario.row($(this).parents('tr')).data();
  if (tbl_horario.row(this).child.isShown()) {
    data = tbl_horario.row(this).data();
  }
  Swal.fire({
    title: '¿Desea desactivar el Horario?',
    text: "Una vez desactivado el Horario, el sistema trabajara sin horario!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'SI'
  }).then((result) => {
    if (result.isConfirmed) {
      Modificar_Estatus_Horario(parseInt(data.horario_id), 'INACTIVO')
    }
  })

});
$('#tabla_horario').on('click', '.activar', function () {
  let data = tbl_horario.row($(this).parents('tr')).data();
  if (tbl_horario.row(this).child.isShown()) {
    data = tbl_horario.row(this).data();
  }
  Swal.fire({
    title: '¿Desea activar el Horario?',
    text: "Una vez activado el Horario, el sistema trabajará con el horario activado!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'SI'
  }).then((result) => {
    if (result.isConfirmed) {
      Modificar_Estatus_Horario(parseInt(data.horario_id), 'ACTIVO');
    }
  })

});

$('#tabla_horario').on('click', '.eliminar', function () {
  let data = tbl_horario.row($(this).parents('tr')).data();
  if (tbl_horario.row(this).child.isShown()) {
    data = tbl_horario.row(this).data();
  }
  Swal.fire({
    title: '¿Desea Eliminar el Horario?',
    icon: 'warning',
    showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Si',
    cancelButtonText: 'Cancelar'
  }).then((result) => {
    if (result.isConfirmed) {
        eliminar_horario(data.horario_id);      
    }
  })

});

function eliminar_horario(id) {
  $.ajax({
      "url": "../controller/horario/controller_eliminar_horario.php",
      type: 'POST',
      data: {
          id: id,

      }
  }).done(function (resp) {
      if (resp == 1) {
          Swal.fire("Mensaje de Confirmacion", "Horario Eliminado con Exito", "success").then((value) => {
            tbl_horario.ajax.reload();
          });


      } else if (resp == 2) {
          Swal.fire("Mensaje de Advertencia", "No se puede Eliminar, el Horario se Encuentra Activo", "warning");
      } else {
          Swal.fire("Mensaje de Error", "No se completo la operacion , comuniquese con Soporte", "error");
      }

  });

}

function Modificar_Estatus_Horario(id, estatus) {
  let esta = estatus;
  if (esta == 'INACTIVO') {
    esta = 'DESACTIVADO'
  } else {
    esta = 'ACTIVADO';
  }
  $.ajax({
    "url": "../controller/horario/controller_modificar_horario_estatus.php",
    type: 'POST',
    data: {
      id: id,
      estatus: estatus
    }
  }).done(function (resp) {
    if(resp>0){
      if(resp==1){
          Swal.fire("Mensaje de Confirmacion","Horario "+esta+" con Exito","success").then((value)=>{
              tbl_horario.ajax.reload();
              

          })

      }else{
          Swal.fire("Mensaje de Advertencia","Ya existe un horario activo, desactivelo por favor!","warning");
      }

  }else{
      return Swal.fire("Mensaje de Error","No se completo la modificacion","error");
  }
  })
}
function Registrar_Horario() {
  let horarioNuevo = {
    ini: $('#txt_horainicio').val(),
    fin: $('#txt_horafin').val(),
    bLu: $('#Lunes').is(":checked") ? 1 : 0,
    bMa: $('#Martes').is(":checked") ? 1 : 0,
    bMi: $('#Miercoles').is(":checked") ? 1 : 0,
    bJu: $('#Jueves').is(":checked") ? 1 : 0,
    bVi: $('#Viernes').is(":checked") ? 1 : 0,
    bSa: $('#Sabado').is(":checked") ? 1 : 0,
    bDo: $('#Domingo').is(":checked") ? 1 : 0
  }

  if (horarioNuevo.ini == '') {
    return Swal.fire("Mensaje de Advertencia", "Seleccione un horario de Inicio", "warning");
  }
  if (horarioNuevo.fin == '') {
    return Swal.fire("Mensaje de Advertencia", "Seleccione un horario de Termino", "warning");
  }
  if (horarioNuevo.bLu == 0 && horarioNuevo.bMa == 0 && horarioNuevo.bMi == 0 && horarioNuevo.bJu == 0 && horarioNuevo.bVi == 0 && horarioNuevo.bSa == 0 && horarioNuevo.bDo == 0) {
    return Swal.fire("Mensaje de Advertencia", "Seleccione al menos un dia de la semana", "warning");

  }
  $.ajax({
    url: '../controller/horario/controller_listar_horario.php',
    type: 'POST',
  }).done(function (resp) {
    var data = JSON.parse(resp);
    let horarioExistente = false;
    if (!data.data) {
      registrar_horario_verificado(horarioNuevo);
    } else {
      for (let i = 0; i < data.data.length; i++) {
        let horario = data.data[i];
        if (horario.hor_ini == horarioNuevo.ini + ':00' &&
          horario.hor_fin == horarioNuevo.fin + ':00' &&
          horario.hor_lu == horarioNuevo.bLu &&
          horario.hor_ma == horarioNuevo.bMa &&
          horario.hor_mi == horarioNuevo.bMi &&
          horario.hor_ju == horarioNuevo.bJu &&
          horario.hor_vi == horarioNuevo.bVi &&
          horario.hor_sa == horarioNuevo.bSa &&
          horario.hor_do == horarioNuevo.bDo) {

          horarioExistente = true;
          break;
        }
      }

      if (horarioExistente) {
        return Swal.fire("Mensaje de Advertencia", 'El Horario Ingresado ya se encuentra registrado!', "warning");

      } else {
        registrar_horario_verificado(horarioNuevo);
      }
    }


  });
}

function registrar_horario_verificado(horarioNuevo) {
  $.ajax({
    url: '../controller/horario/controller_registrar_horario.php',
    type: 'POST',
    data: horarioNuevo
  }).done(function (resp) {
    var data = JSON.parse(resp);
    if (data == 1) {
      Swal.fire("Mensaje de confirmacion", 'Horario registrado correctamente', "success").then((value)=>{
        tbl_horario.ajax.reload();
      });
      Limpiar_modal();
      $('#modal_registro').modal('hide');

    } else {
      Swal.fire("Mensaje de error", 'No se completo la operación, comuniquese con Soporte', "error");
    }

  });
}
$('#tabla_horario').on('click', '.editar', function () {
  var data = tbl_horario.row($(this).parents('tr')).data();//Detecta a que fila hago click y me captura los datos en la variable data.
  if (tbl_horario.row(this).child.isShown()) {//Cuando esta en tamaño responsivo
    var data = tbl_horario.row(this).data();
  }
  $('#modal_editar').modal('show');
  $('#txt_idhorario_e').val(data.horario_id);
  $('#txt_horainicio_e').val(data.hor_ini);
  $('#txt_horafin_e').val(data.hor_fin);
  $('#txt_estado_h').val(data.hor_estado);
  $("#Lunes_e").prop('checked', data.hor_lu === "1" ? true : false);
  $("#Martes_e").prop('checked', data.hor_ma == "1" ? true : false);
  $("#Miercoles_e").prop('checked', data.hor_mi == "1" ? true : false);
  $("#Jueves_e").prop('checked', data.hor_ju == "1" ? true : false);
  $("#Viernes_e").prop('checked', data.hor_vi == "1" ? true : false);
  $("#Sabado_e").prop('checked', data.hor_sa == "1" ? true : false);
  $("#Domingo_e").prop('checked', data.hor_do == "1" ? true : false);

});
function Modificar_Horario() {
  let horarioNuevo_mo = {
    idh: $('#txt_idhorario_e').val(),
    ini: $('#txt_horainicio_e').val(),
    fin: $('#txt_horafin_e').val(),
    bLu: $('#Lunes_e').is(":checked") ? 1 : 0,
    bMa: $('#Martes_e').is(":checked") ? 1 : 0,
    bMi: $('#Miercoles_e').is(":checked") ? 1 : 0,
    bJu: $('#Jueves_e').is(":checked") ? 1 : 0,
    bVi: $('#Viernes_e').is(":checked") ? 1 : 0,
    bSa: $('#Sabado_e').is(":checked") ? 1 : 0,
    bDo: $('#Domingo_e').is(":checked") ? 1 : 0
  }
  if (horarioNuevo_mo.bLu == 0 && horarioNuevo_mo.bMa == 0 && horarioNuevo_mo.bMi == 0 && horarioNuevo_mo.bJu == 0 && horarioNuevo_mo.bVi == 0 && horarioNuevo_mo.bSa == 0 && horarioNuevo_mo.bDo == 0) {
    return Swal.fire("Mensaje de Advertencia", "Seleccione al menos un dia de la semana", "warning");

  }
  $.ajax({
    url: '../controller/horario/controller_listar_horario.php',
    type: 'POST',
  }).done(function (resp) {
    var data = JSON.parse(resp);
    let horarioExistente = false;
      for (let i = 0; i < data.data.length; i++) {
        let horario = data.data[i];
        if (horario.hor_ini == horarioNuevo_mo.ini   &&
          horario.hor_fin == horarioNuevo_mo.fin  &&
          horario.hor_lu == horarioNuevo_mo.bLu &&
          horario.hor_ma == horarioNuevo_mo.bMa &&
          horario.hor_mi == horarioNuevo_mo.bMi &&
          horario.hor_ju == horarioNuevo_mo.bJu &&
          horario.hor_vi == horarioNuevo_mo.bVi &&
          horario.hor_sa == horarioNuevo_mo.bSa &&
          horario.hor_do == horarioNuevo_mo.bDo) {
      
          horarioExistente = true;
          break;
        }
      }

      if (horarioExistente) {
        return Swal.fire("Mensaje de Advertencia", 'El Horario Ingresado ya se encuentra registrado!', "warning");

      } else {
        $.ajax({
          url: '../controller/horario/controller_modificar_horario.php',
          type: 'POST',
          data: horarioNuevo_mo
        }).done(function (resp) {
          if (resp > 0) {
            if (resp == 1) {
              Swal.fire("Mensaje de Confirmacion", "Horario Actualizado", "success").then((value) => {
                tbl_horario.ajax.reload();
                $("#modal_editar").modal('hide');

              })

            } else {
              Swal.fire("Mensaje de Advertencia", "El Horario Ingresado ya se encuentra registrado!", "warning");
            }

          } else {
            return Swal.fire("Mensaje de Error", "No se completo la operación, comuniquese con Soporte", "error");
          }

        });
      }
    


  });


}
function Limpiar_modal() {
  $('#txt_horainicio').val('');
  $('#txt_horafin').val('');
  $("#Lunes").prop("checked", false);
  $("#Martes").prop("checked", false);
  $("#Miercoles").prop("checked", false);
  $("#Jueves").prop("checked", false);
  $("#Viernes").prop("checked", false);
  $("#Sabado").prop("checked", false);
  $("#Domingo").prop("checked", false);
}
