
function AbrirRegistro() {
    $("#modal_registro").modal({ keyborad: false })
    $("#modal_registro").modal('show');
}
function AbrirRegistro2() {
    $("#modal_registro2").modal({ keyborad: false })
    $("#modal_registro2").modal('show');
}
function verificar_tipo_usuario() {

    let rol = document.getElementById('txtprincipalrol').value;
    if (rol == 'Administrador') {
        listar_comunicado();
    } else {
        listar_comunicado_area();
    }
}

var tbl_comunicado;
function listar_comunicado() {
    tbl_comunicado = $("#tabla_comunicado").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/comunicado/controller_listar_comunicado.php",
            type: 'POST'
        },
        "columns": [
            { "defaultContent": "" },
            { "data": "comu_detalle" },
            { "data": "comu_fecharegistro" },
            { "data": "AREAORIGEN" },
            {
                "data": "AREADESTINO",render: function (data, type, row) {
                    if (data == null) {
                        return 'EXTERIOR';
                    } else {
                        return data;
                    }
                }
            },
            {
                "data": "comu_estado", render: function (data, type, row) {
                    if (data == 'ACTIVO') {
                        return '<span class="badge bg-success">ACTIVO</span>';
                    } else {
                        return '<span class="badge bg-danger">INACTIVO</span>';
                    }
                }
            },
            { "defaultContent": "<button class=' editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button> <button class=' eliminar btn btn-danger btn-sm'><i class='fa-solid fa-trash'></i></button>" },
        ],

        "language": idioma_espanol,
        select: true
    });
    tbl_comunicado.on('draw.td', function () {
        var PageInfo = $("#tabla_comunicado").DataTable().page.info();
        tbl_comunicado.column(0, { page: 'current' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

}
function listar_comunicado_area() {
    let idarea = document.getElementById('txtprincipalareaid').value;
    tbl_comunicado = $("#tabla_comunicado").DataTable({
        "ordering": false,
        "bLengthChange": true,
        "searching": { "regex": false },
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "pageLength": 10,
        "destroy": true,
        "async": false,
        "processing": true,
        "ajax": {
            "url": "../controller/comunicado/controller_listar_comunicado_area.php",
            type: 'POST',
            data: {
                idarea: idarea
            }
        },
        "columns": [
            { "defaultContent": "" },
            { "data": "comu_detalle" },
            { "data": "comu_fecharegistro" },
            { "data": "AREAORIGEN" },
            { "data": "AREADESTINO" },
            {
                "data": "comu_estado", render: function (data, type, row) {
                    if (data == 'ACTIVO') {
                        return '<span class="badge bg-success">ACTIVO</span>';
                    } else {
                        return '<span class="badge bg-danger">INACTIVO</span>';
                    }
                }
            },
            { "defaultContent": "<button class=' editar btn btn-secondary btn-sm'><i class='fas fa-pencil-alt'></i></button> <button class=' eliminar btn btn-danger btn-sm'><i class='far fa-trash-alt'></i></button>" },
        ],

        "language": idioma_espanol,
        select: true
    });
    tbl_comunicado.on('draw.td', function () {
        var PageInfo = $("#tabla_comunicado").DataTable().page.info();
        tbl_comunicado.column(0, { page: 'current' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1 + PageInfo.start;
        });
    });

}
$('#tabla_comunicado').on('click', '.editar', function () {
    let data = tbl_comunicado.row($(this).parents('tr')).data();
    if (tbl_comunicado.row(this).child.isShown()) {
        data = tbl_comunicado.row(this).data();
    }
    $("#modal_editar").modal('show');
    document.getElementById('txt_idcomunicado').value = data.comunicado_id;
    document.getElementById('txt_comunicado_e').value = data.comu_detalle;
    document.getElementById('select_estatus').value = data.comu_estado;
    if(data.comu_areadestino_id==null){
        document.getElementById('not_null_area').style.display ='none';
        
    }else{
        document.getElementById('not_null_area').style.display ='block';
         $('#select_area_d_editar').select2().val(data.comu_areadestino_id).trigger('change.select2');
    }
   

})
$('#tabla_comunicado').on('click', '.eliminar', function () {
    let data = tbl_comunicado.row($(this).parents('tr')).data();
    if (tbl_comunicado.row(this).child.isShown()) {
        data = tbl_comunicado.row(this).data();
    }
    Swal.fire({
        title: '¿Desea Eliminar el Comunicado?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si',
        cancelButtonText: 'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
          eliminar_registro(data.comunicado_id);
        }
      })
    

})
function Registrar_Comunicado_Exterior() {
    let idarea = document.getElementById('txtprincipalareaid').value;
    let com = document.getElementById('txt_comunicado_exterior').value;
    let ard = document.getElementById('select_area_des').value;

    if (com.length == 0) {
        return Swal.fire("Mensaje de Advertencia", "Tiene Campos Vacios", "warning");
    }
    $.ajax({
        "url": "../controller/comunicado/controller_registro_comunicado.php",
        type: 'POST',
        data: {
            com: com,
            ard: ard,
            idarea: idarea
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Nuevo Comunicado Registrado", "success").then((value) => {
                    document.getElementById('txt_comunicado_exterior').value = "";
                    tbl_comunicado.ajax.reload();
                    $("#modal_registro2").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El Comunicado Ingresado ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo el registro, comuniquese con soporte", "error");
        }
    })

}

function Registrar_Comunicado() {
    let idarea = document.getElementById('txtprincipalareaid').value;
    let com = document.getElementById('txt_comunicado').value;
    let ard = document.getElementById('select_area_des').value;
    if (com.length == 0 || ard.length == 0) {
        return Swal.fire("Mensaje de Advertencia", "Tiene Campos Vacios", "warning");
    }
    $.ajax({
        "url": "../controller/comunicado/controller_registro_comunicado.php",
        type: 'POST',
        data: {
            com: com,
            ard: ard,
            idarea: idarea
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Nuevo Comunicado Registrado", "success").then((value) => {
                    document.getElementById('txt_comunicado').value = "";
                    document.getElementById('select_area_des').value = "";
                    tbl_comunicado.ajax.reload();
                    $("#modal_registro").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El Comunicado Ingresado ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo el registro, comuniquese con soporte", "error");
        }
    })

}

function Modificar_Comunicado() {
    let idcom = document.getElementById('txt_idcomunicado').value;
    let ard = document.getElementById('select_area_d_editar').value;
    let com = document.getElementById('txt_comunicado_e').value;
    let esta = document.getElementById('select_estatus').value;



    if (idcom.length == 0 ||  com.length == 0 || esta.length == 0) {
        return Swal.fire("Mensaje de Advertencia", "Tiene Campos Vacios", "warning");
    }
    $.ajax({
        "url": "../controller/comunicado/controller_modificar_comunicado.php",
        type: 'POST',
        data: {
            idcom: idcom,
            ard: ard,
            com: com,
            esta: esta
        }
    }).done(function (resp) {
        if (resp > 0) {
            if (resp == 1) {
                Swal.fire("Mensaje de Confirmacion", "Datos Actualizados", "success").then((value) => {
                    tbl_comunicado.ajax.reload();
                    document.getElementById('select_area_d_editar').value="";
                    $("#modal_editar").modal('hide');

                })

            } else {
                Swal.fire("Mensaje de Advertencia", "El Comunicado Ingresado ya se encuentra en la base de datos", "warning");
            }

        } else {
            return Swal.fire("Mensaje de Error", "No se completo la modificacion, comuniquese con soporte", "error");
        }
    })

}
function eliminar_registro(id) {
    $.ajax({
        "url": "../controller/comunicado/controller_eliminar_comunicado.php",
        type: 'POST',
        data: {
            id: id,

        }
    }).done(function (resp) {
        if (resp == 1) {
            Swal.fire("Mensaje de Confirmacion", "Comunicado Eliminado con Exito", "success").then((value) => {
                tbl_comunicado.ajax.reload();
            });


        } else if (resp == 2) {
            Swal.fire("Mensaje de Advertencia", "No se puede Eliminar, el Comunicado se Encuentra Activo", "warning");
        } else {
            Swal.fire("Mensaje de Error", "No se completo la operacion , comuniquese con Soporte ", "error");
        }

    });

}
function Cargar_Select_Area() {
    $.ajax({
        "url": "../controller/usuario/controller_cargar_select_area.php",
        type: 'POST',
    }).done(function (resp) {
        let data = JSON.parse(resp);
        if (data.length > 0) {
            let cadena = "<option value=''>No hay empleados disponibles</option>";
            for (let i = 0; i < data.length; i++) {
                cadena += " <option value='" + data[i][0] + "'>" + data[i][1] + "</option>";
            }
            document.getElementById('select_area_des').innerHTML = cadena;
            document.getElementById('select_area_d_editar').innerHTML = cadena;
        } else {
            cadena += " <option value=''>No hay empleados disponibles</option>";
            document.getElementById('select_area_des').innerHTML = cadena;
            document.getElementById('select_area_d_editar').innerHTML = cadena;

        }
    })
}