<?php
    require_once "model_conexion.php";
    class Modelo_Usuario extends ConexionDB{
        public function Verificar_Usuario($usu,$con){
            $conexion = ConexionDB::conexionPDO();
            $sql = "CALL SP_VERIFICAR_USUARIO(?)";
            $arreglo = array();
            $query = $conexion->prepare($sql);
            $query->bindParam(1,$usu);
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                if(password_verify($con,$resp['usu_contra'])){
                    $arreglo[] = $resp;
                }     
            }
            return $arreglo;
            ConexionDB::cerrar_conexion();
        }

        public function Registrar_Usuario($usu,$con,$ide,$ida,$rol){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_REGISTRAR_USUARIO(?,?,?,?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$usu); 
            $query->bindParam(2,$con); 
            $query->bindParam(3,$ide); 
            $query->bindParam(4,$ida); 
            $query->bindParam(5,$rol); 
            $query->execute();
            if($row = $query->fetchColumn()){
                return $row;
            }
            conexionDB::cerrar_conexion();
        }

        public function Modificar_Usuario($id,$ide,$ida,$rol){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_MODIFICAR_USUARIO(?,?,?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->bindParam(2,$ide); 
            $query->bindParam(3,$ida); 
            $query->bindParam(4,$rol); 
            $result = $query->execute();
            if($result){
                return 1;
            }else{
                return 0;
            }

            conexionDB::cerrar_conexion();
        }

        public function Modificar_Contraseña($id,$con){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_MODIFICAR_CONTRASEÑA(?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->bindParam(2,$con); 
            $result = $query->execute();
            if($result){
                return 1;
            }else{
                return 0;
            }

            conexionDB::cerrar_conexion();
        }

        public function Modificar_Usuario_Estatus($id,$estatus){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_MODIFICAR_USUARIO_ESTATUS(?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->bindParam(2,$estatus); 
            $result = $query->execute();
            if($result){
                return 1;
            }else{
                return 0;
            }

            conexionDB::cerrar_conexion();
        }

        public function Listar_Usuario(){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_USUARIO()";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        //para llevar los campos al tramite interno
        public function Buscar_Usuario($buscar){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_BUSCAR_USUARIO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$buscar); 
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Traer_Usuario_Actual($idusu_p){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_BUSCAR_USUARIO_ACTUAL_PERFIL(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusu_p); 
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Modificar_Usuario_Actual($id,$usu_nuevo,$contra_n,$ruta){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_MODIFICAR_USUARIO_ACTUAL(?,?,?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->bindParam(2,$usu_nuevo); 
            $query->bindParam(3,$contra_n);  
            $query->bindParam(4,$ruta); 
            $query->execute();
            if($row = $query->fetchColumn()){
                return $row;
            }

            conexionDB::cerrar_conexion();
        }

        public function Modificar_Solo_Usuario_Actual($id,$usu_nuevo,$ruta){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_MODIFICAR_SOLO_USUARIO_ACTUAL(?,?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->bindParam(2,$usu_nuevo); 
            $query->bindParam(3,$ruta); 
            $query->execute();
            if($row = $query->fetchColumn()){
                return $row;
            }

            conexionDB::cerrar_conexion();
        }



        public function Cargar_Select_Empleado(){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_CARGAR_SELECT_EMPLEADO()";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Cargar_Select_Area(){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_CARGAR_SELECT_AREA()";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }
        public function Cargar_Select_Datos_Seguimiento($numero,$dni){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_CARGAR_SEGUIMIENTO_TRAMITE(?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$numero); 
            $query->bindParam(2,$dni); 
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }
        public function Cargar_Datos_Detalle_Seguimiento($codigo){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$codigo);

            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        // Nuevo método para seguimiento INTERNO (usuarios logueados)
        // Muestra TODOS los archivos sin filtrar por mov_visible_publico
        public function Cargar_Datos_Detalle_Seguimiento_Interno($codigo){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE_INTERNO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$codigo);

            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Registrar_Tema($idusu,$bootstrapActual,$niftyActual){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_REGISTRAR_TEMA(?,?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusu); 
            $query->bindParam(2,$bootstrapActual); 
            $query->bindParam(3,$niftyActual); 
            $query->execute();
            if($row = $query->fetchColumn()){
                return $row;
            }
            conexionDB::cerrar_conexion();
        }

        public function Traer_Tema_Usuario($idusu){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_TRAER_TEMA_USUARIO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusu); 
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }
        

    }
?>