<?php
    require_once "model_conexion.php";
    class Modelo_TramiteArea extends ConexionDB{

        public function Registrar_Tramite($iddo,$orig,$dest,$desc,$idusu,$ruta,$selecttip,$visible_publico){
            try {
                $c = conexionDB::conexionPDO();
                $sql = "CALL SP_REGISTRAR_TRAMITE_DERIVAR(?,?,?,?,?,?,?,?)";
                $arreglo = array();
                $query  = $c->prepare($sql);

                // Bind con tipos específicos de PDO
                $query->bindParam(1, $iddo, PDO::PARAM_STR); // documento_id es VARCHAR
                $query->bindParam(2, $orig, PDO::PARAM_INT);

                // Si dest es NULL, usar PDO::PARAM_NULL
                if ($dest === null) {
                    $query->bindParam(3, $dest, PDO::PARAM_NULL);
                } else {
                    $query->bindParam(3, $dest, PDO::PARAM_INT);
                }

                $query->bindParam(4, $desc, PDO::PARAM_STR);
                $query->bindParam(5, $idusu, PDO::PARAM_INT);
                $query->bindParam(6, $ruta, PDO::PARAM_STR);
                $query->bindParam(7, $selecttip, PDO::PARAM_STR);
                $query->bindParam(8, $visible_publico, PDO::PARAM_INT);

                // Log detallado de parámetros antes de ejecutar
                error_log("SP_REGISTRAR_TRAMITE_DERIVAR - Parámetros: iddo=$iddo (" . gettype($iddo) . "), orig=$orig (" . gettype($orig) . "), dest=" . ($dest === null ? 'NULL' : $dest) . " (" . gettype($dest) . "), desc=$desc, idusu=$idusu, ruta=$ruta, selecttip=$selecttip, visible_publico=$visible_publico");

                $result = $query->execute();

                if($result){
                    error_log("SP_REGISTRAR_TRAMITE_DERIVAR ejecutado exitosamente");
                    return 1;
                }else{
                    $errorInfo = $query->errorInfo();
                    error_log("Error en SP_REGISTRAR_TRAMITE_DERIVAR - SQLSTATE: {$errorInfo[0]}, Error Code: {$errorInfo[1]}, Message: {$errorInfo[2]}");
                    return 0;
                }
            } catch (PDOException $e) {
                error_log("Error PDO en Registrar_Tramite - Código: " . $e->getCode() . ", Mensaje: " . $e->getMessage());
                return 0;
            }

            conexionDB::cerrar_conexion();
        }

        public function Modificar_Usuario($id,$ide,$ida,$rol){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_MODIFICAR_USUARIO(?,?,?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->bindParam(2,$ide); 
            $query->bindParam(3,$ida); 
            $query->bindParam(4,$rol); 
            $result = $query->execute();
            if($result){
                return 1;
            }else{
                return 0;
            }

            conexionDB::cerrar_conexion();
        }

        public function Listar_Tramite($idusuario,$tipo_re){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TRAMITE_AREA(?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusuario); 
            $query->bindParam(2,$tipo_re); 
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Listar_Tramite_Finalizado($idusuario){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TRAMITE_AREA_FINALIZADO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusuario);
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Listar_Tramite_Derivado($idusuario){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TRAMITE_AREA_DERIVADO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusuario);
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Listar_Tramite_Enviado($idusuario){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TRAMITE_AREA_ENVIADO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusuario); 
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Listar_Tramite_Seguimiento($id){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TRAMITE_SEGUIMIENTO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id); 
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        public function Cargar_Select_Tipo(){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_CARGAR_SELECT_TIPO()";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->execute();
            $resultado = $query->fetchAll();
            foreach($resultado as $resp){
                $arreglo[]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }
        public function Listar_Tupa_Area($idtupaver){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TUPA_AREA(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idtupaver); 
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }


        public function Agregar_Carrito($area_grupo,$id_doc){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_AGREGAR_CARRITO(?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$area_grupo); 
            $query->bindParam(2,$id_doc); 
            $query->execute();
            if($row = $query->fetchColumn()){
                return $row;
            }
            conexionDB::cerrar_conexion();
        }

        public function Quitar_Carrito($id_doc){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_QUITAR_CARRITO(?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$id_doc); 
            $query->execute();
            if($row = $query->fetchColumn()){
                return $row;
            }
            conexionDB::cerrar_conexion();
        }
        public function Listar_Tramite_Carrito_Area($idusuario,$idareades){
            $c = conexionDB::conexionPDO();
            $sql = "CALL SP_LISTAR_TRAMITE_AREA_CARRITO(?,?)";
            $arreglo = array();
            $query  = $c->prepare($sql);
            $query->bindParam(1,$idusuario); 
            $query->bindParam(2,$idareades); 
            $query->execute();
            $resultado = $query->fetchAll(PDO::FETCH_ASSOC);
            foreach($resultado as $resp){
                $arreglo["data"][]=$resp;
            }
            return $arreglo;
            conexionDB::cerrar_conexion();
        }

        
        

    }
?>