-- ========================================
-- LIMPIEZA DE DATOS ANTIGUOS
-- ========================================
-- Este script corrige los movimientos que tienen mov_estatus vacío o NULL
-- y establece estados correctos según su posición en la cadena de movimientos

-- Ver el estado actual ANTES de la limpieza
SELECT 'ANTES DE LA LIMPIEZA:' AS info;
SELECT
    movimiento_id,
    documento_id,
    area_origen_id,
    area_destino_id,
    mov_estatus,
    mov_fecharegistro,
    CASE
        WHEN movimiento_id = (
            SELECT MAX(m2.movimiento_id)
            FROM movimiento m2
            WHERE m2.documento_id = movimiento.documento_id
        ) THEN 'ÚLTIMO'
        ELSE 'ANTERIOR'
    END AS posicion
FROM movimiento
WHERE mov_estatus = '' OR mov_estatus IS NULL
ORDER BY documento_id, movimiento_id;

-- ========================================
-- CORRECCIÓN 1: Movimientos con estado vacío que NO son el último
-- ========================================
-- Estos deben ser 'DERIVADO' porque ya fueron procesados

UPDATE movimiento
SET mov_estatus = 'DERIVADO'
WHERE (mov_estatus = '' OR mov_estatus IS NULL)
AND area_destino_id IS NOT NULL  -- Tiene área destino (fue derivado)
AND movimiento_id NOT IN (
    -- NO actualizar los que son el último movimiento de su documento
    SELECT * FROM (
        SELECT MAX(m2.movimiento_id)
        FROM movimiento m2
        GROUP BY m2.documento_id
    ) AS ultimos
);

SELECT 'Movimientos antiguos actualizados a DERIVADO' AS Resultado;

-- ========================================
-- CORRECCIÓN 2: Movimientos con estado vacío que SÍ son el último
-- ========================================
-- Estos deben ser 'PENDIENTE' si tienen área destino
-- o dejarse como están si no tienen (movimiento inicial)

UPDATE movimiento m
SET mov_estatus = 'PENDIENTE'
WHERE (m.mov_estatus = '' OR m.mov_estatus IS NULL)
AND m.area_destino_id IS NOT NULL  -- Tiene área destino
AND m.movimiento_id = (
    -- Es el último movimiento de su documento
    SELECT MAX(m2.movimiento_id)
    FROM movimiento m2
    WHERE m2.documento_id = m.documento_id
);

SELECT 'Últimos movimientos actualizados a PENDIENTE' AS Resultado;

-- ========================================
-- CORRECCIÓN 3: Movimientos iniciales (sin área_origen o área_destino NULL)
-- ========================================
-- Estos son registros iniciales del documento, dejarlos sin estado o marcar como 'REGISTRADO'

-- Ver el estado DESPUÉS de la limpieza
SELECT 'DESPUÉS DE LA LIMPIEZA:' AS info;
SELECT
    movimiento_id,
    documento_id,
    area_origen_id,
    area_destino_id,
    mov_estatus,
    mov_fecharegistro,
    CASE
        WHEN movimiento_id = (
            SELECT MAX(m2.movimiento_id)
            FROM movimiento m2
            WHERE m2.documento_id = movimiento.documento_id
        ) THEN 'ÚLTIMO'
        ELSE 'ANTERIOR'
    END AS posicion
FROM movimiento
ORDER BY documento_id, movimiento_id;

-- ========================================
-- VERIFICACIÓN FINAL
-- ========================================
SELECT 'RESUMEN DE ESTADOS:' AS info;
SELECT
    mov_estatus,
    COUNT(*) AS cantidad,
    GROUP_CONCAT(DISTINCT documento_id SEPARATOR ', ') AS documentos
FROM movimiento
GROUP BY mov_estatus;

SELECT '✅ LIMPIEZA COMPLETADA' AS Resultado;
SELECT 'Ahora puedes probar el flujo: Derivar un trámite y verificar que desaparece de Recibidos' AS Instruccion;
