<?php
    session_start();
    if(isset($_SESSION['S_ID'])){
        header('Location: view/index.php');
    }
?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta name="generator" content="Hugo 0.87.0" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, height=device-height, initial-scale=1">
    <meta name="description"
        content="Nifty is a responsive admin dashboard template based on Bootstrap 5 framework. There are a lot of useful components.">
    <title>Login | Sistema de Tramite Documentario</title>
    <link rel="shortcut icon" href="view/assets/img/default.png" id="icon_pestaña" />
    <!-- STYLESHEETS -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~--- -->

    <!-- Fonts [ OPTIONAL ] -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;700&family=Ubuntu:wght@400;500;700&display=swap"
        rel="stylesheet">

    <!-- Bootstrap CSS [ REQUIRED ] -->
    <link rel="stylesheet" href="./view/assets/css/bootstrap.min.css">

    <!-- Nifty CSS [ REQUIRED ] -->
    <link rel="stylesheet" href="./view/assets/css/nifty.min.css">

    <!-- Nifty Demo Icons [ OPTIONAL ] -->
    <link rel="stylesheet" href="./view/assets/css/demo-purpose/demo-icons.min.css">

    <!-- Demo purpose CSS [ DEMO ] -->
    <link rel="stylesheet" href="./view/assets/css/demo-purpose/demo-settings.min.css">

    <link rel="stylesheet" href="./public/css/estilos.css">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css">

    <!-- Estilos mejorados para la tarjeta de login -->
    <style>
        .content2 {
            border-radius: 20px;
            border: none;
            overflow: hidden;
            max-width: 380px;
            margin: 0 auto;
        }

        .login_letter {
            font-weight: 600;
        }

        .titulo_principal {
            font-size: 1.5rem;
            font-weight: 700;
            letter-spacing: 1px;
            margin-bottom: 2rem;
            background: linear-gradient(135deg, #ffffff 0%, #e3f2fd 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .text_login {
            color: #2c5aa0;
            margin-bottom: 8px;
        }

        .form-floating {
            margin-bottom: 28px;
        }

        .form-floating > .form-control {
            border: 2px solid #e0e0e0;
            border-radius: 12px;
            padding: 1rem 0.75rem;
            height: calc(3.5rem + 2px);
            transition: all 0.3s ease;
        }

        .form-floating > .form-control:focus {
            border-color: #2c5aa0;
            box-shadow: 0 0 0 0.25rem rgba(44, 90, 160, 0.15);
        }

        .form-floating > label {
            padding: 1rem 0.75rem;
            color: #6c757d;
            font-size: 14px;
        }

        .btn_login {
            border-radius: 12px;
            padding: 14px;
            font-size: 16px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: 0 4px 15px rgba(44, 90, 160, 0.3);
        }

        .btn_login:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(44, 90, 160, 0.5);
        }

        .btn_login:active {
            transform: translateY(0);
        }

        .form-check-input:checked {
            background-color: #2c5aa0;
            border-color: #2c5aa0;
        }

        .login-link {
            color: #2c5aa0;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .login-link:hover {
            color: #1e3d6b;
            gap: 8px;
        }

        .login-icon {
            font-size: 42px;
            color: #2c5aa0;
            margin-bottom: 15px;
        }
    </style>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.4/css/dataTables.bootstrap5.min.css">

</head>

<body class="jumping">
    <div class="bg"></div>
    <div class="bg bg2"></div>
    <div class="bg bg3"></div>
    <div class="content__boxed w-100 min-vh-100 d-flex flex-column align-items-center justify-content-center">
        <div class="content__wrap col-12 col-sm-7 col-md-5 col-lg-3 col-xl-3">
            <h3 class="text-center titulo_principal">SISTEMA DE TRAMITE DOCUMENTARIO</h3>
            <!-- Login card -->
            <div class="card shadow-lg content2">
                <div class="card-body px-4" style="padding-top: 3rem; padding-bottom: 3rem;">
                    <div class="text-center mb-5">
                        <i class="bi bi-shield-lock login-icon"></i>
                        <h1 class="h3 login_letter text_login">Iniciar Sesión</h1>
                        <p class="text-muted">Ingresa tus credenciales para continuar</p>
                    </div>

                    <form method="post">
                        <div class="form-floating mb-3">
                            <input type="text" class="form-control" id="txt-user" name="usuario-ing"
                                   placeholder="Usuario" autofocus autocomplete="off">
                            <label for="txt-user">
                                <i class="bi bi-person me-2"></i>Usuario
                            </label>
                        </div>

                        <div class="form-floating mb-3">
                            <input type="password" class="form-control" id="txt-pass" name="clave-ing"
                                   placeholder="Contraseña" autocomplete="off">
                            <label for="txt-pass">
                                <i class="bi bi-lock me-2"></i>Contraseña
                            </label>
                        </div>

                        <div class="form-check mb-5">
                            <input class="form-check-input" type="checkbox" id="remember">
                            <label for="remember" class="form-check-label">
                                Recordar credenciales
                            </label>
                        </div>

                        <div class="d-grid mb-4">
                            <button class="btn btn_login btn-lg text-white" type="button"
                                onclick="iniciar_sesion()">
                                <i class="bi bi-box-arrow-in-right me-2"></i>Ingresar
                            </button>
                        </div>

                        <div class="text-center">
                            <a href="nuevo_tramite.php" class="login-link">
                                <i class="bi bi-file-earmark-text"></i>
                                Ir a Trámite Externo
                                <i class="bi bi-arrow-right"></i>
                            </a>
                        </div>
                    </form>
                </div>
            </div>
            <!-- END : Login card -->
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"
        integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
    <!-- JAVASCRIPTS -->
    <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->
    <script src="https://kit.fontawesome.com/bd7b24f1e0.js" crossorigin="anonymous"></script>
    <!-- Popper JS [ OPTIONAL ] -->
    <script src="./view/assets/vendors/popperjs/popper.min.js" defer></script>

    <!-- Bootstrap JS [ OPTIONAL ] -->
    <script src="./view/assets/vendors/bootstrap/bootstrap.min.js" defer></script>
    <!-- Nifty JS [ OPTIONAL ] -->
    <script src="./view/assets/js/nifty.js" defer></script>

    <!-- Nifty Settings [ DEMO ] -->
    <script src="./view/assets/js/demo-purpose-only.js" defer></script>

    <script src="https://cdn.datatables.net/1.11.4/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/1.11.4/js/dataTables.bootstrap5.min.js"></script>

    <script src="./public/js/menu.js?rev=<?php echo time(); ?>"></script>
    <script src="./public/js/entidad.js?rev=<?php echo time(); ?>"></script>

    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
    const rmcheck = document.getElementById('remember');
    const usuarioInput = document.getElementById('txt-user');
    const passInput = document.getElementById('txt-pass');

    if (localStorage.checkbox && localStorage.checkbox != "") {
        rmcheck.setAttribute("checked", "checked");
        usuarioInput.value = localStorage.usuario;
        passInput.value = localStorage.pass;
    } else {
        rmcheck.removeAttribute("checked");
        usuarioInput.value = "";
        passInput.value = "";
    }
    $(document).ready(function() {



        mostrar_datos_emmpresa_exterior_login();

        // Permitir login con tecla Enter
        $('#txt-pass').on('keypress', function(e) {
            if (e.which === 13) { // Tecla Enter
                e.preventDefault();
                iniciar_sesion();
            }
        });

        // También en el campo de usuario
        $('#txt-user').on('keypress', function(e) {
            if (e.which === 13) { // Tecla Enter
                e.preventDefault();
                $('#txt-pass').focus(); // Mover el cursor al campo de contraseña
            }
        });

    });
    </script>

</body>

</html>