<?php
session_start();
require_once "model/model_conexion.php";

echo "<h2>Diagnóstico: Usuario logueado y trámites pendientes</h2>";

// Verificar sesión
echo "<h3>1. Información de sesión:</h3>";
if (isset($_SESSION['S_ID'])) {
    $usuario_id = $_SESSION['S_ID'];
    echo "<p><strong>Usuario ID (sesión):</strong> $usuario_id</p>";
} else {
    echo "<p style='color: red;'>⚠️ No hay sesión activa. Por favor inicia sesión primero.</p>";
    exit;
}

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // Ver datos del usuario logueado
    echo "<h3>2. Datos del usuario logueado:</h3>";
    $query = $pdo->prepare("SELECT * FROM usuario WHERE usu_id = ?");
    $query->execute([$usuario_id]);
    $usuario = $query->fetch(PDO::FETCH_ASSOC);

    if ($usuario) {
        echo "<table border='1' cellpadding='5' style='border-collapse: collapse;'>";
        echo "<tr><th>Campo</th><th>Valor</th></tr>";
        echo "<tr><td><strong>usu_id</strong></td><td>" . $usuario['usu_id'] . "</td></tr>";
        echo "<tr><td><strong>usu_usuario</strong></td><td>" . $usuario['usu_usuario'] . "</td></tr>";
        echo "<tr><td><strong>area_id</strong></td><td style='background: #ffffcc; font-weight: bold;'>" . $usuario['area_id'] . "</td></tr>";
        echo "<tr><td><strong>usu_rol</strong></td><td>" . $usuario['usu_rol'] . "</td></tr>";
        echo "</table>";

        $area_usuario = $usuario['area_id'];
    } else {
        echo "<p style='color: red;'>Usuario no encontrado</p>";
        exit;
    }

    echo "<hr>";

    // Ver nombre del área
    echo "<h3>3. Área del usuario:</h3>";
    $query2 = $pdo->prepare("SELECT * FROM area WHERE area_cod = ?");
    $query2->execute([$area_usuario]);
    $area = $query2->fetch(PDO::FETCH_ASSOC);

    if ($area) {
        echo "<p><strong>Área:</strong> " . $area['area_nombre'] . " (ID: " . $area['area_cod'] . ")</p>";
    }

    echo "<hr>";

    // Ver trámites pendientes en movimiento
    echo "<h3>4. Movimientos PENDIENTES destinados a tu área (ID: $area_usuario):</h3>";
    $query3 = $pdo->prepare("
        SELECT
            movimiento.*,
            documento.documento_id,
            documento.doc_dniremitente,
            CONCAT_WS(' ', documento.doc_nombreremitente, documento.doc_apepatremitente, documento.doc_apematremitente) AS remitente
        FROM movimiento
        LEFT JOIN documento ON movimiento.documento_id = documento.documento_id
        WHERE movimiento.area_destino_id = ?
        AND movimiento.mov_estatus = 'PENDIENTE'
        ORDER BY movimiento.mov_fecharegistro DESC
    ");
    $query3->execute([$area_usuario]);
    $movimientos = $query3->fetchAll(PDO::FETCH_ASSOC);

    if (count($movimientos) > 0) {
        echo "<p style='color: green;'><strong>✓ Encontrados " . count($movimientos) . " movimiento(s) PENDIENTE(s)</strong></p>";

        echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr>";
        echo "<th>movimiento_id</th>";
        echo "<th>documento_id</th>";
        echo "<th>area_origen_id</th>";
        echo "<th>area_destino_id</th>";
        echo "<th>mov_estatus</th>";
        echo "<th>Remitente</th>";
        echo "<th>Fecha</th>";
        echo "</tr>";

        foreach ($movimientos as $mov) {
            echo "<tr>";
            echo "<td>" . $mov['movimiento_id'] . "</td>";
            echo "<td>" . $mov['documento_id'] . "</td>";
            echo "<td>" . $mov['area_origen_id'] . "</td>";
            echo "<td style='background: #ffffcc;'>" . $mov['area_destino_id'] . "</td>";
            echo "<td style='background: #ccffcc;'>" . $mov['mov_estatus'] . "</td>";
            echo "<td>" . ($mov['remitente'] ?? 'N/A') . "</td>";
            echo "<td>" . $mov['mov_fecharegistro'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p style='color: red;'>⚠️ NO hay movimientos PENDIENTES para tu área</p>";
    }

    echo "<hr>";

    // Ejecutar el SP directamente
    echo "<h3>5. Resultado del SP_LISTAR_TRAMITE_AREA:</h3>";
    echo "<p>Ejecutando: CALL SP_LISTAR_TRAMITE_AREA($usuario_id, '')</p>";

    $query4 = $pdo->prepare("CALL SP_LISTAR_TRAMITE_AREA(?, ?)");
    $query4->execute([$usuario_id, '']);
    $resultadoSP = $query4->fetchAll(PDO::FETCH_ASSOC);

    if (count($resultadoSP) > 0) {
        echo "<p style='color: green;'><strong>✓ El SP devuelve " . count($resultadoSP) . " registro(s)</strong></p>";

        echo "<table border='1' cellpadding='5' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr>";
        echo "<th>documento_id</th>";
        echo "<th>expe_num</th>";
        echo "<th>REMITENTE</th>";
        echo "<th>tipodoc_descripcion</th>";
        echo "<th>origen</th>";
        echo "<th>destino</th>";
        echo "<th>mov_estatus</th>";
        echo "</tr>";

        foreach ($resultadoSP as $fila) {
            echo "<tr>";
            echo "<td>" . $fila['documento_id'] . "</td>";
            echo "<td>" . $fila['expe_num'] . "</td>";
            echo "<td>" . $fila['REMITENTE'] . "</td>";
            echo "<td>" . $fila['tipodoc_descripcion'] . "</td>";
            echo "<td>" . $fila['origen'] . "</td>";
            echo "<td>" . $fila['destino'] . "</td>";
            echo "<td>" . $fila['mov_estatus'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<h3>✓ CONCLUSIÓN: El SP funciona correctamente</h3>";
        echo "<p>Si la tabla en tramites_recibidos.php sigue vacía, el problema está en el JavaScript o en el controlador.</p>";
    } else {
        echo "<p style='color: red;'><strong>⚠️ El SP NO devuelve ningún registro</strong></p>";
        echo "<p>Esto significa que hay un problema con la consulta del SP.</p>";

        // Debug: Ver qué área está buscando el SP
        echo "<h4>Debug: ¿Qué área busca el SP?</h4>";
        $query5 = $pdo->prepare("SELECT area_id FROM usuario WHERE usu_id = ?");
        $query5->execute([$usuario_id]);
        $areaResult = $query5->fetch(PDO::FETCH_ASSOC);
        echo "<p>El SP busca trámites para el área: <strong>" . ($areaResult['area_id'] ?? 'NULL') . "</strong></p>";
    }

} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}
?>

<style>
    body { font-family: monospace; padding: 20px; }
    h2, h3, h4 { color: #333; border-bottom: 1px solid #ddd; padding-bottom: 5px; }
    table { margin-bottom: 15px; font-size: 12px; }
</style>
