<?php
// Diagnóstico de Stored Procedures actuales
header('Content-Type: text/html; charset=utf-8');

try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=munimor9_bdmoralestramite;charset=utf8mb4',
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "<h2>Stored Procedures relacionados con TRAMITE_AREA</h2>";
    echo "<style>
        body { font-family: monospace; background: #f5f5f5; padding: 20px; }
        pre { background: white; padding: 15px; border-left: 4px solid #4CAF50; overflow-x: auto; }
        h3 { color: #2196F3; }
        .error { background: #ffebee; border-left-color: #f44336; }
    </style>";

    $procedures = [
        'SP_LISTAR_TRAMITE_AREA',
        'SP_LISTAR_TRAMITE_AREA_ENVIADO',
        'SP_LISTAR_TRAMITE_AREA_DERIVADO',
        'SP_LISTAR_TRAMITE_AREA_FINALIZADO'
    ];

    foreach ($procedures as $spName) {
        echo "<hr>";
        echo "<h3>📋 $spName</h3>";

        try {
            $stmt = $pdo->prepare("SHOW CREATE PROCEDURE $spName");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);

            if ($result) {
                echo "<pre>" . htmlspecialchars($result['Create Procedure']) . "</pre>";
            }
        } catch (PDOException $e) {
            echo "<pre class='error'>❌ ERROR: " . $e->getMessage() . "</pre>";
        }
    }

    echo "<hr>";
    echo "<h3>📊 Últimos 5 movimientos (para entender la estructura):</h3>";

    $stmt = $pdo->query("
        SELECT
            m.movimiento_id,
            m.documento_id,
            m.area_origen_id,
            ao.area_nombre AS area_origen,
            m.area_destino_id,
            ad.area_nombre AS area_destino,
            m.mov_estatus,
            m.mov_fecharegistro,
            d.area_origen AS doc_area_origen_inicial
        FROM movimiento m
        LEFT JOIN area ao ON m.area_origen_id = ao.area_cod
        LEFT JOIN area ad ON m.area_destino_id = ad.area_cod
        LEFT JOIN documento d ON m.documento_id = d.documento_id
        ORDER BY m.movimiento_id DESC
        LIMIT 5
    ");

    echo "<table border='1' cellpadding='10' style='background:white; border-collapse: collapse;'>";
    echo "<tr style='background:#2196F3; color:white;'>
            <th>ID Mov</th>
            <th>Doc ID</th>
            <th>Área Origen Mov</th>
            <th>Área Destino Mov</th>
            <th>Estado</th>
            <th>Fecha</th>
            <th>Área Origen Doc</th>
          </tr>";

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr>";
        echo "<td>{$row['movimiento_id']}</td>";
        echo "<td>{$row['documento_id']}</td>";
        echo "<td>{$row['area_origen_id']} - {$row['area_origen']}</td>";
        echo "<td>{$row['area_destino_id']} - {$row['area_destino']}</td>";
        echo "<td><strong>{$row['mov_estatus']}</strong></td>";
        echo "<td>{$row['mov_fecharegistro']}</td>";
        echo "<td>{$row['doc_area_origen_inicial']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    echo "<hr>";
    echo "<h3>✅ Diagnóstico completado</h3>";
    echo "<p>Guarda esta información para analizar el problema</p>";

} catch (PDOException $e) {
    echo "<pre class='error'>❌ ERROR DE CONEXIÓN: " . $e->getMessage() . "</pre>";
}
?>
