<?php
// Script de diagnóstico - Ejecutar desde el navegador: http://localhost/mesapartes.moralesmuni.gob.pe/diagnostico_sp.php

require_once "model/model_conexion.php";

echo "<h2>Diagnóstico del Procedimiento Almacenado</h2>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    echo "<h3>1. Verificar conexión a la base de datos</h3>";
    echo "✓ Conexión exitosa<br><br>";

    echo "<h3>2. Verificar si existe el procedimiento SP_REGISTRAR_TRAMITE_DERIVAR</h3>";
    $query = $pdo->prepare("SHOW PROCEDURE STATUS WHERE Name = 'SP_REGISTRAR_TRAMITE_DERIVAR'");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo "✓ El procedimiento existe<br>";
        echo "Creado: " . $result['Created'] . "<br>";
        echo "Modificado: " . $result['Modified'] . "<br><br>";
    } else {
        echo "✗ El procedimiento NO existe<br><br>";
    }

    echo "<h3>3. Ver definición del procedimiento</h3>";
    $query = $pdo->prepare("SHOW CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo "<pre style='background: #f4f4f4; padding: 10px; overflow: auto;'>";
        echo htmlspecialchars($result['Create Procedure']);
        echo "</pre><br>";
    }

    echo "<h3>4. Verificar parámetros del procedimiento</h3>";
    $query = $pdo->prepare("SELECT PARAMETER_NAME, DATA_TYPE, PARAMETER_MODE
                            FROM information_schema.PARAMETERS
                            WHERE SPECIFIC_NAME = 'SP_REGISTRAR_TRAMITE_DERIVAR'
                            ORDER BY ORDINAL_POSITION");
    $query->execute();
    $params = $query->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Orden</th><th>Parámetro</th><th>Tipo</th><th>Modo</th></tr>";
    $i = 1;
    foreach ($params as $param) {
        echo "<tr>";
        echo "<td>" . $i++ . "</td>";
        echo "<td>" . $param['PARAMETER_NAME'] . "</td>";
        echo "<td>" . $param['DATA_TYPE'] . "</td>";
        echo "<td>" . $param['PARAMETER_MODE'] . "</td>";
        echo "</tr>";
    }
    echo "</table><br>";

    echo "<h3>5. Verificar datos existentes para el test</h3>";

    // Obtener un usuario válido
    $query = $pdo->prepare("SELECT * FROM usuario LIMIT 1");
    $query->execute();
    $usuario_valido = $query->fetch(PDO::FETCH_ASSOC);

    if ($usuario_valido) {
        // Mostrar el primer campo que tenga nombre/usuario
        $nombre_usuario = isset($usuario_valido['usu_usuario']) ? $usuario_valido['usu_usuario'] :
                         (isset($usuario_valido['usu_nombre']) ? $usuario_valido['usu_nombre'] : 'N/A');
        echo "Usuario válido encontrado: ID=" . $usuario_valido['usu_id'] . " (" . $nombre_usuario . ")<br>";
    } else {
        echo "⚠️ No hay usuarios en la tabla 'usuario'<br>";
    }

    // Obtener un área válida
    $query = $pdo->prepare("SELECT area_cod, area_nombre FROM area LIMIT 2");
    $query->execute();
    $areas = $query->fetchAll(PDO::FETCH_ASSOC);

    if (count($areas) >= 2) {
        echo "Área origen válida: ID=" . $areas[0]['area_cod'] . " (" . $areas[0]['area_nombre'] . ")<br>";
        echo "Área destino válida: ID=" . $areas[1]['area_cod'] . " (" . $areas[1]['area_nombre'] . ")<br><br>";
    } else {
        echo "⚠️ No hay suficientes áreas en la tabla 'area'<br><br>";
    }

    // Obtener un documento válido
    $query = $pdo->prepare("SELECT documento_id, doc_nrodocumento FROM documento ORDER BY documento_id DESC LIMIT 1");
    $query->execute();
    $doc_valido = $query->fetch(PDO::FETCH_ASSOC);

    if ($doc_valido) {
        echo "Documento válido encontrado: ID=" . $doc_valido['documento_id'] . " (" . $doc_valido['doc_nrodocumento'] . ")<br><br>";
    } else {
        echo "⚠️ No hay documentos en la tabla 'documento'<br><br>";
    }

    echo "<h3>6. Probar el procedimiento con datos de prueba</h3>";
    echo "<p>Intentando ejecutar con parámetros válidos...</p>";

    if ($usuario_valido && count($areas) >= 2 && $doc_valido) {
        $test_doc_id = $doc_valido['documento_id'];
        $test_usuario_id = $usuario_valido['usu_id'];
        $test_area_orig = $areas[0]['area_cod'];
        $test_area_dest = $areas[1]['area_cod'];

        // Test con DERIVAR
        try {
            $test_query = $pdo->prepare("CALL SP_REGISTRAR_TRAMITE_DERIVAR(?, ?, ?, 'TEST DERIVAR', ?, '', 'DERIVAR', 0)");
            $test_query->execute([$test_doc_id, $test_area_orig, $test_area_dest, $test_usuario_id]);
            echo "✓ Test con DERIVAR: <span style='color: green;'>EXITOSO</span><br>";

            // Eliminar el registro de prueba
            $pdo->exec("DELETE FROM movimiento WHERE mov_descripcion = 'TEST DERIVAR' AND documento_id = $test_doc_id");
        } catch (PDOException $e) {
            echo "✗ Test con DERIVAR: <span style='color: red;'>FALLÓ</span><br>";
            echo "Error: " . $e->getMessage() . "<br>";
        }

        // Test con FINALIZAR (dest = NULL)
        try {
            $test_query = $pdo->prepare("CALL SP_REGISTRAR_TRAMITE_DERIVAR(?, ?, NULL, 'TEST FINALIZAR', ?, '', 'FINALIZAR', 0)");
            $test_query->execute([$test_doc_id, $test_area_orig, $test_usuario_id]);
            echo "✓ Test con FINALIZAR (dest=NULL): <span style='color: green;'>EXITOSO</span><br>";

            // Eliminar el registro de prueba
            $pdo->exec("DELETE FROM movimiento WHERE mov_descripcion = 'TEST FINALIZAR' AND documento_id = $test_doc_id");
        } catch (PDOException $e) {
            echo "✗ Test con FINALIZAR (dest=NULL): <span style='color: red;'>FALLÓ</span><br>";
            echo "Error: " . $e->getMessage() . "<br>";
        }
    } else {
        echo "<span style='color: red;'>No se pueden ejecutar los tests porque faltan datos válidos en las tablas.</span>";
    }

} catch (Exception $e) {
    echo "<span style='color: red;'>Error general: " . $e->getMessage() . "</span>";
}
?>
