<?php
header('Content-Type: text/html; charset=utf-8');

try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=munimor9_bdmoralestramite;charset=utf8mb4',
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "<style>
        body { font-family: Arial, sans-serif; background: #f5f5f5; padding: 20px; }
        table { background: white; border-collapse: collapse; width: 100%; margin: 20px 0; }
        th { background: #1976D2; color: white; padding: 10px; text-align: left; }
        td { padding: 8px; border-bottom: 1px solid #ddd; }
        .pendiente { background: #fff9c4; }
        .derivado { background: #e1bee7; }
        .vacio { background: #ffcdd2; }
        h2 { color: #1976D2; }
        .info { background: #e3f2fd; padding: 15px; margin: 10px 0; border-left: 4px solid #2196F3; }
        .error { background: #ffebee; padding: 15px; margin: 10px 0; border-left: 4px solid #f44336; }
    </style>";

    echo "<h1>🔍 DIAGNÓSTICO FINAL - NUEVO TRÁMITE</h1>";

    // Ver el documento más reciente
    $stmt = $pdo->query("
        SELECT documento_id
        FROM documento
        ORDER BY doc_fecharegistro DESC
        LIMIT 1
    ");
    $doc_id = $stmt->fetchColumn();

    if (!$doc_id) {
        echo "<div class='error'>❌ No hay documentos en la base de datos</div>";
        exit;
    }

    echo "<div class='info'><strong>📄 Documento más reciente: $doc_id</strong></div>";

    // Ver TODOS los movimientos de ese documento
    echo "<h2>🔄 Movimientos del documento $doc_id:</h2>";
    $stmt = $pdo->prepare("
        SELECT
            m.movimiento_id,
            m.area_origen_id,
            ao.area_nombre AS area_origen,
            m.area_destino_id,
            ad.area_nombre AS area_destino,
            m.mov_estatus,
            m.mov_descripcion,
            m.mov_fecharegistro,
            u.usu_usuario,
            CASE
                WHEN m.movimiento_id = (
                    SELECT MAX(m2.movimiento_id)
                    FROM movimiento m2
                    WHERE m2.documento_id = m.documento_id
                ) THEN 'SÍ'
                ELSE 'NO'
            END AS es_ultimo
        FROM movimiento m
        LEFT JOIN area ao ON m.area_origen_id = ao.area_cod
        LEFT JOIN area ad ON m.area_destino_id = ad.area_cod
        LEFT JOIN usuario u ON m.usuario_id = u.usu_id
        WHERE m.documento_id = ?
        ORDER BY m.movimiento_id
    ");
    $stmt->execute([$doc_id]);
    $movimientos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1'>";
    echo "<tr>
            <th>ID</th>
            <th>De (Origen)</th>
            <th>A (Destino)</th>
            <th>Estado</th>
            <th>Usuario</th>
            <th>Fecha</th>
            <th>¿Es Último?</th>
          </tr>";

    foreach ($movimientos as $mov) {
        $clase = '';
        switch ($mov['mov_estatus']) {
            case 'PENDIENTE': $clase = 'pendiente'; break;
            case 'DERIVADO': $clase = 'derivado'; break;
            default: $clase = 'vacio';
        }

        echo "<tr class='$clase'>";
        echo "<td><strong>{$mov['movimiento_id']}</strong></td>";
        echo "<td>{$mov['area_origen_id']} - {$mov['area_origen']}</td>";
        echo "<td>{$mov['area_destino_id']} - {$mov['area_destino']}</td>";
        echo "<td><strong>" . ($mov['mov_estatus'] ?: '⚠️ VACÍO') . "</strong></td>";
        echo "<td>{$mov['usu_usuario']}</td>";
        echo "<td>{$mov['mov_fecharegistro']}</td>";
        echo "<td>{$mov['es_ultimo']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    // Probar los SP directamente
    echo "<hr><h2>🧪 PRUEBA DE STORED PROCEDURES</h2>";

    // Obtener IDs de usuarios para cada área
    $usuarios = [
        'Mesa de Partes (19)' => 62,
        'Gerencia (15)' => 104,
        'Informática (29)' => 62
    ];

    foreach ($usuarios as $nombre => $user_id) {
        echo "<h3>👤 Usuario: $nombre (ID: $user_id)</h3>";

        // Obtener el área del usuario
        $stmt = $pdo->prepare("SELECT area_id, area_nombre FROM usuario u LEFT JOIN area a ON u.area_id = a.area_cod WHERE u.usu_id = ?");
        $stmt->execute([$user_id]);
        $user_info = $stmt->fetch(PDO::FETCH_ASSOC);

        echo "<div class='info'>Área del usuario: {$user_info['area_id']} - {$user_info['area_nombre']}</div>";

        // Probar SP_LISTAR_TRAMITE_AREA_DERIVADO
        echo "<strong>📤 Trámites Derivados (llamando SP con usuario $user_id):</strong><br>";
        try {
            $pdo->exec("SET @user_id = $user_id");
            $stmt = $pdo->prepare("CALL SP_LISTAR_TRAMITE_AREA_DERIVADO(?)");
            $stmt->execute([$user_id]);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (empty($results)) {
                echo "<div style='padding:10px; background:#f5f5f5;'>⚠️ No hay trámites derivados</div>";
            } else {
                echo "<table border='1' style='font-size:12px;'>";
                echo "<tr><th>Doc ID</th><th>Mov ID</th><th>Estado</th><th>Origen</th><th>Destino</th></tr>";
                foreach ($results as $r) {
                    echo "<tr>";
                    echo "<td>{$r['documento_id']}</td>";
                    echo "<td>{$r['movimiento_id']}</td>";
                    echo "<td><strong>{$r['mov_estatus']}</strong></td>";
                    echo "<td>{$r['origen']}</td>";
                    echo "<td>{$r['destino']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
        } catch (Exception $e) {
            echo "<div class='error'>ERROR: " . $e->getMessage() . "</div>";
        }

        // Reset connection
        $pdo = new PDO(
            'mysql:host=localhost;dbname=munimor9_bdmoralestramite;charset=utf8mb4',
            'root',
            '',
            [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
        );

        echo "<br>";
    }

    // Verificar qué devuelve la query directamente
    echo "<hr><h2>🔬 QUERY DIRECTA: Movimientos con estado DERIVADO</h2>";
    $stmt = $pdo->query("
        SELECT
            m.movimiento_id,
            m.documento_id,
            m.area_origen_id,
            ao.area_nombre AS origen,
            m.area_destino_id,
            ad.area_nombre AS destino,
            m.mov_estatus
        FROM movimiento m
        LEFT JOIN area ao ON m.area_origen_id = ao.area_cod
        LEFT JOIN area ad ON m.area_destino_id = ad.area_cod
        WHERE m.mov_estatus = 'DERIVADO'
        ORDER BY m.movimiento_id DESC
    ");

    $derivados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($derivados)) {
        echo "<div class='error'>❌ NO HAY MOVIMIENTOS CON ESTADO 'DERIVADO' EN LA BASE DE DATOS</div>";
        echo "<div class='info'>🔍 Esto explica por qué no aparece nada en Trámites Derivados</div>";
    } else {
        echo "<table border='1'>";
        echo "<tr><th>Mov ID</th><th>Doc ID</th><th>De</th><th>A</th><th>Estado</th></tr>";
        foreach ($derivados as $d) {
            echo "<tr class='derivado'>";
            echo "<td>{$d['movimiento_id']}</td>";
            echo "<td>{$d['documento_id']}</td>";
            echo "<td>{$d['area_origen_id']} - {$d['origen']}</td>";
            echo "<td>{$d['area_destino_id']} - {$d['destino']}</td>";
            echo "<td><strong>{$d['mov_estatus']}</strong></td>";
            echo "</tr>";
        }
        echo "</table>";
    }

    echo "<h2>✅ Diagnóstico completado</h2>";

} catch (PDOException $e) {
    echo "<div class='error'>❌ ERROR: " . $e->getMessage() . "</div>";
}
?>
