<?php
// Script para diagnosticar y ver todos los procedimientos almacenados
require_once "model/model_conexion.php";

echo "<style>
    body { font-family: monospace; padding: 20px; }
    h2 { color: #333; border-bottom: 2px solid #333; padding-bottom: 5px; }
    pre { background: #f4f4f4; padding: 15px; overflow: auto; border-left: 3px solid #007bff; }
    .warning { color: #ff6600; font-weight: bold; }
    .success { color: #28a745; font-weight: bold; }
</style>";

try {
    $conexion = new ConexionDB();
    $pdo = $conexion->conexionPDO();

    // 1. Ver SP_LISTAR_TRAMITE_AREA
    echo "<h2>1. SP_LISTAR_TRAMITE_AREA (Lista trámites recibidos)</h2>";
    $query = $pdo->prepare("SHOW CREATE PROCEDURE SP_LISTAR_TRAMITE_AREA");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo "<pre>" . htmlspecialchars($result['Create Procedure']) . "</pre>";
    } else {
        echo "<span class='warning'>⚠️ No existe el procedimiento</span>";
    }

    echo "<hr>";

    // 2. Ver SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE
    echo "<h2>2. SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE (Seguimiento público)</h2>";
    $query = $pdo->prepare("SHOW CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE");
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        echo "<pre>" . htmlspecialchars($result['Create Procedure']) . "</pre>";

        // Verificar si incluye el filtro de visibilidad
        if (strpos($result['Create Procedure'], 'mov_visible_publico') !== false) {
            echo "<p class='success'>✓ El procedimiento incluye el filtro de visibilidad</p>";
        } else {
            echo "<p class='warning'>⚠️ El procedimiento NO incluye el filtro de visibilidad</p>";
        }
    } else {
        echo "<span class='warning'>⚠️ No existe el procedimiento</span>";
    }

    echo "<hr>";

    // 3. Ver estructura de la tabla movimiento
    echo "<h2>3. Estructura de la tabla movimiento</h2>";
    $query = $pdo->prepare("DESCRIBE movimiento");
    $query->execute();
    $columns = $query->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Columna</th><th>Tipo</th><th>Null</th><th>Key</th><th>Default</th></tr>";

    $has_visible_publico = false;
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td><strong>" . $col['Field'] . "</strong></td>";
        echo "<td>" . $col['Type'] . "</td>";
        echo "<td>" . $col['Null'] . "</td>";
        echo "<td>" . $col['Key'] . "</td>";
        echo "<td>" . ($col['Default'] ?? 'NULL') . "</td>";
        echo "</tr>";

        if ($col['Field'] == 'mov_visible_publico') {
            $has_visible_publico = true;
        }
    }
    echo "</table><br>";

    if ($has_visible_publico) {
        echo "<p class='success'>✓ La tabla movimiento tiene el campo mov_visible_publico</p>";
    } else {
        echo "<p class='warning'>⚠️ La tabla movimiento NO tiene el campo mov_visible_publico</p>";
    }

    echo "<hr>";

    // 4. Probar datos reales
    echo "<h2>4. Datos de prueba en movimiento</h2>";
    $query = $pdo->prepare("SELECT movimiento_id, documento_id, mov_estatus, mov_archivo, mov_visible_publico FROM movimiento ORDER BY movimiento_id DESC LIMIT 10");
    $query->execute();
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>ID</th><th>Documento</th><th>Estatus</th><th>Archivo</th><th>Visible Público</th></tr>";

    foreach ($rows as $row) {
        echo "<tr>";
        echo "<td>" . $row['movimiento_id'] . "</td>";
        echo "<td>" . $row['documento_id'] . "</td>";
        echo "<td>" . $row['mov_estatus'] . "</td>";
        echo "<td>" . ($row['mov_archivo'] ?: 'Sin archivo') . "</td>";
        echo "<td>" . ($row['mov_visible_publico'] ?? 'NULL') . "</td>";
        echo "</tr>";
    }
    echo "</table>";

} catch (Exception $e) {
    echo "<span style='color: red;'>Error: " . $e->getMessage() . "</span>";
}
?>
