-- ========================================
-- DIAGNOSTICAR POR QUÉ NO SE ACTUALIZA
-- ========================================

-- Ver el código actual del SP
SHOW CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR;

-- Simular el UPDATE que debería ejecutarse cuando Informática (29) deriva a Mesa de Partes (19)
-- ORIG = 29 (Informática está derivando)
-- IDDO = '001-2025'

SELECT 'SIMULACIÓN: Movimientos que deberían actualizarse' AS Info;

SELECT
    movimiento_id,
    documento_id,
    area_origen_id,
    area_destino_id,
    mov_estatus,
    mov_recibido,
    'ESTE DEBERÍA ACTUALIZARSE' AS nota
FROM movimiento
WHERE documento_id = '001-2025'
AND area_destino_id = 29  -- ORIG = Informática
AND mov_estatus = 'PENDIENTE'
AND mov_recibido = 0
ORDER BY movimiento_id DESC
LIMIT 1;

SELECT 'Si no aparece ningún resultado arriba, el problema es la condición del WHERE' AS Explicacion;
