<?php
header('Content-Type: text/html; charset=utf-8');

try {
    $pdo = new PDO(
        'mysql:host=localhost;dbname=munimor9_bdmoralestramite;charset=utf8mb4',
        'root',
        '',
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );

    echo "<style>
        body { font-family: monospace; background: #f5f5f5; padding: 20px; }
        table { background: white; border-collapse: collapse; width: 100%; margin: 20px 0; }
        th { background: #2196F3; color: white; padding: 10px; text-align: left; }
        td { padding: 8px; border-bottom: 1px solid #ddd; }
        .error { background: #ffebee; color: #c62828; padding: 10px; margin: 10px 0; }
        .success { background: #e8f5e9; color: #2e7d32; padding: 10px; margin: 10px 0; }
        h2 { color: #1976D2; }
    </style>";

    echo "<h2>🔍 DEBUG: Nuevo Trámite Creado</h2>";

    // Ver todos los movimientos actuales
    echo "<h3>📋 TODOS los movimientos en la base de datos:</h3>";
    $stmt = $pdo->query("
        SELECT
            m.movimiento_id,
            m.documento_id,
            m.area_origen_id,
            ao.area_nombre AS area_origen_nombre,
            m.area_destino_id,
            ad.area_nombre AS area_destino_nombre,
            m.mov_estatus,
            m.mov_descripcion,
            m.mov_fecharegistro,
            m.usuario_id,
            u.usu_usuario,
            -- ¿Es el último?
            CASE
                WHEN m.movimiento_id = (
                    SELECT MAX(m2.movimiento_id)
                    FROM movimiento m2
                    WHERE m2.documento_id = m.documento_id
                ) THEN '✅ ÚLTIMO'
                ELSE '⬜ ANTERIOR'
            END AS posicion
        FROM movimiento m
        LEFT JOIN area ao ON m.area_origen_id = ao.area_cod
        LEFT JOIN area ad ON m.area_destino_id = ad.area_cod
        LEFT JOIN usuario u ON m.usuario_id = u.usu_id
        ORDER BY m.documento_id, m.movimiento_id
    ");

    echo "<table border='1'>";
    echo "<tr>
            <th>ID</th>
            <th>Documento</th>
            <th>Área Origen</th>
            <th>Área Destino</th>
            <th>Estado</th>
            <th>Descripción</th>
            <th>Usuario</th>
            <th>Fecha</th>
            <th>Posición</th>
          </tr>";

    $movimientos = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $movimientos[] = $row;
        $estado_color = '';
        if ($row['mov_estatus'] == 'PENDIENTE') $estado_color = 'background: #fff9c4;';
        if ($row['mov_estatus'] == 'DERIVADO') $estado_color = 'background: #e1bee7;';
        if ($row['mov_estatus'] == 'FINALIZADO') $estado_color = 'background: #c8e6c9;';
        if (empty($row['mov_estatus'])) $estado_color = 'background: #ffcdd2;';

        echo "<tr style='$estado_color'>";
        echo "<td><strong>{$row['movimiento_id']}</strong></td>";
        echo "<td>{$row['documento_id']}</td>";
        echo "<td>{$row['area_origen_id']} - {$row['area_origen_nombre']}</td>";
        echo "<td>{$row['area_destino_id']} - {$row['area_destino_nombre']}</td>";
        echo "<td><strong>" . ($row['mov_estatus'] ?: '❌ VACÍO') . "</strong></td>";
        echo "<td>" . substr($row['mov_descripcion'], 0, 50) . "...</td>";
        echo "<td>{$row['usu_usuario']}</td>";
        echo "<td>{$row['mov_fecharegistro']}</td>";
        echo "<td>{$row['posicion']}</td>";
        echo "</tr>";
    }
    echo "</table>";

    if (empty($movimientos)) {
        echo "<div class='error'>❌ No hay movimientos en la base de datos</div>";
    }

    // Probar los SP con cada área
    echo "<hr><h3>🧪 PRUEBA DE STORED PROCEDURES:</h3>";

    $areas = [
        ['id' => 62, 'nombre' => 'Mesa de Partes'],
        ['id' => 15, 'nombre' => 'Gerencia'],
        ['id' => 29, 'nombre' => 'Informática']
    ];

    foreach ($areas as $area) {
        echo "<h4>Área: {$area['nombre']} (ID Usuario ejemplo con esta área)</h4>";

        // SP_LISTAR_TRAMITE_AREA (Recibidos)
        echo "<strong>📥 Trámites Recibidos (PENDIENTE en mi área):</strong><br>";
        try {
            $stmt = $pdo->prepare("CALL SP_LISTAR_TRAMITE_AREA(?, '')");
            $stmt->execute([$area['id']]);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (empty($results)) {
                echo "<div style='padding:10px; background:#f5f5f5;'>No hay trámites recibidos</div>";
            } else {
                echo "<table border='1'><tr><th>Doc</th><th>Estado</th><th>Origen</th><th>Destino</th></tr>";
                foreach ($results as $r) {
                    echo "<tr>";
                    echo "<td>{$r['documento_id']}</td>";
                    echo "<td>{$r['mov_estatus']}</td>";
                    echo "<td>{$r['origen']}</td>";
                    echo "<td>{$r['destino']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
        } catch (Exception $e) {
            echo "<div class='error'>ERROR: " . $e->getMessage() . "</div>";
        }
        $pdo->query("CALL munimor9_bdmoralestramite.SP_LISTAR_TRAMITE_AREA(62, '')"); // Reset

        echo "<br><strong>📤 Trámites Derivados (DERIVADO desde mi área):</strong><br>";
        try {
            $stmt = $pdo->prepare("CALL SP_LISTAR_TRAMITE_AREA_DERIVADO(?)");
            $stmt->execute([$area['id']]);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (empty($results)) {
                echo "<div style='padding:10px; background:#f5f5f5;'>No hay trámites derivados</div>";
            } else {
                echo "<table border='1'><tr><th>Doc</th><th>Estado</th><th>Origen</th><th>Destino</th></tr>";
                foreach ($results as $r) {
                    echo "<tr>";
                    echo "<td>{$r['documento_id']}</td>";
                    echo "<td>{$r['mov_estatus']}</td>";
                    echo "<td>{$r['origen']}</td>";
                    echo "<td>{$r['destino']}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
        } catch (Exception $e) {
            echo "<div class='error'>ERROR: " . $e->getMessage() . "</div>";
        }
        $pdo->query("CALL munimor9_bdmoralestramite.SP_LISTAR_TRAMITE_AREA_DERIVADO(62)"); // Reset

        echo "<hr>";
    }

    echo "<h3>✅ Debug completado</h3>";

} catch (PDOException $e) {
    echo "<div class='error'>❌ ERROR DE CONEXIÓN: " . $e->getMessage() . "</div>";
}
?>
