-- ========================================
-- NUEVO: SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE_INTERNO
-- ========================================
-- Para usuarios logueados: Muestra TODOS los archivos sin filtrar por visible_publico
-- La diferencia con el SP público es que NO filtra por mov_visible_publico

DROP PROCEDURE IF EXISTS SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE_INTERNO;

DELIMITER $$

CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE_INTERNO(
    IN NUMERO VARCHAR(50)
)
BEGIN
    -- Este SP devuelve el detalle de seguimiento para USUARIOS LOGUEADOS
    -- Muestra TODOS los archivos adjuntos, sin importar mov_visible_publico
    -- Debe devolver EXACTAMENTE 9 columnas con ALIAS ÚNICOS

    SELECT
        movimiento.movimiento_id,                    -- [0]
        movimiento.documento_id,                     -- [1]
        areadestino.area_nombre AS area_destino_nombre,  -- [2]
        movimiento.mov_fecharegistro,                -- [3]
        movimiento.mov_descripcion,                  -- [4]
        movimiento.mov_estatus,                      -- [5]
        areaorigen.area_nombre AS area_origen_nombre,    -- [6]
        movimiento.mov_descripcion AS mov_descripcion_original,  -- [7]
        -- [8] Mostrar TODOS los archivos (sin filtrar por visible_publico)
        movimiento.mov_archivo                       -- [8] ← SIN FILTRO
    FROM movimiento
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    WHERE movimiento.documento_id = NUMERO
    ORDER BY movimiento.movimiento_id ASC;
END$$

DELIMITER ;

-- Verificar creación
SELECT 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE_INTERNO creado - muestra TODOS los archivos' AS Resultado;

-- Test
CALL SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE_INTERNO('001-2025');
