-- ========================================
-- CORRECCIÓN: Actualizar movimientos antiguos que quedaron mal
-- ========================================
-- Este script corrige los movimientos del documento 001-2025 que quedaron
-- con estado incorrecto antes de arreglar el SP

-- Movimiento ID 3: Tiene estatus vacío, debería ser DERIVADO
UPDATE movimiento
SET mov_estatus = 'DERIVADO'
WHERE movimiento_id = 3;

-- Movimiento ID 4: Está PENDIENTE pero ya fue derivado, debe ser DERIVADO
UPDATE movimiento
SET mov_estatus = 'DERIVADO'
WHERE movimiento_id = 4;

-- Movimiento ID 5: Está PENDIENTE pero ya fue derivado, debe ser DERIVADO
UPDATE movimiento
SET mov_estatus = 'DERIVADO'
WHERE movimiento_id = 5;

-- Movimiento ID 6: Está PENDIENTE pero el trámite fue FINALIZADO, debe ser DERIVADO
UPDATE movimiento
SET mov_estatus = 'DERIVADO'
WHERE movimiento_id = 6;

-- Verificar corrección
SELECT 'Movimientos antiguos corregidos' AS Resultado;

-- Ver el estado final
SELECT
    movimiento_id,
    documento_id,
    area_origen_id,
    area_destino_id,
    mov_estatus,
    mov_descripcion
FROM movimiento
WHERE documento_id = '001-2025'
ORDER BY movimiento_id ASC;
