-- ========================================
-- CORRECCIÓN V2: SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE
-- ========================================
-- Problema: Dos columnas con nombre "area_nombre" - PDO solo devuelve la última
-- Solución: Usar alias DIFERENTES para área origen y destino

DROP PROCEDURE IF EXISTS SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE;

DELIMITER $$

CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE(
    IN NUMERO VARCHAR(50)
)
BEGIN
    -- Este SP devuelve el detalle de seguimiento para el público
    -- IMPORTANTE: Debe devolver EXACTAMENTE 9 columnas con ALIAS ÚNICOS
    -- JavaScript espera: dataDetalle[i][8] para obtener el archivo

    SELECT
        movimiento.movimiento_id,                    -- [0]
        movimiento.documento_id,                     -- [1]
        areadestino.area_nombre AS area_destino_nombre,  -- [2] ← CAMBIO: alias único
        movimiento.mov_fecharegistro,                -- [3]
        movimiento.mov_descripcion,                  -- [4]
        movimiento.mov_estatus,                      -- [5]
        areaorigen.area_nombre AS area_origen_nombre,    -- [6] ← CAMBIO: alias único
        movimiento.mov_descripcion AS mov_descripcion_original,  -- [7]
        -- [8] Solo mostrar archivo si está marcado como visible públicamente
        CASE
            WHEN movimiento.mov_visible_publico = 1 THEN movimiento.mov_archivo
            ELSE NULL
        END AS mov_archivo                           -- [8]
    FROM movimiento
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    WHERE movimiento.documento_id = NUMERO
    ORDER BY movimiento.movimiento_id ASC;
END$$

DELIMITER ;

-- Verificar creación
SELECT 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE V2 - con alias únicos' AS Resultado;

-- Test
CALL SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE('001-2025');
