-- ========================================
-- CORRECCIÓN: SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE
-- ========================================
-- Problema: Devuelve 8 columnas pero JavaScript espera 9
-- El archivo está en índice [7] pero debería estar en [8]
-- Falta la columna del área de origen como segunda columna separada

DROP PROCEDURE IF EXISTS SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE;

DELIMITER $$

CREATE PROCEDURE SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE(
    IN NUMERO VARCHAR(50)
)
BEGIN
    -- Este SP devuelve el detalle de seguimiento para el público
    -- IMPORTANTE: Debe devolver EXACTAMENTE 9 columnas en este orden:
    -- [0] movimiento_id
    -- [1] documento_id
    -- [2] area_nombre (DESTINO)
    -- [3] mov_fecharegistro
    -- [4] mov_descripcion
    -- [5] mov_estatus
    -- [6] area_nombre (ORIGEN)
    -- [7] mov_descripcion_original
    -- [8] mov_archivo (filtrado por visible_publico)

    SELECT
        movimiento.movimiento_id,                    -- [0]
        movimiento.documento_id,                     -- [1]
        areadestino.area_nombre,                     -- [2] área destino
        movimiento.mov_fecharegistro,                -- [3]
        movimiento.mov_descripcion,                  -- [4]
        movimiento.mov_estatus,                      -- [5]
        areaorigen.area_nombre,                      -- [6] área origen
        movimiento.mov_descripcion AS mov_descripcion_original,  -- [7]
        -- [8] Solo mostrar archivo si está marcado como visible públicamente
        CASE
            WHEN movimiento.mov_visible_publico = 1 THEN movimiento.mov_archivo
            ELSE NULL
        END AS mov_archivo                           -- [8] ← CRÍTICO: Debe ser la columna 9
    FROM movimiento
    LEFT JOIN area AS areadestino ON movimiento.area_destino_id = areadestino.area_cod
    LEFT JOIN area AS areaorigen ON movimiento.area_origen_id = areaorigen.area_cod
    WHERE movimiento.documento_id = NUMERO
    ORDER BY movimiento.movimiento_id ASC;
END$$

DELIMITER ;

-- Verificar creación
SELECT 'SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE corregido - ahora devuelve 9 columnas' AS Resultado;

-- Test rápido
SELECT 'Probando con documento 001-2025...' AS Test;
CALL SP_CARGAR_SEGUIMIENTO_TRAMITE_DETALLE('001-2025');
