-- ========================================
-- CORRECCIÓN: SP_REGISTRAR_TRAMITE_DERIVAR
-- ========================================
-- Problema: No actualiza el estatus del movimiento anterior
-- Solución: Cambiar el movimiento anterior de PENDIENTE a DERIVADO/FINALIZADO

DROP PROCEDURE IF EXISTS SP_REGISTRAR_TRAMITE_DERIVAR;

DELIMITER $$

CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR(
    IN IDDO VARCHAR(50),
    IN ORIG INT,
    IN DEST INT,
    IN DESCRIP VARCHAR(255),
    IN IDUSU INT,
    IN RUTA VARCHAR(255),
    IN ACCION VARCHAR(20),
    IN VISIBLE_PUBLICO TINYINT
)
BEGIN
    DECLARE ESTATUS VARCHAR(20);

    -- Determinar el estatus del NUEVO movimiento
    IF ACCION = 'DERIVAR' THEN
        SET ESTATUS = 'PENDIENTE';  -- El nuevo movimiento queda PENDIENTE
    ELSE
        SET ESTATUS = 'FINALIZADO';  -- Si es FINALIZAR, el nuevo movimiento queda FINALIZADO
    END IF;

    -- PASO 1: Actualizar el movimiento ANTERIOR (el que estaba PENDIENTE) a DERIVADO o FINALIZADO
    -- Esto es CRÍTICO para que desaparezca de la lista de "Trámites Recibidos"
    UPDATE movimiento
    SET mov_estatus = ACCION  -- Cambia PENDIENTE a DERIVADO o FINALIZADO según la acción
    WHERE documento_id = IDDO
    AND area_destino_id = ORIG  -- El movimiento que tenía como destino el área actual
    AND mov_estatus = 'PENDIENTE'  -- Solo actualizar los que están PENDIENTE
    ORDER BY movimiento_id DESC
    LIMIT 1;  -- Solo el último movimiento PENDIENTE

    -- PASO 2: Insertar el NUEVO movimiento (derivación o finalización)
    INSERT INTO movimiento(
        documento_id,
        area_origen_id,
        area_destino_id,
        mov_descripcion,
        mov_estatus,
        mov_fecharegistro,
        usuario_id,
        mov_archivo,
        mov_visible_publico
    ) VALUES (
        IDDO,
        ORIG,
        IF(DEST = 0 OR DEST IS NULL, NULL, DEST),  -- NULL si es FINALIZAR
        DESCRIP,
        ESTATUS,  -- PENDIENTE (si deriva) o FINALIZADO (si finaliza)
        NOW(),
        IDUSU,
        RUTA,
        VISIBLE_PUBLICO
    );

    -- PASO 3: Actualizar el documento
    UPDATE documento SET
        doc_estatus = IF(ACCION = 'FINALIZAR', 'FINALIZADO', doc_estatus)
    WHERE documento_id = IDDO;
END$$

DELIMITER ;

-- Verificar creación
SELECT 'SP_REGISTRAR_TRAMITE_DERIVAR actualizado correctamente' AS Resultado;

-- Mensaje
SELECT 'Ahora los trámites derivados desaparecerán de la lista' AS Instruccion;
