<?php
    require "../../model/model_usuario.php";
    $MU = new Modelo_Usuario();//Instaciamos
    $id =strtoupper(htmlspecialchars($_POST['id'],ENT_QUOTES,'UTF-8'));
    $usu_nuevo =strtoupper(htmlspecialchars($_POST['usu_nuevo'],ENT_QUOTES,'UTF-8'));
    $nombrearchivo =strtoupper(htmlspecialchars($_POST['nombrearchivo'],ENT_QUOTES,'UTF-8'));
    $ruta;
    if(empty($nombrearchivo)){
      $ruta = "";
    }else{
      $ruta='controller/empleado/foto/'.$nombrearchivo;
    }

    $contra_hash =$_POST['contra_hash'];
    $contra_a='';
    $contra_n='';

    // Si hay archivo, validarlo y moverlo ANTES de registrar en BD
    if(!empty($nombrearchivo)){
        // Validar que se haya enviado un archivo
        if (!isset($_FILES['archivoobj']) || $_FILES['archivoobj']['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(['success' => false, 'message' => 'Error: No se recibió el archivo correctamente']);
            exit;
        }

        // Validar extensión del archivo (solo imágenes)
        $archivo_temp = $_FILES['archivoobj']['tmp_name'];
        $extension = strtolower(pathinfo($nombrearchivo, PATHINFO_EXTENSION));
        $extensiones_permitidas = ['jpg', 'jpeg', 'png', 'gif'];

        if (!in_array($extension, $extensiones_permitidas)) {
            echo json_encode(['success' => false, 'message' => 'Error: Solo se permiten imágenes (JPG, PNG, GIF)']);
            exit;
        }

        // Validar tamaño del archivo (máximo 5MB para fotos)
        $tamano_maximo = 5 * 1024 * 1024;
        if ($_FILES['archivoobj']['size'] > $tamano_maximo) {
            echo json_encode(['success' => false, 'message' => 'Error: La imagen excede el tamaño máximo de 5MB']);
            exit;
        }

        // Crear carpeta si no existe
        $carpeta_destino = "../empleado/foto/";
        if (!file_exists($carpeta_destino)) {
            if (!mkdir($carpeta_destino, 0777, true)) {
                echo json_encode(['success' => false, 'message' => 'Error: No se pudo crear la carpeta de destino']);
                exit;
            }
        }

        // Mover el archivo
        $ruta_completa = $carpeta_destino . $nombrearchivo;
        if (!move_uploaded_file($archivo_temp, $ruta_completa)) {
            echo json_encode(['success' => false, 'message' => 'Error: No se pudo guardar la imagen']);
            exit;
        }

        // Verificar que el archivo se guardó correctamente
        if (!file_exists($ruta_completa) || filesize($ruta_completa) == 0) {
            if (file_exists($ruta_completa)) {
                unlink($ruta_completa);
            }
            echo json_encode(['success' => false, 'message' => 'Error: La imagen no se guardó correctamente']);
            exit;
        }
    }

    $consulta;
    if(isset($_POST['contra_a']) && isset($_POST['contra_n'])){
      $contra_a =$_POST['contra_a'];
      $contra_n =password_hash(htmlspecialchars($_POST['contra_n'],ENT_QUOTES,'UTF-8'), PASSWORD_DEFAULT, ['cost' => 12]);
      if (password_verify($contra_a, $contra_hash)) {
        $consulta = $MU->Modificar_Usuario_Actual($id,$usu_nuevo,$contra_n,$ruta);
      }else{
        $consulta =0;
      }
    }else{
      $consulta = $MU->Modificar_Solo_Usuario_Actual($id,$usu_nuevo,$ruta);
    }

    if($consulta==1){
      // Modificación exitosa
      echo $consulta;
    } else {
      // Si falla la modificación y había archivo, eliminarlo
      if(!empty($nombrearchivo) && file_exists($ruta_completa)){
          unlink($ruta_completa);
      }
      echo $consulta;
    }

?>