<?php
    require "../../model/model_tramite_area.php";
    $MU = new Modelo_TramiteArea();//Instaciamos

    //datos del remitente
    $iddo = htmlspecialchars($_POST['iddo'], ENT_QUOTES, 'UTF-8'); // Dejar como string (puede ser "491-2025")
    $orig = intval($_POST['orig']); // Convertir a entero

    // Manejar dest: si está vacío o es "null", usar NULL, sino convertir a entero
    $dest = (empty($_POST['dest']) || $_POST['dest'] === 'null') ? null : intval($_POST['dest']);

    $desc = strtoupper(htmlspecialchars($_POST['desc'],ENT_QUOTES,'UTF-8'));
    $idusu = intval($_POST['idusu']); // Convertir a entero
    $selecttip = strtoupper(htmlspecialchars($_POST['selecttip'],ENT_QUOTES,'UTF-8'));

    $nombrearchivo =strtoupper(htmlspecialchars($_POST['nombrearchivo'],ENT_QUOTES,'UTF-8'));

    // Recibir el valor de visibilidad pública (0 o 1)
    $visible_publico = isset($_POST['visible_publico']) ? intval($_POST['visible_publico']) : 0;

    // Si hay archivo, validarlo y moverlo ANTES de registrar en BD
    if(!empty($nombrearchivo)){
        // Validar que se haya enviado un archivo
        if (!isset($_FILES['archivoobj']) || $_FILES['archivoobj']['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(['success' => false, 'message' => 'Error: No se recibió el archivo correctamente']);
            exit;
        }

        // Validar extensión del archivo
        $archivo_temp = $_FILES['archivoobj']['tmp_name'];
        $extension = strtolower(pathinfo($nombrearchivo, PATHINFO_EXTENSION));
        $extensiones_permitidas = ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png'];

        if (!in_array($extension, $extensiones_permitidas)) {
            echo json_encode(['success' => false, 'message' => 'Error: Tipo de archivo no permitido']);
            exit;
        }

        // Validar tamaño del archivo (máximo 10MB)
        $tamano_maximo = 10 * 1024 * 1024;
        if ($_FILES['archivoobj']['size'] > $tamano_maximo) {
            echo json_encode(['success' => false, 'message' => 'Error: El archivo excede el tamaño máximo de 10MB']);
            exit;
        }

        // Crear carpeta si no existe
        $carpeta_destino = "docs/";
        if (!file_exists($carpeta_destino)) {
            if (!mkdir($carpeta_destino, 0777, true)) {
                echo json_encode(['success' => false, 'message' => 'Error: No se pudo crear la carpeta de destino']);
                exit;
            }
        }

        // Mover el archivo
        $ruta_completa = $carpeta_destino . $nombrearchivo;
        if (!move_uploaded_file($archivo_temp, $ruta_completa)) {
            echo json_encode(['success' => false, 'message' => 'Error: No se pudo guardar el archivo']);
            exit;
        }

        // Verificar que el archivo se guardó correctamente
        if (!file_exists($ruta_completa) || filesize($ruta_completa) == 0) {
            if (file_exists($ruta_completa)) {
                unlink($ruta_completa);
            }
            echo json_encode(['success' => false, 'message' => 'Error: El archivo no se guardó correctamente']);
            exit;
        }

        $ruta = 'controller/tramite_area/docs/'.$nombrearchivo;
    } else {
        $ruta = "";
    }

    // DEBUG: Log de parámetros
    error_log("DEBUG - Parámetros: iddo=$iddo, orig=$orig, dest=$dest, desc=$desc, idusu=$idusu, ruta=$ruta, selecttip=$selecttip, visible_publico=$visible_publico");

    // Solo si el archivo se guardó correctamente (o no hay archivo), registrar en BD
    $consulta = $MU->Registrar_Tramite($iddo,$orig,$dest,$desc,$idusu,$ruta,$selecttip,$visible_publico);

    error_log("DEBUG - Resultado consulta: $consulta");

    if($consulta==1){
        // Registro exitoso
        echo $consulta;
    } else {
        // Si falla el registro y había archivo, eliminarlo
        if(!empty($nombrearchivo) && file_exists($ruta_completa)){
            unlink($ruta_completa);
        }
        echo json_encode(['success' => false, 'message' => 'Error: No se pudo registrar el trámite']);
    }

?>