<?php
    require "../../model/model_tramite.php";
    $MU = new Modelo_Tramite();//Instaciamos

    // Validar que se haya enviado un archivo
    if (!isset($_FILES['archivoobj']) || $_FILES['archivoobj']['error'] !== UPLOAD_ERR_OK) {
        echo json_encode(['success' => false, 'message' => 'Error: No se recibió el archivo correctamente']);
        exit;
    }

    //datos del remitente
    $dni =strtoupper(htmlspecialchars($_POST['dni'],ENT_QUOTES,'UTF-8'));
    $nom =strtoupper(htmlspecialchars($_POST['nom'],ENT_QUOTES,'UTF-8'));
    $apt =strtoupper(htmlspecialchars($_POST['apt'],ENT_QUOTES,'UTF-8'));
    $apm =strtoupper(htmlspecialchars($_POST['apm'],ENT_QUOTES,'UTF-8'));
    $cel =strtoupper(htmlspecialchars($_POST['cel'],ENT_QUOTES,'UTF-8'));
    $ema =strtoupper(htmlspecialchars($_POST['ema'],ENT_QUOTES,'UTF-8'));
    $dir =strtoupper(htmlspecialchars($_POST['dir'],ENT_QUOTES,'UTF-8'));
    $vpresentacion =strtoupper(htmlspecialchars($_POST['vpresentacion'],ENT_QUOTES,'UTF-8'));
    $ruc =strtoupper(htmlspecialchars($_POST['ruc'],ENT_QUOTES,'UTF-8'));
    $raz =strtoupper(htmlspecialchars($_POST['raz'],ENT_QUOTES,'UTF-8'));

    //Datos del documnento
    $proc =strtoupper(htmlspecialchars($_POST['proc'],ENT_QUOTES,'UTF-8'));
    $arp =strtoupper(htmlspecialchars($_POST['arp'],ENT_QUOTES,'UTF-8'));
    $ard =strtoupper(htmlspecialchars($_POST['ard'],ENT_QUOTES,'UTF-8'));
    $tip =strtoupper(htmlspecialchars($_POST['tip'],ENT_QUOTES,'UTF-8'));
    $ndo =strtoupper(htmlspecialchars($_POST['ndo'],ENT_QUOTES,'UTF-8'));
    $asu =strtoupper(htmlspecialchars($_POST['asu'],ENT_QUOTES,'UTF-8'));
    $nombrearchivo =strtoupper(htmlspecialchars($_POST['nombrearchivo'],ENT_QUOTES,'UTF-8'));
    $fol =strtoupper(htmlspecialchars($_POST['fol'],ENT_QUOTES,'UTF-8'));
    $idusu =strtoupper(htmlspecialchars($_POST['idusu'],ENT_QUOTES,'UTF-8'));

    // Validar extensión del archivo
    $archivo_temp = $_FILES['archivoobj']['tmp_name'];
    $extension = strtolower(pathinfo($nombrearchivo, PATHINFO_EXTENSION));
    $extensiones_permitidas = ['pdf', 'doc', 'docx', 'jpg', 'jpeg', 'png'];

    if (!in_array($extension, $extensiones_permitidas)) {
        echo json_encode(['success' => false, 'message' => 'Error: Tipo de archivo no permitido']);
        exit;
    }

    // Validar tamaño del archivo (máximo 10MB)
    $tamano_maximo = 10 * 1024 * 1024; // 10MB en bytes
    if ($_FILES['archivoobj']['size'] > $tamano_maximo) {
        echo json_encode(['success' => false, 'message' => 'Error: El archivo excede el tamaño máximo de 10MB']);
        exit;
    }

    // Crear carpeta si no existe
    $carpeta_destino = "docs/";
    if (!file_exists($carpeta_destino)) {
        if (!mkdir($carpeta_destino, 0777, true)) {
            echo json_encode(['success' => false, 'message' => 'Error: No se pudo crear la carpeta de destino']);
            exit;
        }
    }

    // Intentar mover el archivo ANTES de registrar en la base de datos
    $ruta_completa = $carpeta_destino . $nombrearchivo;
    if (!move_uploaded_file($archivo_temp, $ruta_completa)) {
        echo json_encode(['success' => false, 'message' => 'Error: No se pudo guardar el archivo']);
        exit;
    }

    // Verificar que el archivo se guardó correctamente
    if (!file_exists($ruta_completa) || filesize($ruta_completa) == 0) {
        // Si el archivo no existe o está vacío, eliminarlo y reportar error
        if (file_exists($ruta_completa)) {
            unlink($ruta_completa);
        }
        echo json_encode(['success' => false, 'message' => 'Error: El archivo no se guardó correctamente']);
        exit;
    }

    // Solo si el archivo se guardó correctamente, registrar en la base de datos
    $ruta = 'controller/tramite/docs/'.$nombrearchivo;
    $consulta = $MU->Registrar_Tramite_Interno($dni,$nom,$apt,$apm,$cel,$ema,$dir,$vpresentacion,$ruc,$raz,$proc,$arp,$ard,$tip,$ndo,$asu,$ruta,$fol,$idusu);

    if($consulta){
        // Registro exitoso
        echo $consulta;
    } else {
        // Si falla el registro, eliminar el archivo que se guardó
        if (file_exists($ruta_completa)) {
            unlink($ruta_completa);
        }
        echo json_encode(['success' => false, 'message' => 'Error: No se pudo registrar el trámite']);
    }

?>