<?php
    require "../../model/model_entidad.php";
    $MU = new Modelo_Entidad();//Instaciamos
    $id =$_POST['id'];
    $nome =strtoupper(htmlspecialchars($_POST['txt_nombreentidad'],ENT_QUOTES,'UTF-8'));
    $cen =strtoupper(htmlspecialchars($_POST['txt_correoentidad'],ENT_QUOTES,'UTF-8'));
    $tele =strtoupper(htmlspecialchars($_POST['txt_telefonoentidad'],ENT_QUOTES,'UTF-8'));
    $ruc =strtoupper(htmlspecialchars($_POST['txt_rucentidad'],ENT_QUOTES,'UTF-8'));
    $dir =strtoupper(htmlspecialchars($_POST['txt_direccionentidad'],ENT_QUOTES,'UTF-8'));
    $nombrearchivo =strtoupper(htmlspecialchars($_POST['nombrearchivo'],ENT_QUOTES,'UTF-8'));

    // Si hay archivo, validarlo y moverlo ANTES de registrar en BD
    if(!empty($nombrearchivo)){
        // Validar que se haya enviado un archivo
        if (!isset($_FILES['archivoobj']) || $_FILES['archivoobj']['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(['success' => false, 'message' => 'Error: No se recibió el archivo correctamente']);
            exit;
        }

        // Validar extensión del archivo (solo imágenes para logo)
        $archivo_temp = $_FILES['archivoobj']['tmp_name'];
        $extension = strtolower(pathinfo($nombrearchivo, PATHINFO_EXTENSION));
        $extensiones_permitidas = ['jpg', 'jpeg', 'png', 'gif', 'svg'];

        if (!in_array($extension, $extensiones_permitidas)) {
            echo json_encode(['success' => false, 'message' => 'Error: Solo se permiten imágenes (JPG, PNG, GIF, SVG)']);
            exit;
        }

        // Validar tamaño del archivo (máximo 5MB para logos)
        $tamano_maximo = 5 * 1024 * 1024;
        if ($_FILES['archivoobj']['size'] > $tamano_maximo) {
            echo json_encode(['success' => false, 'message' => 'Error: La imagen excede el tamaño máximo de 5MB']);
            exit;
        }

        // Crear carpeta si no existe
        $carpeta_destino = "foto/";
        if (!file_exists($carpeta_destino)) {
            if (!mkdir($carpeta_destino, 0777, true)) {
                echo json_encode(['success' => false, 'message' => 'Error: No se pudo crear la carpeta de destino']);
                exit;
            }
        }

        // Mover el archivo
        $ruta_completa = $carpeta_destino . $nombrearchivo;
        if (!move_uploaded_file($archivo_temp, $ruta_completa)) {
            echo json_encode(['success' => false, 'message' => 'Error: No se pudo guardar el logo']);
            exit;
        }

        // Verificar que el archivo se guardó correctamente
        if (!file_exists($ruta_completa) || filesize($ruta_completa) == 0) {
            if (file_exists($ruta_completa)) {
                unlink($ruta_completa);
            }
            echo json_encode(['success' => false, 'message' => 'Error: El logo no se guardó correctamente']);
            exit;
        }

        $ruta = 'controller/entidad/foto/'.$nombrearchivo;
    } else {
        $ruta = "";
    }

    $consulta = $MU->Modificar_Entidad($id,$nome,$cen,$tele,$ruc,$dir,$ruta);

    if($consulta==1){
        // Modificación exitosa
        echo $consulta;
    } else {
        // Si falla la modificación y había archivo, eliminarlo
        if(!empty($nombrearchivo) && file_exists($ruta_completa)){
            unlink($ruta_completa);
        }
        echo $consulta;
    }

?>