-- ========================================
-- CAMBIAR DEFINIDOR DE TODOS LOS STORED PROCEDURES
-- ========================================
-- Este script cambia el definidor de todos los SP a munimor9@localhost

-- IMPORTANTE: Ejecuta este script en phpMyAdmin con el usuario munimor9

-- Primero, verificar los SP actuales y sus definidores
SELECT
    ROUTINE_NAME,
    DEFINER,
    ROUTINE_TYPE
FROM information_schema.ROUTINES
WHERE ROUTINE_SCHEMA = 'munimor9_bdmoralestramite'
AND ROUTINE_TYPE = 'PROCEDURE';

-- ========================================
-- OPCIÓN 1: Recrear cada SP manualmente
-- ========================================
-- Debes obtener el código de cada SP y recrearlo con DEFINER

-- Para ver el código de un SP específico:
-- SHOW CREATE PROCEDURE nombre_del_sp;

-- ========================================
-- OPCIÓN 2: Script automatizado (RECOMENDADO)
-- ========================================
-- Este script genera los comandos DROP y CREATE para cada SP

SELECT CONCAT(
    'DROP PROCEDURE IF EXISTS `', ROUTINE_NAME, '`; ',
    'DELIMITER $$ ',
    'CREATE DEFINER=`munimor9`@`localhost` PROCEDURE `', ROUTINE_NAME, '`(...) BEGIN ... END$$ ',
    'DELIMITER ;'
) AS comando
FROM information_schema.ROUTINES
WHERE ROUTINE_SCHEMA = 'munimor9_bdmoralestramite'
AND ROUTINE_TYPE = 'PROCEDURE';

-- ========================================
-- SOLUCIÓN DIRECTA (para cada SP individualmente)
-- ========================================
-- Ejemplo de cómo recrear UN stored procedure con el nuevo definidor:

-- 1. Ver el código actual
SHOW CREATE PROCEDURE SP_REGISTRAR_TRAMITE_DERIVAR;

-- 2. Copiar el código y modificar la línea CREATE PROCEDURE
-- Cambiar de: CREATE PROCEDURE nombre
-- A: CREATE DEFINER=`munimor9`@`localhost` PROCEDURE nombre

-- 3. Ejecutar DROP y luego el CREATE modificado
